package com.biz.crm.listener.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.listener.service.ITaListenerService;
import com.biz.crm.nebular.activiti.listener.req.TaListenerReqVo;
import com.biz.crm.nebular.activiti.listener.resp.TaListenerRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * activiti监听器接口
 *
 * @author jerry7
 * @date 2020-12-03 09:46:08
 */
@Slf4j
@RestController
@RequestMapping("/TaListenerController")
@Api(tags = "activiti监听器接口")
public class TaListenerController {
    @Autowired
    private ITaListenerService taListenerService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TaListenerRespVo>> list(@RequestBody TaListenerReqVo taListenerReqVo) {
        PageResult<TaListenerRespVo> result = taListenerService.findList(taListenerReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TaListenerRespVo> query(@RequestParam(value = "id", required = false) String id) {
        TaListenerRespVo respVo = taListenerService.query(id);
        return Result.ok(respVo);
    }


    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody TaListenerReqVo taListenerReqVo) {
        taListenerService.save(taListenerReqVo);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody TaListenerReqVo taListenerReqVo) {
        taListenerService.update(taListenerReqVo);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        taListenerService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        taListenerService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        taListenerService.disableBatch(ids);
        return Result.ok("禁用成功");
    }


    /**
     *
     */
    @ApiOperation(value = "查询未绑定监听器列表")
    @PostMapping("/queryNotBinding")
    @CrmLog
    public Result<PageResult<TaListenerRespVo>> queryNotBinding(@RequestBody TaListenerReqVo taListenerReqVo) {
        PageResult<TaListenerRespVo> result = taListenerService.queryBotBinding(taListenerReqVo);
        return Result.ok(result);
    }

}
