package com.biz.crm.listener.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.listener.service.ITaListenerProcService;
import com.biz.crm.nebular.activiti.listener.req.TaListenerProcReqVo;
import com.biz.crm.nebular.activiti.listener.req.TaListenerQueryVO;
import com.biz.crm.nebular.activiti.listener.resp.TaListenerProcRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 活动节点绑定监听器
 *
 * @author jerry7
 * @date 2020-12-03 09:46:08
 */
@Slf4j
@RestController
@RequestMapping("/talistenerprocController")
@Api(tags = "活动节点绑定监听器")
public class TaListenerProcController {
    @Autowired
    private ITaListenerProcService taListenerProcService;

    /**
     * 列表
     */
    @ApiOperation(value = "查询列表")
    @PostMapping("/list")
    @CrmLog
    public Result<PageResult<TaListenerProcRespVo>> list(@RequestBody TaListenerProcReqVo taListenerProcReqVo) {
        PageResult<TaListenerProcRespVo> result = taListenerProcService.findList(taListenerProcReqVo);
        return Result.ok(result);
    }

    /**
     * 查询
     */
    @ApiOperation(value = "查询")
    @GetMapping("/query")
    @CrmLog
    public Result<TaListenerProcRespVo> query(@RequestParam(value = "id", required = false) String id) {
        AssertUtils.isNotEmpty(id, "请传入查询id");
        TaListenerProcRespVo respVo = taListenerProcService.query(id);
        return Result.ok(respVo);
    }

    /**
     * 新增
     */
    @ApiOperation(value = "新增")
    @PostMapping("/save")
    @CrmLog
    public Result save(@RequestBody List<TaListenerProcReqVo> taListenerProcReqVos) {
        taListenerProcService.save(taListenerProcReqVos);
        return Result.ok();
    }

    /**
     * 更新
     */
    @ApiOperation(value = "更新")
    @PostMapping("/update")
    @CrmLog
    public Result update(@RequestBody List<TaListenerProcReqVo> taListenerProcReqVos) {
        taListenerProcService.update(taListenerProcReqVos);
        return Result.ok("修改成功");
    }

    /**
     * 删除
     */
    @ApiOperation(value = "删除")
    @PostMapping("/delete")
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        taListenerProcService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    /**
     * 启用
     */
    @ApiOperation(value = "启用")
    @PostMapping("/enable")
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        taListenerProcService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    /**
     * 禁用
     */
    @ApiOperation(value = "禁用")
    @PostMapping("/disable")
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        taListenerProcService.disableBatch(ids);
        return Result.ok("禁用成功");
    }


    /**
     * 查询
     */
    @ApiOperation(value = "根据节点查询监听器列表")
    @PostMapping("/queryByNode")
    @CrmLog
    public Result<List<TaListenerQueryVO>> queryByNode(@RequestBody TaListenerQueryVO taListenerProcReqVo) {
        List<TaListenerQueryVO> respVo = taListenerProcService.queryByNode(taListenerProcReqVo);
        return Result.ok(respVo);
    }

}
