package com.biz.crm.listener.model;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.sqlupdate.CrmColumn;
import com.biz.crm.sqlupdate.CrmTable;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 实体类
 *
 * @author jerry7
 * @date 2020-12-03 09:46:08
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@TableName("ta_listener")
@CrmTable(name = "ta_listener",tableNote = "流程-监听器")
public class TaListenerEntity  extends CrmBaseEntity<TaListenerEntity> {

    /**
     * 监听器事件(start,end,create,complete)
     */
    @CrmColumn(name = "listener_event", length = 32,note = "监听器事件")
    private String listenerEvent;

    /**
     * 监听器名称
     */
    @CrmColumn(name = "listener_name", length = 200,note = "监听器名称")
    private String listenerName;

    /**
     * 监听器类别(CLASS)
     */
    @CrmColumn(name = "listener_type", length = 32,note = "监听器类型-表达式- expression ,JAVA监听扩展类-javaClass")
    private String listenerType;

    /**
     * 监听器路径
     */
    @CrmColumn(name = "listener_value", length = 200,note = "监听器内容/类路径")
    private String listenerValue;

    @CrmColumn(name = "type_id",mysqlType = "int(6)", oracleType = "NUMBER(6,0)",note = "监听类型ID,1-执行监听器，2-任务监听器")
    private Integer typeId;

    @CrmColumn(name = "default_listener",mysqlType = "int(1)", oracleType = "NUMBER(1,0)",note = "是否默认监听器")
    private Integer defaultListener;

}
