package com.biz.crm.listener.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.listener.model.TaListenerEntity;
import com.biz.crm.nebular.activiti.listener.req.TaListenerQueryVO;
import com.biz.crm.nebular.activiti.listener.req.TaListenerReqVo;
import com.biz.crm.nebular.activiti.listener.resp.TaListenerRespVo;

import java.util.List;

/**
 * activiti监听器接口
 *
 * @author jerry7
 * @date 2020-12-03 09:46:08
 */
public interface ITaListenerService extends IService<TaListenerEntity> {

    /**
     * 列表
     * @param taListenerReqVo
     * @return PageResult<TaListenerRespVo>
     */
    PageResult<TaListenerRespVo> findList(TaListenerReqVo taListenerReqVo);

    /**
     * 查询
     * @param id
     * @return TaListenerRespVo
     */
    TaListenerRespVo query(String id);

    /**
     * 新增
     * @param taListenerReqVo
     * @return
     */
    void save(TaListenerReqVo taListenerReqVo);

    /**
     * 更新
     * @param taListenerReqVo
     * @return
     */
    void update(TaListenerReqVo taListenerReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 条件查询
     * @param queryVO
     * @return
     */
    List<TaListenerQueryVO> findExtListenerList(TaListenerQueryVO queryVO);

        /**
         * 启用
         * @param ids
         */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     */
    void disableBatch(List<String> ids);

    /**
     * 获取未绑定列表
     * @param taListenerReqVo
     * @return PageResult<TaListenerRespVo>
     */
    PageResult<TaListenerRespVo> queryBotBinding(TaListenerReqVo taListenerReqVo);


}

