package com.biz.crm.listener.task;

import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.config.SpringApplicationContextUtil;
import com.biz.crm.design.util.WorkFlowGlobals;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.util.CollectionUtil;
import lombok.extern.slf4j.Slf4j;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.listener.task
 * @Description: 提交人组织及其上级组织监听器 用此简体必须配置候选 角色
 * @date 2021/4/21 下午2:48
 */
@Slf4j
@Component
public class OrgUpAllowPosNulListener implements TaskListener {
    @Override
    /**
     * 此监听器意义在于 根据提交人组织往上级组织查询，当上级组织存在下的人 存在工作流配置候选流程角色就是审批人，如果没有查询到则报错
     */
    public void notify(DelegateTask delegateTask) {
        log.info("====> 提交人组织及其上级组织监听器");
        //当前节点流程编码
        Object org = delegateTask.getVariables().get(WorkFlowGlobals.COMMIT_ORG);
        String commitOrg = null;
        if (org != null && StringUtils.isNotBlank(org.toString())) {
            commitOrg = org.toString();
        }
        if (StringUtils.isEmpty(commitOrg)) {
            throw new BusinessException("提交人组织为空[" + delegateTask.getName() + "]按组织寻岗异常，请驳回，重新提交");
        }
        List<IdentityLinkEntity> linkEntities = ((TaskEntity) delegateTask).getIdentityLinks();
        List<String> bpmRoleCodes = new ArrayList<>();
        for(IdentityLinkEntity item : linkEntities){
            if(WorkFlowGlobals.CANDIDATE.equals(item.getType())&&StringUtils.isNotBlank(item.getGroupId())){
                //候选者中存在流程角色编码
                bpmRoleCodes.add(item.getGroupId());
            }
        }
        if(CollectionUtil.listEmpty(bpmRoleCodes)){
           throw new BusinessException("["+delegateTask.getName()+"]"+"未设置流程角色，请检查是否使用【组织及其上级组织监听器");
        }
        if(bpmRoleCodes.size()>1){
            throw new BusinessException("["+delegateTask.getName()+"]"+"候选者流程角色存在多个，请检查配置");
        }

        MdmPositionFeign mdmPositionFeign = SpringApplicationContextUtil.getApplicationContext().getBean(MdmPositionFeign.class);
        List<MdmPositionUserOrgRespVo> positionUserOrgRespVos = ApiResultUtil.objResult(mdmPositionFeign.findPositionListByBpmRoleStartUpByOrgCode(commitOrg,bpmRoleCodes.get(0)),true);
        if(CollectionUtil.listEmpty(positionUserOrgRespVos)){
//            throw new BusinessException("流程角色"+bpmRoleCodes.get(0)+"未配置对应岗位");
        }else {
            //删除候选角色，换成对应职位
            bpmRoleCodes.forEach(item->{
                delegateTask.deleteCandidateGroup(item);
            });
            List<String> posCodes = positionUserOrgRespVos.stream().map(MdmPositionUserOrgRespVo::getPositionCode).collect(Collectors.toList());
            delegateTask.addCandidateUsers(posCodes);
        }

    }
}
