package com.biz.crm.listener.task;

import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import lombok.extern.slf4j.Slf4j;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * @author jianglong
 * @version V1.0
 * @Package com.biz.crm.listener.task
 * @Description: 当前职位及其上级职位监听器
 * @date 2021/4/21 下午2:48
 */
@Slf4j
@Component
public class TestListener implements TaskListener {
    @Override
    public void notify(DelegateTask delegateTask) {
        log.info("进入测试监听器");
        Map<String, Object> variables = delegateTask.getVariables();
        String  list = (String)variables.get("posList");
        delegateTask.setAssignee(list);
    }
}
