package com.biz.crm.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * 业务对象-前端接收实体
 *
 * @author YuanZiJian
 * @date 2020/12/15 16:56
 * @version: V1.0
 */
@ApiModel(value = "RelationVo", description = "接收前端 业务编码和业务名称")
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
public class RelationVo {

    /**
     * 业务编码
     */
    @ApiModelProperty("业务编码")
    private String bizCode;
    /**
     * 业务名字
     */
    @ApiModelProperty("业务名称")
    private String bizName;

    @ApiModelProperty(value = "选中所有下级，默认为y")
    private String isOnlyCurrentOrg;
}
