/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.activiti.entity.ActivitiModelerEntity;
import com.biz.crm.activiti.mapper.ActivitiModelerMapper;
import com.biz.crm.activiti.service.IActivitiModelerService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.modeler.req.ActivitiModelerReqVo;
import com.biz.crm.nebular.activiti.modeler.resp.ActivitiModelerRespVo;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"ActivitiModelerServiceImpl"})
public class ActivitiModelerServiceImpl
extends ServiceImpl<ActivitiModelerMapper, ActivitiModelerEntity>
implements IActivitiModelerService {
    private static final Logger log = LoggerFactory.getLogger(ActivitiModelerServiceImpl.class);
    @Resource
    private ActivitiModelerMapper activitiModelerMapper;
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public PageResult<ActivitiModelerRespVo> findList(ActivitiModelerReqVo activitiModelerReqVo) {
        Page page = new Page((long)activitiModelerReqVo.getPageNum().intValue(), (long)activitiModelerReqVo.getPageSize().intValue());
        List<ActivitiModelerRespVo> list = this.activitiModelerMapper.findList((Page<ActivitiModelerRespVo>)page, activitiModelerReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public ObjectNode query(String modelId) {
        ObjectNode modelNode = null;
        Model model = this.repositoryService.getModel(modelId);
        if (model != null) {
            try {
                if (StringUtils.isNotEmpty((CharSequence)model.getMetaInfo())) {
                    modelNode = (ObjectNode)this.objectMapper.readTree(model.getMetaInfo());
                } else {
                    modelNode = this.objectMapper.createObjectNode();
                    modelNode.put("name", model.getName());
                }
                modelNode.put("modelId", model.getId());
                ObjectNode editorJsonNode = (ObjectNode)this.objectMapper.readTree(new String(this.repositoryService.getModelEditorSource(model.getId()), "utf-8"));
                modelNode.put("model", (JsonNode)editorJsonNode);
            }
            catch (Exception e) {
                log.error("Error creating model JSON", (Throwable)e);
                throw new ActivitiException("Error creating model JSON", (Throwable)e);
            }
        }
        try {
            modelNode = this.objectMapper.createObjectNode();
            modelNode.put("name", "new-process");
            modelNode.put("modelId", "");
            ObjectNode editorJsonNode = (ObjectNode)this.objectMapper.readTree("{\"id\":\"canvas\",\"resourceId\":\"canvas\",\"stencilset\":{\"namespace\":\"http://b3mn.org/stencilset/bpmn2.0#\"}}");
            modelNode.put("model", (JsonNode)editorJsonNode);
        }
        catch (IOException e) {
            log.error("Error creating model JSON", (Throwable)e);
            throw new ActivitiException("Error creating model JSON", (Throwable)e);
        }
        return modelNode;
    }

    @Override
    public void save(String modelId, String name, String description, String json_xml, String svg_xml) {
        try {
            Model model = null;
            if (StringUtils.isEmpty((CharSequence)modelId)) {
                model = this.repositoryService.newModel();
                int revision = 1;
                String key = "process";
                ObjectNode modelNode = this.objectMapper.createObjectNode();
                modelNode.put("name", name);
                modelNode.put("revision", revision);
                modelNode.put("description", description);
                model.setName(name);
                model.setKey(key);
                model.setMetaInfo(modelNode.toString());
            } else {
                model = this.repositoryService.getModel(modelId);
            }
            ObjectNode modelJson = (ObjectNode)this.objectMapper.readTree(model.getMetaInfo());
            modelJson.put("name", name);
            modelJson.put("description", description);
            model.setName(name);
            model.setMetaInfo(modelJson.toString());
            this.repositoryService.saveModel(model);
            this.repositoryService.addModelEditorSource(model.getId(), json_xml.getBytes("utf-8"));
            ByteArrayInputStream svgStream = new ByteArrayInputStream(svg_xml.getBytes("utf-8"));
            TranscoderInput input = new TranscoderInput((InputStream)svgStream);
            PNGTranscoder transcoder = new PNGTranscoder();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            TranscoderOutput output = new TranscoderOutput((OutputStream)outStream);
            transcoder.transcode(input, output);
            byte[] result = outStream.toByteArray();
            this.repositoryService.addModelEditorSourceExtra(model.getId(), result);
            outStream.close();
        }
        catch (Exception e) {
            log.error("Error saving model", (Throwable)e);
            throw new ActivitiException("Error saving model", (Throwable)e);
        }
    }

    @Override
    public void delete(String id) {
        this.repositoryService.deleteModel(id);
    }

    @Override
    public void deployment(String id) throws Exception {
        Model modelData = this.repositoryService.getModel(id);
        byte[] bytes = this.repositoryService.getModelEditorSource(modelData.getId());
        if (bytes == null) {
            throw new BusinessException("\u6a21\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u8ba1\u6d41\u7a0b\u5e76\u6210\u529f\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u53d1\u5e03\u3002");
        }
        JsonNode modelNode = new ObjectMapper().readTree(bytes);
        BpmnModel model = new BpmnJsonConverter().convertToBpmnModel(modelNode);
        if (model.getProcesses().size() == 0) {
            throw new BusinessException("\u6570\u636e\u6a21\u578b\u4e0d\u7b26\u8981\u6c42\uff0c\u8bf7\u81f3\u5c11\u8bbe\u8ba1\u4e00\u6761\u4e3b\u7ebf\u6d41\u7a0b\u3002");
        }
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(model);
        String processName = modelData.getName() + ".bpmn20.xml";
        Deployment deployment = this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, "UTF-8")).deploy();
        modelData.setDeploymentId(deployment.getId());
        this.repositoryService.saveModel(modelData);
    }
}

