/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activiti.constant.ActivitiConstantsEnum;
import com.biz.crm.activiti.entity.ActivitiProcessLogEntity;
import com.biz.crm.activiti.mapper.ActivitiInstanceMapper;
import com.biz.crm.activiti.service.IActivitiInstanceService;
import com.biz.crm.activiti.service.IActivitiProcessLogService;
import com.biz.crm.activiti.service.IActivitiStartInfoService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.common.req.ActivitiCCCDataReqVo;
import com.biz.crm.nebular.activiti.common.req.ActivitiMyStartReqVo;
import com.biz.crm.nebular.activiti.common.resp.ActivitiCommonRespVo;
import com.biz.crm.nebular.activiti.start.req.ActivitiStartInfoReqVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"ActivitiInstanceServiceImpl"})
public class ActivitiInstanceServiceImpl
implements IActivitiInstanceService {
    @Resource
    private ActivitiInstanceMapper activitiInstanceMapper;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Resource
    private IActivitiProcessLogService iActivitiProcessLogService;
    @Resource
    private IActivitiStartInfoService iActivitiStartInfoService;

    @Override
    public PageResult<ActivitiCommonRespVo> findList(ActivitiMyStartReqVo activitiMyStartReqVo) {
        Page page = new Page((long)activitiMyStartReqVo.getPageNum().intValue(), (long)activitiMyStartReqVo.getPageSize().intValue());
        List<ActivitiCommonRespVo> list = this.activitiInstanceMapper.findList((Page<ActivitiCommonRespVo>)page, activitiMyStartReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void suspend(ActivitiStartInfoReqVo activitiStartInfoReqVo) {
        if (StringUtils.isEmpty((String)activitiStartInfoReqVo.getProcessInstanceId())) {
            throw new BusinessException("\u8bf7\u4f20\u5165\u6d41\u7a0b\u5b9e\u4f8bID");
        }
        this.runtimeService.suspendProcessInstanceById(activitiStartInfoReqVo.getProcessInstanceId());
        HashMap<String, String> columnMap = new HashMap<String, String>();
        columnMap.put("processInstanceId", activitiStartInfoReqVo.getProcessInstanceId());
        List startInfoEntityList = this.iActivitiStartInfoService.listByMap(columnMap);
        startInfoEntityList.stream().forEach(e -> {
            e.setFlowStatus(ActivitiConstantsEnum.FLOW_STATUS.SUSPEND.getCode());
            this.iActivitiStartInfoService.updateById(e);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void active(ActivitiStartInfoReqVo activitiStartInfoReqVo) {
        if (StringUtils.isEmpty((String)activitiStartInfoReqVo.getProcessInstanceId())) {
            throw new BusinessException("\u8bf7\u4f20\u5165\u6d41\u7a0b\u5b9e\u4f8bID");
        }
        this.runtimeService.activateProcessInstanceById(activitiStartInfoReqVo.getProcessInstanceId());
        HashMap<String, String> columnMap = new HashMap<String, String>();
        columnMap.put("processInstanceId", activitiStartInfoReqVo.getProcessInstanceId());
        List startInfoEntityList = this.iActivitiStartInfoService.listByMap(columnMap);
        startInfoEntityList.stream().forEach(e -> {
            e.setFlowStatus(ActivitiConstantsEnum.FLOW_STATUS.START.getCode());
            this.iActivitiStartInfoService.updateById(e);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void close(ActivitiStartInfoReqVo activitiStartInfoReqVo) {
        if (StringUtils.isEmpty((String)activitiStartInfoReqVo.getProcessInstanceId())) {
            throw new BusinessException("\u8bf7\u4f20\u5165\u6d41\u7a0b\u5b9e\u4f8bID");
        }
        List executionList = this.runtimeService.createExecutionQuery().processInstanceId(activitiStartInfoReqVo.getProcessInstanceId()).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)executionList)) {
            for (Execution execution : executionList) {
                this.runtimeService.setVariable(execution.getId(), "opt_status", (Object)ActivitiConstantsEnum.BPM_STATUS.CLOSE.getCode());
            }
        }
        this.runtimeService.deleteProcessInstance(activitiStartInfoReqVo.getProcessInstanceId(), UserUtils.getUser().getRealname() + "\u5173\u95ed\u6d41\u7a0b\u5b9e\u4f8b");
        HashMap<String, String> columnMap = new HashMap<String, String>();
        columnMap.put("processInstanceId", activitiStartInfoReqVo.getProcessInstanceId());
        List startInfoEntityList = this.iActivitiStartInfoService.listByMap(columnMap);
        startInfoEntityList.stream().forEach(e -> {
            e.setFlowStatus(ActivitiConstantsEnum.FLOW_STATUS.END.getCode());
            this.iActivitiStartInfoService.updateById(e);
        });
    }

    @Override
    public void reassign(ActivitiCCCDataReqVo activitiCCCDataReqVo) {
        if (StringUtils.isEmpty((String)activitiCCCDataReqVo.getPositionCode())) {
            throw new BusinessException("\u804c\u4f4d\u4e0d\u80fd\u7a7a");
        }
        List task = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(activitiCCCDataReqVo.getProcessInstanceId())).list();
        if (CollectionUtil.listEmpty((List)task)) {
            throw new BusinessException("\u4efb\u52a1\u8282\u70b9\u4e0d\u5b58\u5728");
        }
        this.taskService.setOwner(((Task)task.get(0)).getId(), UserUtils.getUser().getPoscode());
        this.taskService.setAssignee(((Task)task.get(0)).getId(), activitiCCCDataReqVo.getPositionCode());
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(activitiCCCDataReqVo.getProcessInstanceId()).singleResult();
        ActivitiProcessLogEntity logEntity = ActivitiProcessLogEntity.builder().businessId(processInstance.getBusinessKey()).detail("[\u8f6c\u529e]" + activitiCCCDataReqVo.getGtOpinion()).nodeName(((Task)task.get(0)).getName()).nodeDefKey(((Task)task.get(0)).getTaskDefinitionKey()).optTime(new Date()).optUser(UserUtils.getUser().getRealname()).optType(ActivitiConstantsEnum.OPT_TYPE.ZB.getCode()).processInstanceId(activitiCCCDataReqVo.getProcessInstanceId()).optPositionCode(UserUtils.getUser().getPoscode()).build();
        this.iActivitiProcessLogService.save((Object)logEntity);
    }
}

