/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.biz.crm.activiti.constant.ActivitiConstantsEnum;
import com.biz.crm.activiti.entity.ActivitiModelerEntity;
import com.biz.crm.activiti.entity.ActivitiProcessLogEntity;
import com.biz.crm.activiti.entity.ActivitiStartInfoEntity;
import com.biz.crm.activiti.mapper.ActivitiModelerMapper;
import com.biz.crm.activiti.service.IActivitiProcessLogService;
import com.biz.crm.activiti.service.IActivitiStartInfoService;
import com.biz.crm.activiti.service.IActivitiStartUpService;
import com.biz.crm.nebular.activiti.start.req.ActivitiStartInfoReqVo;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.Resource;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"ActivitiStartUpServiceImpl"})
public class ActivitiStartUpServiceImpl
implements IActivitiStartUpService {
    @Autowired
    private RuntimeService runtimeService;
    @Resource
    private ActivitiModelerMapper activitiModelerMapper;
    @Autowired
    private RepositoryService repositoryService;
    @Resource
    private IActivitiStartInfoService iActivitiStartInfoService;
    @Resource
    private IActivitiProcessLogService iActivitiProcessLogService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String startUp(ActivitiStartInfoReqVo activitiStartInfoReqVo) {
        ActivitiModelerEntity modelerEntity = (ActivitiModelerEntity)((Object)this.activitiModelerMapper.selectById((Serializable)((Object)activitiStartInfoReqVo.getModelId())));
        Assert.notNull((Object)((Object)modelerEntity), (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u6d41\u7a0b\u6a21\u578b\uff01");
        Assert.hasText((String)modelerEntity.getDeploymentId(), (String)"\u6d41\u7a0b\u8fd8\u672a\u53d1\u5e03\uff01");
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(modelerEntity.getDeploymentId()).singleResult();
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinition.getId(), activitiStartInfoReqVo.getBusinessId(), activitiStartInfoReqVo.getVariable());
        UserRedis userRedis = UserUtils.getUser();
        ActivitiStartInfoEntity infoEntity = ActivitiStartInfoEntity.builder().businessId(activitiStartInfoReqVo.getBusinessId()).detail(activitiStartInfoReqVo.getDetail()).modelId(activitiStartInfoReqVo.getModelId()).modelName(activitiStartInfoReqVo.getModelName()).processInstanceId(processInstance.getId()).startTime(new Date()).startUser(userRedis.getRealname()).title(activitiStartInfoReqVo.getTitle()).startPositionCode(userRedis.getPoscode()).startPositionName(userRedis.getPosname()).startOrgCode(userRedis.getOrgcode()).startOrgName(userRedis.getOrgname()).bpmStatus(ActivitiConstantsEnum.BPM_STATUS.APPROVAL.getCode()).flowStatus(ActivitiConstantsEnum.FLOW_STATUS.START.getCode()).build();
        this.iActivitiStartInfoService.save((Object)infoEntity);
        ActivitiProcessLogEntity logEntity = ActivitiProcessLogEntity.builder().businessId(activitiStartInfoReqVo.getBusinessId()).detail("\u53d1\u8d77\u6d41\u7a0b").nodeName("\u5f00\u59cb").optTime(new Date()).optUser(UserUtils.getUser().getRealname()).optType(ActivitiConstantsEnum.OPT_TYPE.TJ.getCode()).processInstanceId(processInstance.getId()).optPositionCode(userRedis.getPoscode()).build();
        this.iActivitiProcessLogService.save((Object)logEntity);
        return processInstance.getId();
    }
}

