/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activiti.constant.ActivitiConstantsEnum;
import com.biz.crm.activiti.entity.ActivitiProcessLogEntity;
import com.biz.crm.activiti.mapper.ActivitiMyStartMapper;
import com.biz.crm.activiti.service.IActivitiMyStartService;
import com.biz.crm.activiti.service.IActivitiProcessLogService;
import com.biz.crm.activiti.service.IActivitiStartInfoService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.common.req.ActivitiMyStartReqVo;
import com.biz.crm.nebular.activiti.common.resp.ActivitiCommonRespVo;
import com.biz.crm.nebular.activiti.start.req.ActivitiStartInfoReqVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.UserUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"ActivitiMyStartServiceImpl"})
public class ActivitiMyStartServiceImpl
implements IActivitiMyStartService {
    @Resource
    private ActivitiMyStartMapper activitiMyStartMapper;
    @Autowired
    private RuntimeService runtimeService;
    @Resource
    private IActivitiStartInfoService iActivitiStartInfoService;
    @Resource
    private IActivitiProcessLogService iActivitiProcessLogService;

    @Override
    public PageResult<ActivitiCommonRespVo> findList(ActivitiMyStartReqVo activitiMyStartReqVo) {
        Page page = new Page((long)activitiMyStartReqVo.getPageNum().intValue(), (long)activitiMyStartReqVo.getPageSize().intValue());
        List<ActivitiCommonRespVo> list = this.activitiMyStartMapper.findList((Page<ActivitiCommonRespVo>)page, activitiMyStartReqVo);
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(list).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void recover(ActivitiStartInfoReqVo activitiStartInfoReqVo) {
        ProcessInstance pi = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(activitiStartInfoReqVo.getProcessInstanceId()).singleResult();
        List executionList = this.runtimeService.createExecutionQuery().processInstanceId(activitiStartInfoReqVo.getProcessInstanceId()).list();
        if (pi == null) {
            throw new BusinessException("\u6d41\u7a0b\u5df2\u5b8c\u6210\u4e0d\u80fd\u8ffd\u56de");
        }
        HashMap<String, String> columnMap = new HashMap<String, String>();
        columnMap.put("processInstanceId", activitiStartInfoReqVo.getProcessInstanceId());
        List startInfoEntityList = this.iActivitiStartInfoService.listByMap(columnMap);
        startInfoEntityList.stream().forEach(e -> {
            if (e.getBpmStatus().equals(ActivitiConstantsEnum.BPM_STATUS.PASS.getCode()) || e.getBpmStatus().equals(ActivitiConstantsEnum.BPM_STATUS.CLOSE.getCode()) || e.getBpmStatus().equals(ActivitiConstantsEnum.BPM_STATUS.RECOVER.getCode())) {
                throw new BusinessException("\u6d41\u7a0b\u5df2\u5b8c\u6210\u4e0d\u80fd\u8ffd\u56de");
            }
            if (e.getBpmStatus().equals(ActivitiConstantsEnum.BPM_STATUS.REJECT.getCode())) {
                throw new BusinessException("\u6d41\u7a0b\u5df2\u9a73\u56de\u4e0d\u80fd\u8ffd\u56de");
            }
            e.setBpmStatus(ActivitiConstantsEnum.BPM_STATUS.RECOVER.getCode());
            e.setFlowStatus(ActivitiConstantsEnum.FLOW_STATUS.CALLBACK.getCode());
            this.iActivitiStartInfoService.updateById(e);
        });
        if (CollectionUtil.listNotEmptyNotSizeZero((List)executionList)) {
            for (Execution execution : executionList) {
                this.runtimeService.setVariable(execution.getId(), "opt_status", (Object)ActivitiConstantsEnum.BPM_STATUS.RECOVER.getCode());
            }
        }
        this.runtimeService.deleteProcessInstance(activitiStartInfoReqVo.getProcessInstanceId(), ActivitiConstantsEnum.BPM_STATUS.RECOVER.getCode());
        ActivitiProcessLogEntity logEntity = ActivitiProcessLogEntity.builder().processInstanceId(activitiStartInfoReqVo.getProcessInstanceId()).optType(ActivitiConstantsEnum.OPT_TYPE.ZH.getCode()).optUser(UserUtils.getUser().getRealname()).optTime(new Date()).nodeName("\u7ed3\u675f").detail("\u53d1\u8d77\u4eba\u8ffd\u56de\u6d41\u7a0b").businessId(pi.getBusinessKey()).build();
        this.iActivitiProcessLogService.save((Object)logEntity);
    }
}

