/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.design.controller;

import com.biz.crm.common.Result;
import com.biz.crm.design.service.ProcessInfoService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"process"})
public class ProcessController {
    private static final Logger log = LoggerFactory.getLogger(ProcessController.class);
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private ProcessInfoService processInfoService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"show"})
    public void show(@RequestParam(value="did") String did, @RequestParam(value="ext") String ext, HttpServletResponse httpServletResponse) throws IOException {
        if (StringUtils.isEmpty((CharSequence)did) || StringUtils.isEmpty((CharSequence)ext)) {
            return;
        }
        InputStream in = null;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(did).singleResult();
        if (".png".equalsIgnoreCase(ext)) {
            in = this.repositoryService.getProcessDiagram(processDefinition.getId());
        } else if (".bpmn".equalsIgnoreCase(ext)) {
            in = this.repositoryService.getResourceAsStream(did, processDefinition.getResourceName());
        }
        ServletOutputStream out = null;
        byte[] buf = new byte[1024];
        int legth = 0;
        try {
            out = httpServletResponse.getOutputStream();
            while ((legth = in.read(buf)) != -1) {
                out.write(buf, 0, legth);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    @PostMapping(value={"run/{key}"})
    public Result<String> run(@PathVariable String key, @RequestBody Map<String, Object> variables) {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(key, variables);
        log.info("\u542f\u52a8\u4e00\u4e2a\u6d41\u7a0b\u5b9e\u4f8b\uff0cid\u4e3a\uff1a{}", (Object)processInstance.getId());
        return new Result<String>(processInstance.getId());
    }

    @GetMapping(value={""})
    public Result<List<Map<String, Object>>> list() {
        List<Map<String, Object>> list = this.processInfoService.process();
        return new Result<List<Map<String, Object>>>(list);
    }

    @GetMapping(value={"/{proDefId}/elements"})
    public Result<List<Map<String, Object>>> listActivities(@PathVariable String proDefId) {
        ArrayList list = new ArrayList();
        BpmnModel model = this.repositoryService.getBpmnModel(proDefId);
        if (model != null) {
            Collection flowElements = model.getMainProcess().getFlowElements();
            for (FlowElement e : flowElements) {
                log.info("flowelement id:" + e.getId() + "  name:" + e.getName() + "   class:" + e.getClass().toString());
                if (!e.getClass().toString().equalsIgnoreCase("class org.activiti.bpmn.model.StartEvent") && !e.getClass().toString().equalsIgnoreCase("class org.activiti.bpmn.model.UserTask")) continue;
                HashMap<String, String> element = new HashMap<String, String>();
                element.put(e.getId(), e.getName());
                list.add(element);
            }
        }
        return new Result<List<Map<String, Object>>>(list);
    }
}

