/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.design.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.design.entity.TaProcessEntity;
import com.biz.crm.design.mapper.TaProcessMapper;
import com.biz.crm.design.service.TaProcessService;
import com.biz.crm.design.utils.BizStreamUtils;
import com.biz.crm.design.utils.XmlActivitiUtil;
import com.biz.crm.design.vo.TaProcessVO;
import com.biz.crm.eunm.activiti.Column;
import com.biz.crm.nebular.activiti.design.req.TaProcessInfoReqVO;
import com.biz.crm.nebular.activiti.design.resp.TaProcessInfoRespVO;
import com.biz.crm.util.AssertUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"TaProcessServiceImpl"})
public class TaProcessServiceImpl
extends ServiceImpl<TaProcessMapper, TaProcessEntity>
implements TaProcessService {
    @Resource
    private TaProcessMapper taProcessMapper;

    @Override
    public TaProcessEntity saveTaProcess(final TaProcessVO tpProcessVO) {
        if (tpProcessVO == null) {
            return null;
        }
        TaProcessEntity entity = null;
        if ("0".equals(tpProcessVO.getId())) {
            entity = new TaProcessEntity();
            List list = this.taProcessMapper.selectByMap(new HashMap<String, Object>(){
                {
                    this.put("process_key", tpProcessVO.getProcessKey());
                }
            });
            AssertUtils.isTrue((boolean)CollectionUtils.isEmpty((Collection)list), (String)"\u6d41\u7a0bKey\u91cd\u590d\u4e86");
        } else {
            entity = (TaProcessEntity)((Object)this.taProcessMapper.selectById((Serializable)((Object)tpProcessVO.getId())));
        }
        entity.setNote(tpProcessVO.getNote());
        entity.setProcessKey(tpProcessVO.getProcessKey());
        entity.setProcessName(tpProcessVO.getProcessName());
        entity.setProcessState(tpProcessVO.getProcessState());
        String xml = tpProcessVO.getProcessDescriptor();
        Map<String, String> nodeRoles = null;
        Map<String, Map<String, String>> nodePropertiesMap = this.buildNodesMultiProperties(tpProcessVO.getNodes());
        try {
            nodeRoles = XmlActivitiUtil.getActNodeUserRoles(xml);
            xml = XmlActivitiUtil.addDefListenerXml(xml);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        if (nodePropertiesMap != null && !nodePropertiesMap.isEmpty()) {
            try {
                xml = XmlActivitiUtil.addMultiInstanceProperties(xml, nodePropertiesMap);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        entity.setProcessXml(BizStreamUtils.StringTObyte(this.translateFormula(xml)));
        if (StringUtils.isNotEmpty((CharSequence)entity.getId())) {
            this.taProcessMapper.updateById((Object)entity);
        } else {
            this.taProcessMapper.insert((Object)entity);
        }
        return entity;
    }

    private Map<String, Map<String, String>> buildNodesMultiProperties(String nodes) {
        String[] nodeArr = nodes.split("@@@");
        int num = nodeArr.length;
        HashMap nodePropMap = null;
        if (num > 1) {
            nodePropMap = new HashMap();
            for (int i = 0; i < num; ++i) {
                HashMap<String, String> propMap = new HashMap<String, String>();
                String[] node = nodeArr[i].split("###");
                int proNum = node.length;
                if (proNum > 0) {
                    for (int j = 0; j < proNum; ++j) {
                        String[] properties = node[j].split("=");
                        if (properties.length <= 1) continue;
                        propMap.put(properties[0], properties[1]);
                    }
                }
                if (propMap.size() <= 0) continue;
                nodePropMap.put(propMap.get("id"), propMap);
            }
        }
        return nodePropMap;
    }

    private String translateFormula(String xml) {
        return xml.replace("&gt;", ">").replace("&lt; ", "<").replace("&amp;", "&");
    }

    @Override
    public PageResult<TaProcessInfoRespVO> getProcessInfoList(TaProcessInfoReqVO reqVO) {
        Page page = new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue());
        List<TaProcessInfoRespVO> list = this.taProcessMapper.getProcessInfoList((Page<TaProcessInfoRespVO>)page, reqVO);
        if (CollectionUtils.isNotEmpty(list)) {
            for (TaProcessInfoRespVO vo : list) {
                vo.setProcessStateDesc(Column.PROCESS_STATE.getLabelByCode(vo.getProcessState()));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

