/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.listener.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.listener.service.ITaListenerService;
import com.biz.crm.nebular.activiti.listener.req.TaListenerReqVo;
import com.biz.crm.nebular.activiti.listener.resp.TaListenerRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/TaListenerController"})
@Api(tags={"activiti\u76d1\u542c\u5668\u63a5\u53e3"})
public class TaListenerController {
    private static final Logger log = LoggerFactory.getLogger(TaListenerController.class);
    @Autowired
    private ITaListenerService taListenerService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<TaListenerRespVo>> list(@RequestBody TaListenerReqVo taListenerReqVo) {
        PageResult<TaListenerRespVo> result = this.taListenerService.findList(taListenerReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"/query"})
    @CrmLog
    public Result<TaListenerRespVo> query(@RequestParam(value="id", required=false) String id) {
        TaListenerRespVo respVo = this.taListenerService.query(id);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody TaListenerReqVo taListenerReqVo) {
        this.taListenerService.save(taListenerReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody TaListenerReqVo taListenerReqVo) {
        this.taListenerService.update(taListenerReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.taListenerService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.taListenerService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.taListenerService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }
}

