/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activiti.mapper.ActivitiMyTaskMapper;
import com.biz.crm.activiti.service.IActivitiMyTaskService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.activiti.Column;
import com.biz.crm.eunm.activiti.ColumnStr;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.nebular.activiti.common.req.ActivitiMyStartReqVo;
import com.biz.crm.nebular.activiti.common.resp.ActivitiCommonRespVo;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.start.req.ProcessInfoReqVO;
import com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.activiti.task.resp.ProcessInfoRspVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"ActivitiMyTaskServiceImpl"})
public class ActivitiMyTaskServiceImpl
implements IActivitiMyTaskService {
    @Resource
    private ActivitiMyTaskMapper activitiMyTaskMapper;

    @Override
    public PageResult<ActivitiCommonRespVo> findList(ActivitiMyStartReqVo activitiMyStartReqVo) {
        Page page = new Page((long)activitiMyStartReqVo.getPageNum().intValue(), (long)activitiMyStartReqVo.getPageSize().intValue());
        List<ActivitiCommonRespVo> list = this.activitiMyTaskMapper.findList((Page<ActivitiCommonRespVo>)page, activitiMyStartReqVo);
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(list).build();
    }

    @Override
    public PageResult<TaskRspVO> findMyCurrentTask(TaskQueryReqVO reqVO) {
        Page taskRspVOPage = PageUtil.buildPage((Integer)reqVO.getPageNum(), (Integer)reqVO.getPageSize());
        List<TaskRspVO> taskRspVOS = this.activitiMyTaskMapper.queryCurrent((Page<TaskRspVO>)taskRspVOPage, reqVO);
        taskRspVOS.forEach(taskRspVO -> taskRspVO.setProcessStateDesc(Column.ACT_BASE_STATUS.getLabelByCode(taskRspVO.getProcessState())));
        return PageResult.builder().count(Long.valueOf(taskRspVOPage.getTotal())).data(taskRspVOS).build();
    }

    @Override
    public PageResult<TaskRspVO> findDoneTask(TaskQueryReqVO reqVO) {
        Page taskRspVOPage = PageUtil.buildPage((Integer)reqVO.getPageNum(), (Integer)reqVO.getPageSize());
        List<TaskRspVO> taskRspVOS = this.activitiMyTaskMapper.queryDone((Page<TaskRspVO>)taskRspVOPage, reqVO);
        taskRspVOS.forEach(taskRspVO -> taskRspVO.setProcessStateDesc(Column.ACT_BASE_STATUS.getLabelByCode(taskRspVO.getProcessState())));
        return PageResult.builder().count(Long.valueOf(taskRspVOPage.getTotal())).data(taskRspVOS).build();
    }

    @Override
    public PageResult<TaskRspVO> findStartTask(TaskQueryReqVO reqVO) {
        Page taskRspVOPage = PageUtil.buildPage((Integer)reqVO.getPageNum(), (Integer)reqVO.getPageSize());
        List<TaskRspVO> taskRspVOS = this.activitiMyTaskMapper.queryStart((Page<TaskRspVO>)taskRspVOPage, reqVO);
        taskRspVOS.forEach(taskRspVO -> taskRspVO.setProcessStateDesc(Column.ACT_BASE_STATUS.getLabelByCode(taskRspVO.getProcessState())));
        return PageResult.builder().count(Long.valueOf(taskRspVOPage.getTotal())).data(taskRspVOS).build();
    }

    @Override
    public PageResult<OptRecordRspVO> getOptRecords(OptRecordReqVO optRecordReqVO) {
        Page page = PageUtil.buildPage((Integer)optRecordReqVO.getPageNum(), (Integer)optRecordReqVO.getPageSize());
        List<OptRecordRspVO> taskRspVOS = this.activitiMyTaskMapper.queryOptRecords((Page<OptRecordRspVO>)page, optRecordReqVO);
        taskRspVOS.forEach(taskRspVO -> taskRspVO.setOperationStr(ColumnStr.PROCESS_BTN.getLabelByCode(taskRspVO.getOperation())));
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(taskRspVOS).build();
    }

    @Override
    public ProcessInfoRspVO getProcessInfo(ProcessInfoReqVO processInfoReqVO) {
        ProcessInfoRspVO rspVO = new ProcessInfoRspVO();
        if (StringUtils.isNotEmpty((String)processInfoReqVO.getProcessInstanceId())) {
            rspVO.setProcessInstanceId(processInfoReqVO.getProcessInstanceId());
        } else {
            rspVO.setProcessInstanceId("test_pro_inst_10002");
        }
        rspVO.setTaskId(processInfoReqVO.getTaskId());
        rspVO.setAllowMobile(Boolean.valueOf(true));
        rspVO.setApplierCode("start001");
        rspVO.setApplierName("\u6f14\u793a\u53d1\u8d77\u4eba\u7532");
        rspVO.setApplierPositionCode("testpos1");
        rspVO.setApplierPositionName("\u6f14\u793a\u5c97\u4f4d1");
        rspVO.setCauseType(Integer.valueOf(Indicator.PROCESS_CAUSE_TYPE_COMMON.getCode()));
        rspVO.setStartTime(DateUtil.getDateByFormat((String)"2020-11-23 11:52:21", (String)"yyyy-MM-dd HH:mm:ss"));
        if (StringUtils.isNotEmpty((String)processInfoReqVO.getFormNo())) {
            rspVO.setFormNo(processInfoReqVO.getFormNo());
            rspVO.setFormType(processInfoReqVO.getFormType());
            rspVO.setCostType(processInfoReqVO.getCostType());
        } else {
            rspVO.setFormNo("TEST100001");
            rspVO.setFormType(IndicatorStr.FORM_TYPE_SFA.getCode());
            rspVO.setCostType(IndicatorStr.COST_TYPE_LEAVE.getCode());
        }
        rspVO.setFormUrl("");
        rspVO.setProcessKey("DEMO_SHOW_PROCESS");
        rspVO.setProcessVersionKey("DEMO_SHOW_PROCESS:2");
        rspVO.setTaskDefKey("MANAGER_AUDIT");
        rspVO.setTaskType(Integer.valueOf(1));
        rspVO.setStatus(Integer.valueOf(Indicator.ACT_BASE_STATUS_DOING.getCode()));
        rspVO.setCurrentUserCode("manager");
        rspVO.setCurrentUserName("\u90e8\u95e8\u7ecf\u7406(\u6f14\u793a)");
        rspVO.setCurrentUserCode("testManager");
        rspVO.setCurrentUserPositionName("\u6f14\u793a\u7528\u90e8\u95e8\u7ecf\u7406\u5c97\u4f4d");
        rspVO.setLastUserCode("start001");
        rspVO.setLastUserName("\u6f14\u793a\u53d1\u8d77\u4eba\u7532");
        rspVO.setLastUserPositionCode("testpos1");
        rspVO.setLastUserPositionName("\u6f14\u793a\u5c97\u4f4d1");
        rspVO.setLastOptBtn(IndicatorStr.PROCESS_BTN_START.getCode());
        rspVO.setLastOptBtnDesc(IndicatorStr.PROCESS_BTN_START.getLabel());
        rspVO.setLastOptRemark("\u5907\u6ce8\uff1a\u6d4b\u8bd5\u53d1\u8d77\u4e00\u4e2a\u6f14\u793a\u6d41\u7a0b");
        HashMap<String, Boolean> btnMap = new HashMap<String, Boolean>();
        btnMap.put("BTN_004", true);
        btnMap.put("BTN_006", true);
        btnMap.put("BTN_017", true);
        btnMap.put("BTN_030", false);
        rspVO.setBtnAuths(btnMap);
        return rspVO;
    }

    private List<TaskRspVO> buildCurrentTestList(String userCode, Indicator status, Date dateTaskDone) {
        Date date = DateUtil.getDateByFormat((String)"2020-11-23 11:52:21", (String)"yyyy-MM-dd HH:mm:ss");
        Date dateTask = DateUtil.getDateByFormat((String)"2020-11-24 16:52:21", (String)"yyyy-MM-dd HH:mm:ss");
        ArrayList<TaskRspVO> taskList = new ArrayList<TaskRspVO>();
        TaskRspVO rspVO = new TaskRspVO();
        rspVO.setCreateTime(date);
        rspVO.setCurrentCode(userCode);
        rspVO.setCurrentName("\u6f14\u793a\u4eba\u5458");
        rspVO.setCurrentPosCode("testpos1");
        rspVO.setCurrentPosName("\u6f14\u793a\u5c97\u4f4d1");
        rspVO.setFormNo("TEST100001");
        rspVO.setFormTitle("\u6f14\u793a:XXX\u5e02\u6c83\u5c14\u739b\u8d85\u5e02\u5546\u54c1\u9648\u5217\u6d3b\u52a8\u8d39\u7528\u7533\u8bf7");
        rspVO.setFormType(IndicatorStr.FORM_TYPE_SFA.getCode());
        rspVO.setCostType(IndicatorStr.COST_TYPE_LEAVE.getCode());
        rspVO.setProcessInstanceId("test_pro_inst_10001");
        rspVO.setProcessKey("DEMO_SHOW_PROCESS");
        rspVO.setProcessName("\u6f14\u793a\u6d41\u7a0b:\u9648\u5217\u6d3b\u52a8\u7533\u8bf7\u6d41\u7a0b");
        rspVO.setProcessState(Integer.valueOf(status.getCode()));
        rspVO.setProcessStateDesc(status.getLabel());
        rspVO.setStartPosCode("testpos101");
        rspVO.setStartPosName("\u6f14\u793a\u5c97\u4f4d101");
        rspVO.setStartUserCode("start001");
        rspVO.setStartUserName("\u6f14\u793a\u53d1\u8d77\u4eba\u7532");
        rspVO.setTaskDefKey("MANAGER_AUDIT");
        rspVO.setTaskName("\u7ecf\u7406\u5ba1\u6279");
        rspVO.setTaskId("test1234567");
        rspVO.setTaskCreateTime(dateTask);
        rspVO.setTaskDoneTime(dateTaskDone);
        TaskRspVO rspVO2 = new TaskRspVO();
        rspVO2.setCreateTime(date);
        rspVO2.setCurrentCode(userCode);
        rspVO2.setCurrentName("\u6f14\u793a\u4eba\u5458");
        rspVO2.setCurrentPosCode("testpos1");
        rspVO2.setCurrentPosName("\u6f14\u793a\u5c97\u4f4d1");
        rspVO2.setFormNo("TEST100002");
        rspVO2.setFormTitle("\u6f14\u793a:XXX\u5e02\u5bb6\u4e50\u798f\u8d85\u5e02\u5546\u54c1\u9648\u5217\u6d3b\u52a8\u8d39\u7528\u7533\u8bf7");
        rspVO2.setFormType(IndicatorStr.FORM_TYPE_SFA.getCode());
        rspVO2.setCostType(IndicatorStr.COST_TYPE_OVERTIME.getCode());
        rspVO2.setProcessInstanceId("test_pro_inst_10002");
        rspVO2.setProcessKey("DEMO_SHOW_PROCESS");
        rspVO2.setProcessName("\u6f14\u793a\u6d41\u7a0b:\u9648\u5217\u6d3b\u52a8\u7533\u8bf7\u6d41\u7a0b");
        rspVO2.setProcessState(Integer.valueOf(status.getCode()));
        rspVO2.setProcessStateDesc(status.getLabel());
        rspVO2.setStartPosCode("testpos102");
        rspVO2.setStartPosName("\u6f14\u793a\u5c97\u4f4d102");
        rspVO2.setStartUserCode("start002");
        rspVO2.setStartUserName("\u6f14\u793a\u53d1\u8d77\u4eba\u4e59");
        rspVO2.setTaskDefKey("MANAGER_AUDIT");
        rspVO2.setTaskName("\u7ecf\u7406\u5ba1\u6279");
        rspVO2.setTaskId("test12345678");
        rspVO.setTaskCreateTime(dateTask);
        rspVO.setTaskDoneTime(dateTaskDone);
        TaskRspVO rspVO3 = new TaskRspVO();
        rspVO3.setCreateTime(date);
        rspVO3.setCurrentCode(userCode);
        rspVO3.setCurrentName("\u6f14\u793a\u4eba\u5458");
        rspVO3.setCurrentPosCode("testpos1");
        rspVO3.setCurrentPosName("\u6f14\u793a\u5c97\u4f4d1");
        rspVO3.setFormNo("TEST100003");
        rspVO3.setFormTitle("\u6f14\u793a:XXX\u4e07\u8fbe\u5546\u57ce\u5546\u54c1\u9648\u5217\u6d3b\u52a8\u8d39\u7528\u7533\u8bf7");
        rspVO3.setFormType(IndicatorStr.FORM_TYPE_SFA.getCode());
        rspVO3.setCostType(IndicatorStr.COST_TYPE_EXCEPTION.getCode());
        rspVO3.setProcessInstanceId("test_pro_inst_10003");
        rspVO3.setProcessKey("DEMO_SHOW_PROCESS");
        rspVO3.setProcessName("\u6f14\u793a\u6d41\u7a0b:\u9648\u5217\u6d3b\u52a8\u7533\u8bf7\u6d41\u7a0b");
        rspVO3.setProcessState(Integer.valueOf(status.getCode()));
        rspVO3.setProcessStateDesc(status.getLabel());
        rspVO3.setStartPosCode("testpos103");
        rspVO3.setStartPosName("\u6f14\u793a\u5c97\u4f4d103");
        rspVO3.setStartUserCode("start003");
        rspVO3.setStartUserName("\u6f14\u793a\u53d1\u8d77\u4eba\u4e19");
        rspVO3.setTaskDefKey("MANAGER_AUDIT");
        rspVO3.setTaskName("\u7ecf\u7406\u5ba1\u6279");
        rspVO3.setTaskId("test123456789");
        rspVO.setTaskCreateTime(dateTask);
        rspVO.setTaskDoneTime(dateTaskDone);
        taskList.add(rspVO);
        taskList.add(rspVO2);
        taskList.add(rspVO3);
        return taskList;
    }

    private List<TaskRspVO> buildStartTestList(String userCode, Indicator status) {
        Date date = DateUtil.getDateByFormat((String)"2020-11-23 11:52:21", (String)"yyyy-MM-dd HH:mm:ss");
        ArrayList<TaskRspVO> taskList = new ArrayList<TaskRspVO>();
        TaskRspVO rspVO = new TaskRspVO();
        rspVO.setCreateTime(date);
        rspVO.setCurrentCode(userCode);
        rspVO.setCurrentName("\u6f14\u793a\u53d1\u8d77\u4eba\u5458");
        rspVO.setCurrentPosCode("startPOS001");
        rspVO.setCurrentPosName("\u6f14\u793a\u53d1\u8d77\u5c97\u4f4d101");
        rspVO.setFormNo("TEST100001");
        rspVO.setFormTitle("\u6f14\u793a:XXX\u5e02\u6c83\u5c14\u739b\u8d85\u5e02\u5546\u54c1\u9648\u5217\u6d3b\u52a8\u8d39\u7528\u7533\u8bf7");
        rspVO.setFormType(IndicatorStr.FORM_TYPE_SFA.getCode());
        rspVO.setCostType(IndicatorStr.COST_TYPE_LEAVE.getCode());
        rspVO.setProcessInstanceId("test_pro_inst_10001");
        rspVO.setProcessKey("DEMO_SHOW_PROCESS");
        rspVO.setProcessName("\u6f14\u793a\u6d41\u7a0b:\u9648\u5217\u6d3b\u52a8\u7533\u8bf7\u6d41\u7a0b");
        rspVO.setProcessState(Integer.valueOf(Indicator.ACT_BASE_STATUS_FINISH.getCode()));
        rspVO.setProcessStateDesc(Indicator.ACT_BASE_STATUS_FINISH.getLabel());
        rspVO.setStartPosCode("startPOS001");
        rspVO.setStartPosName("\u6f14\u793a\u53d1\u8d77\u5c97\u4f4d101");
        rspVO.setStartUserCode(userCode);
        rspVO.setStartUserName("\u6f14\u793a\u53d1\u8d77\u4eba\u5458");
        rspVO.setTaskDefKey("DEFAULT_START");
        rspVO.setTaskName("\u53d1\u8d77\u8282\u70b9");
        rspVO.setTaskId("test1234567");
        rspVO.setTaskCreateTime(date);
        rspVO.setTaskDoneTime(date);
        TaskRspVO rspVO2 = new TaskRspVO();
        rspVO2.setCreateTime(date);
        rspVO2.setCurrentCode(userCode);
        rspVO2.setCurrentName("\u6f14\u793a\u53d1\u8d77\u4eba\u5458");
        rspVO2.setCurrentPosCode("startPOS001");
        rspVO2.setCurrentPosName("\u6f14\u793a\u53d1\u8d77\u5c97\u4f4d101");
        rspVO2.setFormNo("TEST100002");
        rspVO2.setFormTitle("\u6f14\u793a:XXX\u5e02\u5bb6\u4e50\u798f\u8d85\u5e02\u5546\u54c1\u9648\u5217\u6d3b\u52a8\u8d39\u7528\u7533\u8bf7");
        rspVO2.setFormType(IndicatorStr.FORM_TYPE_SFA.getCode());
        rspVO2.setCostType(IndicatorStr.COST_TYPE_OVERTIME.getCode());
        rspVO2.setProcessInstanceId("test_pro_inst_10002");
        rspVO2.setProcessKey("DEMO_SHOW_PROCESS");
        rspVO2.setProcessName("\u6f14\u793a\u6d41\u7a0b:\u9648\u5217\u6d3b\u52a8\u7533\u8bf7\u6d41\u7a0b");
        rspVO2.setProcessState(Integer.valueOf(status.getCode()));
        rspVO2.setProcessStateDesc(status.getLabel());
        rspVO2.setStartPosCode("startPOS001");
        rspVO2.setStartPosName("\u6f14\u793a\u53d1\u8d77\u5c97\u4f4d101");
        rspVO2.setStartUserCode(userCode);
        rspVO2.setStartUserName("\u6f14\u793a\u53d1\u8d77\u4eba\u5458");
        rspVO2.setTaskDefKey("DEFAULT_START");
        rspVO2.setTaskName("\u53d1\u8d77\u8282\u70b9");
        rspVO2.setTaskId("test12345678");
        rspVO.setTaskCreateTime(date);
        rspVO.setTaskDoneTime(date);
        TaskRspVO rspVO3 = new TaskRspVO();
        rspVO3.setCreateTime(date);
        rspVO3.setCurrentCode(userCode);
        rspVO3.setCurrentName("\u6f14\u793a\u53d1\u8d77\u4eba\u5458");
        rspVO3.setCurrentPosCode("startPOS001");
        rspVO3.setCurrentPosName("\u6f14\u793a\u53d1\u8d77\u5c97\u4f4d101");
        rspVO3.setFormNo("TEST100003");
        rspVO3.setFormTitle("\u6f14\u793a:XXX\u4e07\u8fbe\u5546\u57ce\u5546\u54c1\u9648\u5217\u6d3b\u52a8\u8d39\u7528\u7533\u8bf7");
        rspVO3.setFormType(IndicatorStr.FORM_TYPE_SFA.getCode());
        rspVO3.setCostType(IndicatorStr.COST_TYPE_EXCEPTION.getCode());
        rspVO3.setProcessInstanceId("test_pro_inst_10003");
        rspVO3.setProcessKey("DEMO_SHOW_PROCESS");
        rspVO3.setProcessName("\u6f14\u793a\u6d41\u7a0b:\u9648\u5217\u6d3b\u52a8\u7533\u8bf7\u6d41\u7a0b");
        rspVO3.setProcessState(Integer.valueOf(status.getCode()));
        rspVO3.setProcessStateDesc(status.getLabel());
        rspVO3.setStartPosCode("startPOS001");
        rspVO3.setStartPosName("\u6f14\u793a\u53d1\u8d77\u5c97\u4f4d101");
        rspVO3.setStartUserCode(userCode);
        rspVO3.setStartUserName("\u6f14\u793a\u53d1\u8d77\u4eba\u5458");
        rspVO3.setTaskDefKey("DEFAULT_START");
        rspVO3.setTaskName("\u53d1\u8d77\u8282\u70b9");
        rspVO3.setTaskId("test123456789");
        rspVO.setTaskCreateTime(date);
        rspVO.setTaskDoneTime(date);
        taskList.add(rspVO);
        taskList.add(rspVO2);
        taskList.add(rspVO3);
        return taskList;
    }
}

