/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.design.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.design.entity.TaNodeConfigEntity;
import com.biz.crm.design.entity.TaProcessEntity;
import com.biz.crm.design.mapper.ProcessMapper;
import com.biz.crm.design.mapper.TaNodeConfigMapper;
import com.biz.crm.design.service.ITaNodeConfigService;
import com.biz.crm.design.utils.XmlActivitiUtil;
import com.biz.crm.listener.mapper.TaListenerProcMapper;
import com.biz.crm.listener.model.TaListenerProcEntity;
import com.biz.crm.nebular.activiti.design.req.TaNodeConfigReqVo;
import com.biz.crm.nebular.activiti.design.resp.TaNodeConfigRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TaNodeConfigServiceExpandImpl"})
public class TaNodeConfigServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TaNodeConfigMapper, TaNodeConfigEntity>
implements ITaNodeConfigService {
    private static final Logger log = LoggerFactory.getLogger(TaNodeConfigServiceImpl.class);
    @Resource
    private TaNodeConfigMapper taNodeConfigMapper;
    @Resource
    private TaListenerProcMapper taListenerProcMapper;
    @Resource
    private ProcessMapper processMapper;

    @Override
    public PageResult<TaNodeConfigRespVo> findList(TaNodeConfigReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TaNodeConfigRespVo> list = this.taNodeConfigMapper.findList((Page<TaNodeConfigRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TaNodeConfigRespVo query(String id) {
        TaNodeConfigEntity entity = (TaNodeConfigEntity)this.taNodeConfigMapper.selectById((Serializable)((Object)id));
        if (ObjectUtils.isNotEmpty((Object)entity)) {
            return (TaNodeConfigRespVo)CrmBeanUtil.copy((Object)entity, TaNodeConfigRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TaNodeConfigReqVo reqVo) {
        TaNodeConfigEntity entity = (TaNodeConfigEntity)CrmBeanUtil.copy((Object)reqVo, TaNodeConfigEntity.class);
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TaNodeConfigReqVo reqVo) {
        TaNodeConfigEntity entity = (TaNodeConfigEntity)this.getById((Serializable)((Object)reqVo.getId()));
        if (ObjectUtils.isNotEmpty((Object)entity)) {
            this.updateById(CrmBeanUtil.copy((Object)reqVo, TaNodeConfigEntity.class));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List taNodeConfigEntities = this.taNodeConfigMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)taNodeConfigEntities)) {
            this.taNodeConfigMapper.deleteBatchIds(ids);
        }
        this.updateBatchById(taNodeConfigEntities);
    }

    @Override
    public void initNodeConfig(TaProcessEntity taProcess, String versionKey) {
        List<TaNodeConfigEntity> configEntities = null;
        try {
            configEntities = XmlActivitiUtil.getNodes(taProcess.getProcessXml());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u89e3\u6790xml\u83b7\u53d6task\u5931\u8d25!");
        }
        Date now = new Date();
        if (CollectionUtils.isNotEmpty(configEntities)) {
            for (TaNodeConfigEntity configEntity : configEntities) {
                configEntity.setProcessNodeId(taProcess.getProcessKey() + ":" + configEntity.getProcessNodeCode());
                configEntity.setProcessVersionKey(versionKey);
                configEntity.setCreateTime(now);
                this.taNodeConfigMapper.insert(configEntity);
            }
        }
    }

    @Override
    public void createNodeConfigWhenUpdateProcess(TaProcessEntity taProcess, String oldVersion, String newVersion) {
        List<TaNodeConfigEntity> oldNodeConfigs = this.taNodeConfigMapper.findNodeByProcessVersionKey(oldVersion);
        HashMap<String, TaNodeConfigEntity> oldNodeMap = new HashMap<String, TaNodeConfigEntity>();
        for (TaNodeConfigEntity oldNode : oldNodeConfigs) {
            oldNodeMap.put(oldNode.getProcessNodeCode(), oldNode);
        }
        List<TaListenerProcEntity> taskListeners = this.taListenerProcMapper.getAllListenerByProcessVersionKey(oldVersion);
        List<TaNodeConfigEntity> newNodes = null;
        try {
            newNodes = XmlActivitiUtil.getNodes(taProcess.getProcessXml());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u89e3\u6790xml\u83b7\u53d6task\u5931\u8d25!");
        }
        Date now = new Date();
        if (CollectionUtils.isNotEmpty(newNodes)) {
            HashMap<String, TaNodeConfigEntity> newNodeMap = new HashMap<String, TaNodeConfigEntity>();
            for (TaNodeConfigEntity newNode : newNodes) {
                String nodeName = new String(newNode.getProcessNodeName());
                if (oldNodeMap.containsKey(newNode.getProcessNodeCode())) {
                    TaNodeConfigEntity oldNode = (TaNodeConfigEntity)oldNodeMap.get(newNode.getProcessNodeCode());
                    BeanUtils.copyProperties((Object)oldNode, (Object)newNode);
                }
                newNode.setCreateTime(now);
                newNode.setId(null);
                newNode.setProcessNodeName(nodeName);
                newNode.setProcessVersionKey(newVersion);
                this.taNodeConfigMapper.insert(newNode);
                newNodeMap.put(newNode.getProcessNodeCode(), newNode);
            }
            if (CollectionUtils.isNotEmpty(taskListeners)) {
                for (TaListenerProcEntity taskListener : taskListeners) {
                    if (!newNodeMap.containsKey(taskListener.getNodeCode())) continue;
                    TaListenerProcEntity newListenerProc = new TaListenerProcEntity();
                    BeanUtils.copyProperties((Object)taskListener, (Object)newListenerProc);
                    newListenerProc.setProcessVersionKey(newVersion);
                    newListenerProc.setId(null);
                    this.taListenerProcMapper.insert(newListenerProc);
                }
            }
        }
    }

    @Override
    public PageResult<TaNodeConfigRespVo> queryByProcessKey(TaNodeConfigReqVo taNodeConfigReqVo) {
        if (StringUtils.isNotEmpty((String)taNodeConfigReqVo.getProcessVersionKey())) {
            return this.findList(taNodeConfigReqVo);
        }
        String processVersionKey = this.processMapper.getMaxProcessVersionByKey(taNodeConfigReqVo.getProcessKey());
        taNodeConfigReqVo.setProcessVersionKey(processVersionKey);
        return this.findList(taNodeConfigReqVo);
    }
}

