/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.alibaba.druid.support.json.JSONUtils;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TaActBaseMapper;
import com.biz.crm.act.mapper.TaFormSignTicketMapper;
import com.biz.crm.act.model.TaActBaseEntity;
import com.biz.crm.act.model.TaActBaseProcessEntity;
import com.biz.crm.act.model.TaFormSignTicketEntity;
import com.biz.crm.act.model.TaProcessCostTypeEntity;
import com.biz.crm.act.service.ITaActBaseProcessService;
import com.biz.crm.act.service.ITaActBaseService;
import com.biz.crm.act.service.ITaProcessCostTypeService;
import com.biz.crm.act.service.ITaProcessOptRecordService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.design.entity.TaProcessEntity;
import com.biz.crm.design.service.TaProcessService;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.activiti.ActivitiException;
import com.biz.crm.nebular.activiti.act.req.FormSignTicketQueryVo;
import com.biz.crm.nebular.activiti.act.req.ProcessCostTypeQueryVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessFormEngReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActBaseQueryReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActBaseReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActBaseRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TaActBaseServiceExpandImpl"})
public class TaActBaseServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TaActBaseMapper, TaActBaseEntity>
implements ITaActBaseService {
    private static final Logger log = LoggerFactory.getLogger(TaActBaseServiceImpl.class);
    @Resource
    private TaActBaseMapper taActBaseMapper;
    @Resource
    private TaFormSignTicketMapper taFormSignTicketMapper;
    @Autowired
    ITaProcessCostTypeService taProcessCostTypeService;
    @Autowired
    ITaActBaseProcessService taActBaseProcessService;
    @Autowired
    ITaProcessOptRecordService taProcessOptRecordService;
    @Autowired
    TaProcessService taProcessService;
    @Autowired
    TaskService taskService;

    @Override
    public PageResult<TaActBaseRespVo> findList(TaActBaseReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TaActBaseRespVo> list = this.taActBaseMapper.findList((Page<TaActBaseRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TaActBaseRespVo query(String id) {
        TaActBaseEntity entity = (TaActBaseEntity)((Object)this.taActBaseMapper.selectById((Serializable)((Object)id)));
        if (ObjectUtils.isNotEmpty((Object)((Object)entity))) {
            return (TaActBaseRespVo)CrmBeanUtil.copy((Object)((Object)entity), TaActBaseRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TaActBaseReqVo reqVo) {
        TaActBaseEntity entity = (TaActBaseEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TaActBaseEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TaActBaseReqVo reqVo) {
        TaActBaseEntity entity = (TaActBaseEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (ObjectUtils.isNotEmpty((Object)((Object)entity))) {
            this.updateById(CrmBeanUtil.copy((Object)reqVo, TaActBaseEntity.class));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List taActBaseEntities = this.taActBaseMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)taActBaseEntities)) {
            this.taActBaseMapper.deleteBatchIds(ids);
        }
    }

    @Override
    public TaActBaseProcessEntity startProcess(StartProcessFormEngReqVo reqVo) {
        TaActBaseProcessEntity process = null;
        ProcessInstance instance = null;
        log.info("========>come in! startProcess:" + reqVo.getFormNo());
        TaProcessCostTypeEntity processCostType = this.checkProcessDef(reqVo);
        this.checkStartParam(reqVo);
        TaProcessEntity taProcess = this.taProcessService.getProcessByKey(processCostType.getProcessDefKey());
        this.checkProcessDef(taProcess);
        TaFormSignTicketEntity signTicket = this.checkSignTicket(reqVo);
        TaActBaseQueryReqVo actBaseQueryReqVo = new TaActBaseQueryReqVo(reqVo.getFormNo(), reqVo.getCostType(), reqVo.getFormType(), reqVo.getSmallType());
        TaActBaseEntity actBase = this.taActBaseMapper.findByFormNoCostType(actBaseQueryReqVo);
        if (actBase == null) {
            actBase = this.createActBase(reqVo);
            process = this.taActBaseProcessService.initActBaseProcess(reqVo, actBase.getId(), taProcess.getProcessKey(), Indicator.ACT_BASE_STATUS_DOING.getCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getRemark())) {
            process.setRemark(reqVo.getRemark());
        }
        log.info("variable paramMap:" + JSONUtils.toJSONString((Object)reqVo.getVariables()) + "|" + reqVo.getFormNo());
        instance = this.taActBaseProcessService.startProcess(process, reqVo.getUserCode(), this.getFormVariablesForEng(reqVo.getVariables()));
        this.updateProcessByInstanceWhenStart(process, instance, signTicket);
        this.taActBaseProcessService.autoNextTask(instance, process);
        return process;
    }

    private TaProcessCostTypeEntity checkProcessDef(StartProcessFormEngReqVo reqVo) {
        ProcessCostTypeQueryVo queryVo = new ProcessCostTypeQueryVo(reqVo.getCostType(), reqVo.getFormType(), reqVo.getSmallType());
        TaProcessCostTypeEntity processCostType = this.taProcessCostTypeService.findExactOneByFormCostSmall(queryVo);
        return processCostType;
    }

    private void checkStartParam(StartProcessFormEngReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getSignTicket(), (CrmExceptionType)ActivitiException.ACT_PARAM_SIGN);
        AssertUtils.isNotEmpty((String)reqVo.getTitle(), (CrmExceptionType)ActivitiException.ACT_PARAM_TITLE);
        AssertUtils.isNotEmpty((String)reqVo.getFormUrl(), (CrmExceptionType)ActivitiException.ACT_PARAM_URL);
        AssertUtils.isNotEmpty((String)reqVo.getUserCode(), (CrmExceptionType)ActivitiException.ACT_PARAM_USER);
        AssertUtils.isNotEmpty((String)reqVo.getPosCode(), (CrmExceptionType)ActivitiException.ACT_PARAM_POS_CODE);
    }

    private void checkProcessDef(TaProcessEntity taProcess) {
        AssertUtils.isNotNull((Object)((Object)taProcess), (CrmExceptionType)ActivitiException.PROCESS_MODEL_NOT_FOUND, (String[])new String[0]);
        AssertUtils.isTrue((Indicator.PROCESS_STATE_DEPLOY.getCode() == taProcess.getProcessState().intValue() ? 1 : 0) != 0, (CrmExceptionType)ActivitiException.PROCESS_STATUS_ERROR, (String[])new String[0]);
    }

    private TaFormSignTicketEntity checkSignTicket(StartProcessFormEngReqVo reqVo) {
        FormSignTicketQueryVo queryVo = new FormSignTicketQueryVo(reqVo.getSignTicket(), reqVo.getFormNo());
        List<TaFormSignTicketEntity> signTicketList = this.taFormSignTicketMapper.findBySignTicketFromNo(queryVo);
        TaFormSignTicketEntity signTicket = null;
        if (CollectionUtils.isEmpty(signTicketList)) {
            signTicket = new TaFormSignTicketEntity();
            signTicket.setFormNo(reqVo.getFormNo());
            signTicket.setType(Indicator.TICKET_TYPE_NEW.getCode());
            signTicket.setSignTicket(reqVo.getSignTicket());
            signTicket.setCreateTime(new Date());
            signTicket.setStatus(Indicator.TICKET_STATUS_INIT.getCode());
            this.taFormSignTicketMapper.insert((Object)signTicket);
        } else {
            signTicket = signTicketList.get(0);
            if (Indicator.TICKET_STATUS_ERROR.getCode() == signTicket.getStatus().intValue()) {
                signTicket.setStatus(Indicator.TICKET_STATUS_INIT.getCode());
            } else {
                throw new BusinessException("\u8868\u5355" + reqVo.getFormNo() + "\u5df2\u7ecf\u53d1\u8d77\u8fc7\u6d41\u7a0b\u4e86!\u63a7\u5236\u7801\uff1a" + reqVo.getSignTicket());
            }
        }
        return signTicket;
    }

    public TaActBaseEntity createActBase(StartProcessFormEngReqVo paramVO) {
        TaActBaseEntity actBase = new TaActBaseEntity();
        actBase.setTitle(paramVO.getTitle());
        actBase.setFormKey(paramVO.getFormNo());
        actBase.setCreateTime(new Date());
        actBase.setCostType(paramVO.getCostType());
        actBase.setFormKey(paramVO.getFormType());
        actBase.setSmallType(paramVO.getSmallType());
        actBase.setStatus(0);
        this.saveOrUpdate((Object)actBase);
        return actBase;
    }

    private Map<String, String> getFormVariablesForEng(Map<String, Object> paramMap) {
        if (paramMap != null && paramMap.size() > 0) {
            HashMap<String, String> formVariables = new HashMap<String, String>();
            for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                formVariables.put("form_" + entry.getKey(), entry.getValue().toString().replace(" ", ""));
            }
            return formVariables;
        }
        return null;
    }

    private void updateProcessByInstanceWhenStart(TaActBaseProcessEntity process, ProcessInstance instance, TaFormSignTicketEntity ticket) {
        if (instance != null) {
            process.setProcessInstanceId(instance.getProcessInstanceId());
            process.setStatus(Indicator.ACT_BASE_STATUS_DOING.getCode());
            process.setProcessVersionKey(instance.getProcessDefinitionId());
            this.taActBaseProcessService.saveOrUpdate((Object)process);
        }
        this.updateTicketStatus(instance.getProcessInstanceId(), ticket, Indicator.TICKET_STATUS_FINISH.getCode());
    }

    private void updateTicketStatus(String procInstId, TaFormSignTicketEntity ticket, Integer status) {
        if (ticket != null) {
            ticket.setProcInstId(procInstId);
            ticket.setStatus(status);
            ticket.setUpdateTime(new Date());
            this.taFormSignTicketMapper.updateById((Object)ticket);
        }
    }
}

