/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.controller;

import com.biz.crm.activiti.service.IActivitiMyTaskService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.activiti.ActivitiException;
import com.biz.crm.nebular.activiti.start.req.CancelProcessReqVO;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.start.req.ProcessInfoReqVO;
import com.biz.crm.nebular.activiti.start.req.StartProcessReqVO;
import com.biz.crm.nebular.activiti.task.req.TaskOptReqVO;
import com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.OptLogsRspVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.activiti.task.resp.ProcessInfoRspVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"activitiProcessController"})
@Api(tags={"\u5de5\u4f5c\u6d41\u6d41\u7a0b\u76f8\u5173\u63a5\u53e3"})
public class ActivitiProcessController {
    @Autowired
    private IActivitiMyTaskService iActivitiMyTaskService;

    @ApiOperation(value="\u53d1\u8d77\u6d41\u7a0b")
    @PostMapping(value={"/startProcess"})
    @CrmLog
    public Result startProcess(@RequestBody StartProcessReqVO reqVO) {
        AssertUtils.isNotEmpty((String)reqVO.getFormNo(), (CrmExceptionType)ActivitiException.ACT_PARAM_FROM_NO);
        AssertUtils.isNotEmpty((String)reqVO.getCostType(), (CrmExceptionType)ActivitiException.ACT_PARAM_COST_TYPE);
        AssertUtils.isNotEmpty((String)reqVO.getFormType(), (CrmExceptionType)ActivitiException.ACT_PARAM_FORM_TYPE);
        AssertUtils.isNotEmpty((String)reqVO.getPositionCode(), (CrmExceptionType)ActivitiException.ACT_PARAM_POS_CODE);
        AssertUtils.isNotEmpty((String)reqVO.getSignTicket(), (CrmExceptionType)ActivitiException.ACT_PARAM_SIGN);
        AssertUtils.isNotEmpty((String)reqVO.getTitle(), (CrmExceptionType)ActivitiException.ACT_PARAM_TITLE);
        AssertUtils.isNotEmpty((String)reqVO.getFormUrl(), (CrmExceptionType)ActivitiException.ACT_PARAM_URL);
        return Result.ok();
    }

    @ApiOperation(value="\u64a4\u9500\u6d41\u7a0b")
    @PostMapping(value={"/cancelProcess"})
    @CrmLog
    public Result cancelProcess(@RequestBody CancelProcessReqVO cancelProcessReqVO) {
        AssertUtils.isNotEmpty((String)cancelProcessReqVO.getUserCode(), (CrmExceptionType)ActivitiException.ACT_PARAM_USER);
        AssertUtils.isNotEmpty((String)cancelProcessReqVO.getFormNo(), (CrmExceptionType)ActivitiException.ACT_PARAM_FROM_NO);
        AssertUtils.isNotEmpty((String)cancelProcessReqVO.getCostType(), (CrmExceptionType)ActivitiException.ACT_PARAM_COST_TYPE);
        AssertUtils.isNotEmpty((String)cancelProcessReqVO.getFormType(), (CrmExceptionType)ActivitiException.ACT_PARAM_FORM_TYPE);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u6211\u7684\u5f85\u529e\u4efb\u52a1")
    @PostMapping(value={"/findCurrentTask"})
    @CrmLog
    public Result<PageResult<TaskRspVO>> findCurrentTask(@RequestBody TaskQueryReqVO taskReqVO) {
        AssertUtils.isNotEmpty((String)taskReqVO.getPositionCode(), (CrmExceptionType)ActivitiException.ACT_PARAM_USER);
        PageResult<TaskRspVO> page = this.iActivitiMyTaskService.findMyCurrentTask(taskReqVO);
        return Result.ok(page);
    }

    @ApiOperation(value="\u67e5\u8be2\u6211\u7684\u5df2\u529e\u4efb\u52a1")
    @PostMapping(value={"/findDoneTask"})
    @CrmLog
    public Result<PageResult<TaskRspVO>> findDoneTask(@RequestBody TaskQueryReqVO taskReqVO) {
        AssertUtils.isNotEmpty((String)taskReqVO.getUserCode(), (CrmExceptionType)ActivitiException.ACT_PARAM_USER);
        PageResult<TaskRspVO> page = this.iActivitiMyTaskService.findDoneTask(taskReqVO);
        return Result.ok(page);
    }

    @ApiOperation(value="\u67e5\u8be2\u6211\u53d1\u8d77\u7684\u4efb\u52a1")
    @PostMapping(value={"/findStartTask"})
    @CrmLog
    public Result<PageResult<TaskRspVO>> findStartTask(@RequestBody TaskQueryReqVO taskReqVO) {
        AssertUtils.isNotEmpty((String)taskReqVO.getUserCode(), (CrmExceptionType)ActivitiException.ACT_PARAM_USER);
        PageResult<TaskRspVO> page = this.iActivitiMyTaskService.findStartTask(taskReqVO);
        return Result.ok(page);
    }

    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u5ba1\u6279\u8bb0\u5f55")
    @PostMapping(value={"/getOptRecords"})
    @CrmLog
    public Result<PageResult<OptRecordRspVO>> getOptRecords(@RequestBody OptRecordReqVO optRecordReqVO) {
        AssertUtils.isTrue((StringUtils.isNotEmpty((String)optRecordReqVO.getProcessInstanceId()) || StringUtils.isNotEmpty((String)optRecordReqVO.getFormNo()) && StringUtils.isNotEmpty((String)optRecordReqVO.getCostType()) && StringUtils.isNotEmpty((String)optRecordReqVO.getFormType()) ? 1 : 0) != 0, (String)"\u8282\u70b9ID\u6d41\u7a0b\u5b9e\u4f8bID\u6216\u8868\u5355\u4e1a\u52a1\u4fe1\u606f\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        PageResult<OptRecordRspVO> records = this.iActivitiMyTaskService.getOptRecords(optRecordReqVO);
        return Result.ok(records);
    }

    @ApiOperation(value="\u8282\u70b9\u5ba1\u6279\u901a\u8fc7")
    @PostMapping(value={"/completeTask"})
    @CrmLog
    public Result completeTask(@RequestBody TaskOptReqVO taskOptReqVO) {
        AssertUtils.isNotEmpty((String)taskOptReqVO.getPositionCode(), (CrmExceptionType)ActivitiException.ACT_PARAM_POS_CODE);
        AssertUtils.isNotEmpty((String)taskOptReqVO.getTaskId(), (CrmExceptionType)ActivitiException.ACT_PARAM_TASK_ID);
        AssertUtils.isNotEmpty((String)taskOptReqVO.getProcessInstanceId(), (CrmExceptionType)ActivitiException.ACT_PARAM_PROCESS_ID);
        AssertUtils.isNotEmpty((String)taskOptReqVO.getOptBtn(), (CrmExceptionType)ActivitiException.ACT_PARAM_BTN);
        return Result.ok();
    }

    @ApiOperation(value="\u8282\u70b9\u5ba1\u6279\u9a73\u56de\u53d1\u8d77\u4eba")
    @PostMapping(value={"/rejectTask"})
    @CrmLog
    public Result rejectTask(@RequestBody TaskOptReqVO taskOptReqVO) {
        AssertUtils.isNotEmpty((String)taskOptReqVO.getPositionCode(), (CrmExceptionType)ActivitiException.ACT_PARAM_POS_CODE);
        AssertUtils.isNotEmpty((String)taskOptReqVO.getTaskId(), (CrmExceptionType)ActivitiException.ACT_PARAM_TASK_ID);
        AssertUtils.isNotEmpty((String)taskOptReqVO.getProcessInstanceId(), (CrmExceptionType)ActivitiException.ACT_PARAM_PROCESS_ID);
        AssertUtils.isNotEmpty((String)taskOptReqVO.getOptBtn(), (CrmExceptionType)ActivitiException.ACT_PARAM_BTN);
        AssertUtils.isNotEmpty((String)taskOptReqVO.getRemark(), (CrmExceptionType)ActivitiException.ACT_PARAM_REMARK);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u8be6\u7ec6\u4fe1\u606f")
    @PostMapping(value={"/getProcessInfo"})
    @CrmLog
    public Result<ProcessInfoRspVO> getProcessInfo(@RequestBody ProcessInfoReqVO processInfoReqVO) {
        AssertUtils.isTrue((StringUtils.isNotEmpty((String)processInfoReqVO.getTaskId()) && StringUtils.isNotEmpty((String)processInfoReqVO.getProcessInstanceId()) || StringUtils.isNotEmpty((String)processInfoReqVO.getFormNo()) && StringUtils.isNotEmpty((String)processInfoReqVO.getCostType()) && StringUtils.isNotEmpty((String)processInfoReqVO.getFormType()) ? 1 : 0) != 0, (String)"\u8282\u70b9ID\u6d41\u7a0b\u5b9e\u4f8bID\u6216\u8868\u5355\u4e1a\u52a1\u4fe1\u606f\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        return Result.ok((Object)this.iActivitiMyTaskService.getProcessInfo(processInfoReqVO));
    }

    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u65e5\u5fd7")
    @PostMapping(value={"/getOptLogs"})
    @CrmLog
    public Result<List<OptLogsRspVO>> getOptLogs(@RequestBody OptRecordReqVO optRecordReqVO) {
        AssertUtils.isTrue((StringUtils.isNotEmpty((String)optRecordReqVO.getProcessInstanceId()) || StringUtils.isNotEmpty((String)optRecordReqVO.getFormNo()) && StringUtils.isNotEmpty((String)optRecordReqVO.getCostType()) && StringUtils.isNotEmpty((String)optRecordReqVO.getFormType()) ? 1 : 0) != 0, (String)"\u8282\u70b9ID\u6d41\u7a0b\u5b9e\u4f8bID\u6216\u8868\u5355\u4e1a\u52a1\u4fe1\u606f\u4e0d\u80fd\u90fd\u4e3a\u7a7a");
        PageResult<OptRecordRspVO> records = this.iActivitiMyTaskService.getOptRecords(optRecordReqVO);
        HashMap map = Maps.newHashMap();
        records.getData().forEach(record -> {
            String date = DateUtil.formatDate((Date)record.getCreateTime(), (String)"yyyy-MM-dd");
            if (map.containsKey(date)) {
                ((List)map.get(date)).add(record);
            } else {
                ArrayList list = Lists.newArrayList();
                list.add(record);
                map.put(date, list);
            }
        });
        ArrayList results = Lists.newArrayList();
        map.forEach((key, value) -> results.add(OptLogsRspVO.builder().logDate(key).optRecordRspVOList(value).build()));
        return Result.ok((Object)results);
    }
}

