/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.design.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.design.entity.TaFuncRoleEntity;
import com.biz.crm.design.service.ITaFuncRoleService;
import com.biz.crm.eunm.activiti.ColumnStr;
import com.biz.crm.nebular.activiti.design.req.TaFuncRoleQueryReqVO;
import com.biz.crm.nebular.activiti.design.req.TaFuncRoleReqVO;
import com.biz.crm.nebular.activiti.design.resp.OptBtnVO;
import com.biz.crm.nebular.activiti.design.resp.TaFuncRoleRespVO;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/taFuncRoleController"})
@Api(tags={"\u6d41\u7a0b\u6309\u94ae\u89d2\u8272\u6743\u9650\u7ef4\u62a4"})
public class TaFuncRoleController {
    private static final Logger log = LoggerFactory.getLogger(TaFuncRoleController.class);
    @Autowired
    private ITaFuncRoleService taFuncRoleService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/findBtnRolePage"})
    @CrmLog
    public Result<PageResult<TaFuncRoleRespVO>> findBtnRolePage(@RequestBody TaFuncRoleQueryReqVO taFuncRoleQueryReqVO) {
        PageResult<TaFuncRoleRespVO> pageResult = this.taFuncRoleService.findFuncRolePage(taFuncRoleQueryReqVO);
        return Result.ok(pageResult);
    }

    @ApiOperation(value="\u6839\u636eID\u83b7\u53d6")
    @PostMapping(value={"/getBtnRoleById"})
    @CrmLog
    public Result<TaFuncRoleRespVO> getById(@RequestParam(value="id", required=true) String id) {
        TaFuncRoleEntity entity = (TaFuncRoleEntity)((Object)this.taFuncRoleService.getById((Serializable)((Object)id)));
        TaFuncRoleRespVO respVO = new TaFuncRoleRespVO();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)respVO);
        return Result.ok((Object)respVO);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u6309\u94ae")
    @PostMapping(value={"/getAllBtn"})
    @CrmLog
    public Result<List<OptBtnVO>> getAllBtn() {
        ArrayList<OptBtnVO> btnList = new ArrayList<OptBtnVO>();
        Map btnMap = ColumnStr.PROCESS_BTN.getCodesAndLabels();
        for (Map.Entry entry : btnMap.entrySet()) {
            OptBtnVO btnVO = new OptBtnVO();
            btnVO.setBtnCode((String)entry.getKey());
            btnVO.setBtnName((String)entry.getValue());
            btnList.add(btnVO);
        }
        return Result.ok(btnList);
    }

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u6309\u94ae\u6743\u9650\u7ec4\u5408")
    @PostMapping(value={"/getAllBtnRole"})
    @CrmLog
    public Result<List<TaFuncRoleRespVO>> getAllBtnRole() {
        List<TaFuncRoleRespVO> respVOS = this.taFuncRoleService.findAll();
        return Result.ok(respVOS);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/saveBtnRole"})
    @CrmLog
    public Result save(@RequestBody TaFuncRoleReqVO taFuncRoleReqVO) {
        this.checkBtnRoleParam(taFuncRoleReqVO);
        TaFuncRoleEntity entity = new TaFuncRoleEntity();
        BeanUtils.copyProperties((Object)taFuncRoleReqVO, (Object)((Object)entity));
        this.taFuncRoleService.save((Object)entity);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/updateBtnRoleById"})
    @CrmLog
    public Result update(@RequestBody TaFuncRoleReqVO taFuncRoleReqVO) {
        AssertUtils.isNotEmpty((String)taFuncRoleReqVO.getId(), (String)"Id\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)taFuncRoleReqVO.getRoleAuths(), (String)"\u529f\u80fd\u89d2\u8272\u6309\u94ae\u7ec4\u5408\u4e0d\u80fd\u4e3a\u7a7a!");
        this.checkBtnRoleParam(taFuncRoleReqVO);
        TaFuncRoleEntity entity = (TaFuncRoleEntity)((Object)this.taFuncRoleService.getById((Serializable)((Object)taFuncRoleReqVO.getId())));
        entity.setRoleCode(taFuncRoleReqVO.getRoleCode());
        entity.setRoleName(taFuncRoleReqVO.getRoleName());
        entity.setRoleAuths(taFuncRoleReqVO.getRoleAuths());
        this.taFuncRoleService.updateById((Object)entity);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/deleteBtnRoleById"})
    @CrmLog
    public Result delete(@RequestParam(value="id", required=true) String id) {
        this.taFuncRoleService.removeById((Serializable)((Object)id));
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    private void checkBtnRoleParam(TaFuncRoleReqVO taFuncRoleReqVO) {
        AssertUtils.isNotEmpty((String)taFuncRoleReqVO.getRoleCode(), (String)"\u529f\u80fd\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)taFuncRoleReqVO.getRoleName(), (String)"\u529f\u80fd\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        if (StringUtils.isNotEmpty((String)taFuncRoleReqVO.getRoleAuths())) {
            String[] btnList = taFuncRoleReqVO.getRoleAuths().split(",");
            for (int i = 0; i < btnList.length; ++i) {
                AssertUtils.isTrue((boolean)btnList[i].contains("BTN_"), (String)"\u5305\u542b\u975e\u6cd5\u7684\u6309\u94ae\u7f16\u7801!");
            }
        }
    }
}

