/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.biz.crm.act.service.TaskFlowControlService;
import com.biz.crm.act.service.impl.JumpTaskCmd;
import com.biz.crm.activiti.entity.ActHiActinstEntity;
import com.biz.crm.activiti.entity.ActHiTaskinstEntity;
import com.biz.crm.activiti.mapper.ActHiActInstMapper;
import com.biz.crm.activiti.mapper.ActHiTaskInstMapper;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.RuntimeServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taskFlowControlService")
@Transactional
public class TaskFlowControlServiceImpl
implements TaskFlowControlService {
    private static final Logger log = LoggerFactory.getLogger(TaskFlowControlServiceImpl.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    RepositoryService repositoryService;
    @Resource
    private ActHiActInstMapper actHiActInstMapper;
    @Resource
    private ActHiTaskInstMapper actHiTaskInstMapper;

    @Override
    public void jump(String taskId, String targetTaskDefinitionKey, Map<String, Object> variables) {
        TaskEntity currentTaskEntity = (TaskEntity)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        ActivityImpl activity = this.getActivity(currentTaskEntity.getProcessDefinitionId(), targetTaskDefinitionKey);
        CommandExecutor commandExecutor = ((RuntimeServiceImpl)this.runtimeService).getCommandExecutor();
        commandExecutor.execute((Command)new JumpTaskCmd(currentTaskEntity, activity, variables));
        this.doAfterJump(taskId);
    }

    @Override
    public ActivityImpl getActivity(String processDefId, String taskDefKey) {
        RepositoryServiceImpl repositoryServiceImpl = (RepositoryServiceImpl)this.repositoryService;
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)repositoryServiceImpl.getDeployedProcessDefinition(processDefId);
        List activitiList = processDefinition.getActivities();
        for (ActivityImpl activityImpl : activitiList) {
            if (!activityImpl.getId().equals(taskDefKey)) continue;
            return activityImpl;
        }
        return null;
    }

    @Override
    public void updateActHiInstTimeManual(String taskId) {
        this.doAfterJump(taskId);
    }

    @Override
    public void updateTaskHiInstTimeManual(String taskId, String deleteReason) {
        ActHiTaskinstEntity actHiTaskinstEntity = this.actHiTaskInstMapper.findByTaskId(taskId);
        if (actHiTaskinstEntity != null) {
            Timestamp nowTime = new Timestamp(System.currentTimeMillis());
            actHiTaskinstEntity.setEndTime(nowTime);
            actHiTaskinstEntity.setDeleteReason(deleteReason);
            actHiTaskinstEntity.setDuration(nowTime.getTime() - actHiTaskinstEntity.getStartTime().getTime());
            this.actHiTaskInstMapper.updateTimeInfo(actHiTaskinstEntity);
        }
    }

    @Override
    public void updateTaskHiTimeManual(String taskId, String deleteReason) {
        this.updateActHiInstTimeManual(taskId);
        this.updateTaskHiInstTimeManual(taskId, deleteReason);
    }

    private void doAfterJump(String taskId) {
        ActHiActinstEntity actHiActinstEntity = this.actHiActInstMapper.findByTaskId(taskId);
        if (actHiActinstEntity != null) {
            Timestamp nowTime = new Timestamp(System.currentTimeMillis());
            actHiActinstEntity.setEndTime(nowTime);
            actHiActinstEntity.setDuration(nowTime.getTime() - actHiActinstEntity.getStartTime().getTime());
            this.actHiActInstMapper.updateTimeInfo(actHiActinstEntity);
        }
    }
}

