/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.controller;

import com.biz.crm.act.service.ITaTaskService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.design.vo.VariableVO;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.activiti.ActivitiException;
import com.biz.crm.nebular.activiti.act.req.TaskOptReqVO;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"taTaskController"})
@Api(tags={"\u6d41\u7a0b\u8282\u70b9\u64cd\u4f5c"})
public class TaTaskController {
    private static final Logger log = LoggerFactory.getLogger(TaTaskController.class);
    @Autowired
    private ITaTaskService taTaskService;

    @ApiOperation(value="\u8282\u70b9\u5ba1\u6279\u901a\u8fc7")
    @PostMapping(value={"/taskComplete"})
    @CrmLog
    public Result taskComplete(@RequestBody TaskOptReqVO taskOptReqVO) {
        this.checkTaskComplete(taskOptReqVO);
        String msg = this.taTaskService.saveComplete(taskOptReqVO);
        return Result.ok((String)msg);
    }

    @ApiOperation(value="\u9a73\u56de\u53d1\u8d77\u8282\u70b9")
    @PostMapping(value={"/taskReject"})
    @CrmLog
    public Result taskReject(@RequestBody TaskOptReqVO taskOptReqVO) {
        this.checkTask(taskOptReqVO);
        taskOptReqVO.setOptBtnCode(IndicatorStr.PROCESS_BTN_REJECT_FIRST.getCode());
        String msg = this.taTaskService.taskReject(taskOptReqVO);
        return Result.ok((String)msg);
    }

    @ApiOperation(value="\u53d1\u8d77\u8282\u70b9\u91cd\u65b0\u53d1\u8d77\u6d41\u7a0b")
    @PostMapping(value={"/reStartProcess"})
    @CrmLog
    public Result reStartProcess(@RequestBody TaskOptReqVO taskOptReqVO) {
        this.checkTask(taskOptReqVO);
        taskOptReqVO.setOptBtnCode(IndicatorStr.PROCESS_BTN_SUBMIT.getCode());
        String msg = this.taTaskService.reStartProcess(taskOptReqVO);
        return Result.ok((String)msg);
    }

    private List<VariableVO> packageVariablesArrayToList(String taskVariables) {
        taskVariables = taskVariables.replaceAll("^.*\\[", "").replaceAll("].*", "").replaceAll("\"", "");
        ArrayList<VariableVO> vos = new ArrayList<VariableVO>();
        String[] variable = taskVariables.split(",");
        for (int i = 0; i < variable.length; ++i) {
            VariableVO vo = new VariableVO();
            String[] tmp = variable[i].split(":");
            vo.setVariableKey(tmp[0]);
            vo.setVariableValue(tmp[1]);
            vos.add(vo);
        }
        return vos;
    }

    private void checkTask(TaskOptReqVO taskOptReqVO) {
        AssertUtils.isNotEmpty((String)taskOptReqVO.getTaskId(), (CrmExceptionType)ActivitiException.ACT_PARAM_TASK_ID);
    }

    private void checkOptBtn(TaskOptReqVO taskOptReqVO) {
        this.checkTask(taskOptReqVO);
        AssertUtils.isNotEmpty((String)taskOptReqVO.getOptBtnCode(), (CrmExceptionType)ActivitiException.ACT_PARAM_BTN);
        AssertUtils.isTrue((boolean)taskOptReqVO.getOptBtnCode().contains("BTN_"), (CrmExceptionType)ActivitiException.ACT_PARAM_BTN, (String[])new String[0]);
    }

    private void checkTaskComplete(TaskOptReqVO taskOptReqVO) {
        this.checkOptBtn(taskOptReqVO);
        if (!(IndicatorStr.PROCESS_BTN_APPROVAL.getCode().equals(taskOptReqVO.getOptBtnCode()) || IndicatorStr.PROCESS_BTN_CONFIRM.getCode().equals(taskOptReqVO.getOptBtnCode()) || IndicatorStr.PROCESS_BTN_AUDIT.getCode().equals(taskOptReqVO.getOptBtnCode()))) {
            throw new BusinessException("\u4e0d\u5339\u914d\u7684\u6309\u94ae\u7f16\u7801");
        }
        log.info(taskOptReqVO.getOptBtnCode());
    }
}

