/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.biz.crm.act.service.ITaActBaseProcessService;
import com.biz.crm.act.service.ITaProcessCostTypeService;
import com.biz.crm.act.service.ITaProcessOptRecordService;
import com.biz.crm.act.service.TaProcessImgService;
import com.biz.crm.act.service.override.ProcessDiagramCanvasOverride;
import com.biz.crm.act.service.override.ProcessDiagramGeneratorOverride;
import com.biz.crm.design.entity.TaNodeConfigEntity;
import com.biz.crm.design.service.ITaNodeConfigService;
import com.biz.crm.util.CollectionUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="taProcessImgService")
public class TaProcessImgServiceImpl
implements TaProcessImgService {
    @Autowired
    ITaProcessCostTypeService taProcessCostTypeService;
    @Autowired
    ITaActBaseProcessService taActBaseProcessService;
    @Autowired
    ITaProcessOptRecordService taProcessOptRecordService;
    @Autowired
    private ITaNodeConfigService taNodeConfigService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ProcessEngine processEngine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream processTracking(String processInstanceId, String currUserName, String fromView) throws Exception {
        InputStream inputStream;
        ArrayList<String> activeActivityIds = new ArrayList<String>();
        List<Object> highLightedFlows = new ArrayList();
        ArrayList<String> otherHighLightIds = new ArrayList<String>();
        HashMap<String, String> hisNotRunFlowMap = new HashMap<String, String>();
        ArrayList<String> deleteFlows = new ArrayList<String>();
        ArrayList<String> deleteActivitiIds = new ArrayList<String>();
        List<Object> afterActiveActivitiIds = new ArrayList();
        HashMap<String, String> flowNodeType = new HashMap<String, String>();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (historicProcessInstance == null) {
            return null;
        }
        String processDefinitionId = historicProcessInstance.getProcessDefinitionId();
        String oldProcessDefinitionId = historicProcessInstance.getProcessDefinitionId();
        List<TaNodeConfigEntity> nodeConfigList = this.taNodeConfigService.findNodeByProcessVersionKey(processDefinitionId);
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        List currTasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        for (Task currTask : currTasks) {
            if (currTask.isSuspended() && !currTask.getTaskDefinitionKey().contains("addNode_")) continue;
            activeActivityIds.add(currTask.getTaskDefinitionKey());
        }
        List historicTaskInstanceList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).list();
        List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceStartTime().asc()).list();
        Process process = (Process)bpmnModel.getProcesses().get(0);
        Collection list = process.getFlowElements();
        List flowNodeList = process.findFlowElementsOfType(FlowNode.class);
        this.getFlowTypeMap(flowNodeType, nodeConfigList, flowNodeList);
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processDefinitionId);
        highLightedFlows = this.getHighLightedFlows(bpmnModel, historicActivityInstances, hisNotRunFlowMap);
        boolean createTaskSize = false;
        int startX = 60;
        ArrayList haveCreateNodes = new ArrayList();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
            ActivityImpl activity = definition.findActivity(historicActivityInstance.getActivityId());
            if (activity != null) {
                otherHighLightIds.add(activity.getId());
                if (historicActivityInstance.getActivityType().equals("startEvent")) {
                    startX += activity.getX();
                }
                if (!historicActivityInstance.getActivityType().equals("userTask")) continue;
                continue;
            }
            if (!historicActivityInstance.getActivityId().contains("addNode_")) continue;
            otherHighLightIds.add(historicActivityInstance.getActivityId());
        }
        afterActiveActivitiIds = this.isAfterCurrentAct(activeActivityIds, flowNodeList);
        for (String string : afterActiveActivitiIds) {
            Iterator iterator = hisNotRunFlowMap.entrySet().iterator();
            while (iterator.hasNext()) {
                if (!string.equals(iterator.next().getValue())) continue;
                iterator.remove();
            }
        }
        if (hisNotRunFlowMap.size() > 0 && CollectionUtils.isNotEmpty(highLightedFlows)) {
            for (Map.Entry entry : hisNotRunFlowMap.entrySet()) {
                if (highLightedFlows.contains(entry.getKey())) continue;
                String notRunflows = (String)entry.getKey();
                String notRunActiviIds = (String)entry.getValue();
                this.getTargetFlows(otherHighLightIds, deleteFlows, deleteActivitiIds, notRunflows, notRunActiviIds, null, flowNodeList, activeActivityIds, afterActiveActivitiIds);
            }
        }
        this.removeDeleteFlow(deleteFlows, deleteActivitiIds, activeActivityIds, processInstanceId, flowNodeList);
        if (CollectionUtils.isNotEmpty(deleteActivitiIds)) {
            for (String string : deleteActivitiIds) {
                Iterator iterable = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements().iterator();
                while (iterable.hasNext()) {
                    if (!string.equals(((FlowElement)iterable.next()).getId())) continue;
                    iterable.remove();
                }
                bpmnModel.getLocationMap().remove(string);
            }
        }
        if (CollectionUtils.isNotEmpty(deleteFlows)) {
            for (String string : deleteFlows) {
                bpmnModel.getFlowLocationMap().remove(string);
            }
        }
        InputStream imageStream = null;
        try {
            ProcessEngineConfiguration processEngineConfiguration = this.processEngine.getProcessEngineConfiguration();
            ProcessDiagramGeneratorOverride processDiagramGenerator = new ProcessDiagramGeneratorOverride();
            ProcessDiagramCanvasOverride processDiagramCanvas = processDiagramGenerator.getProcessDiagramCanvas(bpmnModel, "png", activeActivityIds, highLightedFlows, otherHighLightIds, "\u9ed1\u4f53", "\u9ed1\u4f53", processEngineConfiguration.getClassLoader(), 1.0, flowNodeType);
            imageStream = processDiagramGenerator.generateDiagram(processDiagramCanvas, "png");
            int minX = processDiagramCanvas.getMinX();
            int minY = processDiagramCanvas.getMinY();
            inputStream = imageStream;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(imageStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)imageStream);
        return inputStream;
    }

    private void getFlowTypeMap(Map<String, String> flowNodeType, List<TaNodeConfigEntity> nodeConfigList, List<FlowNode> flowNodeList) {
        if (CollectionUtils.isNotEmpty(nodeConfigList)) {
            for (TaNodeConfigEntity bean : nodeConfigList) {
                FlowNode flowNode;
                if ("DEFAULT_START".equals(bean.getProcessNodeCode()) || (flowNode = this.getFlowNodeById(bean.getProcessNodeCode(), flowNodeList)) == null) continue;
                flowNodeType.put(flowNode.getId(), "R");
            }
        }
    }

    private FlowNode getFlowNodeById(String notRunActivitId, List<FlowNode> flowNodeList) {
        for (FlowNode flowNode : flowNodeList) {
            if (!notRunActivitId.equals(flowNode.getId())) continue;
            return flowNode;
        }
        return null;
    }

    private List<String> isAfterCurrentAct(List<String> currentActivitiId, List<FlowNode> flowNodeList) {
        ArrayList<String> isAfterCurrentActId = new ArrayList<String>();
        HashMap<String, FlowNode> flowNodeMap = new HashMap<String, FlowNode>();
        HashSet<String> readNodeSet = new HashSet<String>();
        if (CollectionUtil.listNotEmptyNotSizeZero(flowNodeList)) {
            for (FlowNode node : flowNodeList) {
                flowNodeMap.put(node.getId(), node);
            }
        }
        for (String s : currentActivitiId) {
            readNodeSet.add(s);
            if (!CollectionUtil.listNotEmptyNotSizeZero(flowNodeList)) continue;
            this.getTargetList(flowNodeMap, isAfterCurrentActId, s, readNodeSet);
        }
        return isAfterCurrentActId;
    }

    private void getTargetList(Map<String, FlowNode> node, List<String> isAfterCurrentActIdList, String s, Set<String> readNodeSet) {
        FlowNode flowNode = this.getFlowNode(s, node);
        if (flowNode != null && CollectionUtils.isNotEmpty((Collection)flowNode.getOutgoingFlows())) {
            for (SequenceFlow sequenceFlow : flowNode.getOutgoingFlows()) {
                if (readNodeSet.contains(sequenceFlow.getTargetRef())) continue;
                isAfterCurrentActIdList.add(sequenceFlow.getTargetRef());
                readNodeSet.add(sequenceFlow.getTargetRef());
                this.getTargetList(node, isAfterCurrentActIdList, sequenceFlow.getTargetRef(), readNodeSet);
            }
        }
    }

    private FlowNode getFlowNode(String notRunActivitId, Map<String, FlowNode> flowNode) {
        if (StringUtils.isEmpty((CharSequence)notRunActivitId)) {
            return null;
        }
        if (flowNode.containsKey(notRunActivitId)) {
            return flowNode.get(notRunActivitId);
        }
        return null;
    }

    private List<String> getHighLightedFlows(BpmnModel bpmnModel, List<HistoricActivityInstance> historicActivityInstances, Map<String, String> hisNotRunFlowMap) {
        ArrayList<String> highFlows = new ArrayList<String>();
        HashMap<String, HistoricActivityInstance> hisActInstMap = new HashMap<String, HistoricActivityInstance>();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
            hisActInstMap.put(historicActivityInstance.getActivityId(), historicActivityInstance);
        }
        for (int i = 0; i < historicActivityInstances.size(); ++i) {
            HistoricActivityInstance currActivityHis = historicActivityInstances.get(i);
            if (currActivityHis.getEndTime() == null) continue;
            ArrayList<FlowElement> haveActivity = new ArrayList<FlowElement>();
            FlowNode currNode = (FlowNode)bpmnModel.getFlowElement(currActivityHis.getActivityId());
            for (int j = i + 1; j < historicActivityInstances.size(); ++j) {
                HistoricActivityInstance downActivityHis = historicActivityInstances.get(j);
                long et = currActivityHis.getEndTime().getTime();
                long st = downActivityHis.getStartTime().getTime();
                if (st < et) continue;
                haveActivity.add(bpmnModel.getFlowElement(downActivityHis.getActivityId()));
            }
            if (currNode == null) continue;
            List sequenceFlows = currNode.getOutgoingFlows();
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                if (hisActInstMap.containsKey(sequenceFlow.getTargetRef())) {
                    highFlows.add(sequenceFlow.getId());
                    continue;
                }
                if (currNode.getId().contains("parallelGateway") || sequenceFlows.size() <= 1) continue;
                hisNotRunFlowMap.put(sequenceFlow.getId(), sequenceFlow.getTargetRef());
            }
        }
        return highFlows;
    }

    private void getTargetFlows(List<String> otherHighLightIds, List<String> deleteFlows, List<String> deleteActivitiIds, String notRunFlow, String notRunActivitId, FlowNode flowNode, List<FlowNode> flowNodeList, List<String> activeActivityIds, List<String> afteractiveActivityIds) {
        deleteFlows.add(notRunFlow);
        if (!this.isHisOrCurrent(notRunActivitId, activeActivityIds, otherHighLightIds, afteractiveActivityIds)) {
            deleteActivitiIds.add(notRunActivitId);
            FlowNode flowNode1 = this.getFlowNodeById(notRunActivitId, flowNodeList);
            if (flowNode1 != null && CollectionUtils.isNotEmpty((Collection)flowNode1.getOutgoingFlows())) {
                for (SequenceFlow sequenceFlow : flowNode1.getOutgoingFlows()) {
                    if (otherHighLightIds.contains(sequenceFlow.getTargetRef()) || activeActivityIds.contains(sequenceFlow.getTargetRef()) || CollectionUtils.isNotEmpty(afteractiveActivityIds) && afteractiveActivityIds.contains(sequenceFlow.getTargetRef())) {
                        deleteFlows.add(sequenceFlow.getId());
                        continue;
                    }
                    this.getTargetFlows(otherHighLightIds, deleteFlows, deleteActivitiIds, sequenceFlow.getId(), sequenceFlow.getTargetRef(), flowNode, flowNodeList, activeActivityIds, afteractiveActivityIds);
                }
            }
        }
    }

    private boolean isHisOrCurrent(String notRunActivitId, List<String> activeActivityIds, List<String> otherHighLightIds, List<String> afterCurrentActId) {
        if (CollectionUtils.isNotEmpty(activeActivityIds)) {
            for (String a : activeActivityIds) {
                if (!notRunActivitId.equals(a)) continue;
                return true;
            }
        }
        if (CollectionUtils.isNotEmpty(otherHighLightIds)) {
            for (String o : otherHighLightIds) {
                if (!notRunActivitId.equals(o)) continue;
                return true;
            }
        }
        if (CollectionUtils.isNotEmpty(afterCurrentActId)) {
            for (String d : afterCurrentActId) {
                if (!notRunActivitId.equals(d)) continue;
                return true;
            }
        }
        return false;
    }

    private void removeDeleteFlow(List<String> deleteFlows, List<String> deleteActivitiIds, List<String> activeActivityIds, String processInstId, List<FlowNode> flowNodeList) {
        if (activeActivityIds.size() != 1 || !activeActivityIds.get(0).contains("addNode_") || activeActivityIds.get(0).contains("exclusiveGateway")) {
            // empty if block
        }
    }
}

