/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.controller;

import com.biz.crm.activiti.service.IActivitiModelerService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.modeler.req.ActivitiModelerReqVo;
import com.biz.crm.nebular.activiti.modeler.resp.ActivitiModelerRespVo;
import com.biz.crm.util.Result;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import javax.annotation.Resource;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.RepositoryService;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"models"})
@Api(tags={"\u5de5\u4f5c\u6d41\u6d41\u7a0b\u6a21\u578b"})
public class ActivitiModelerController {
    private static final Logger log = LoggerFactory.getLogger(ActivitiModelerController.class);
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private IActivitiModelerService iActivitiModelerService;

    @ApiOperation(value="\u67e5\u8be2\u6a21\u578b\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    public Result<PageResult<ActivitiModelerRespVo>> list(@RequestBody ActivitiModelerReqVo activitiModelerReqVo) {
        PageResult<ActivitiModelerRespVo> result = this.iActivitiModelerService.findList(activitiModelerReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @GetMapping(value={"query/{modelId}", "query"})
    public ObjectNode query(@PathVariable String modelId) {
        return this.iActivitiModelerService.query(modelId);
    }

    @ApiOperation(value="\u4fdd\u5b58")
    @PutMapping(value={"/save/{modelId}", "/save"})
    public Result save(@PathVariable String modelId, String name, String description, String json_xml, String svg_xml) {
        this.iActivitiModelerService.save(modelId, name, description, json_xml, svg_xml);
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"delete/{id}"})
    public Result delete(@PathVariable(value="id") String id) {
        this.iActivitiModelerService.delete(id);
        return Result.ok((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u53d1\u5e03")
    @PostMapping(value={"deployment/{id}"})
    public Result deployment(@PathVariable(value="id") String id) throws Exception {
        this.iActivitiModelerService.deployment(id);
        return Result.ok((String)"\u53d1\u5e03\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u9875\u9762\u6a21\u7248json")
    @GetMapping(value={"stencilset"})
    @ResponseBody
    public String stencilset() {
        InputStream stencilsetStream = this.getClass().getClassLoader().getResourceAsStream("stencilset.json");
        try {
            return IOUtils.toString((InputStream)stencilsetStream, (String)"utf-8");
        }
        catch (Exception e) {
            throw new ActivitiException("Error while loading stencil set", (Throwable)e);
        }
    }
}

