/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.design.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.design.entity.TaProcessEntity;
import com.biz.crm.design.mapper.ProcessMapper;
import com.biz.crm.design.mapper.TaProcessMapper;
import com.biz.crm.design.service.ITaNodeConfigService;
import com.biz.crm.design.service.TaProcessService;
import com.biz.crm.design.utils.BizStreamUtils;
import com.biz.crm.design.utils.XmlActivitiUtil;
import com.biz.crm.design.vo.TaProcessVO;
import com.biz.crm.eunm.activiti.Column;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.activiti.ActivitiException;
import com.biz.crm.nebular.activiti.design.req.TaProcessFormReqVO;
import com.biz.crm.nebular.activiti.design.req.TaProcessInfoReqVO;
import com.biz.crm.nebular.activiti.design.resp.TaProcessInfoRespVO;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.DateUtil;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"TaProcessServiceImpl"})
public class TaProcessServiceImpl
extends ServiceImpl<TaProcessMapper, TaProcessEntity>
implements TaProcessService {
    @Resource
    private TaProcessMapper taProcessMapper;
    @Resource
    private ProcessMapper processMapper;
    @Autowired
    private ITaNodeConfigService taNodeConfigService;
    @Autowired
    private RepositoryService repositoryService;

    @Override
    public TaProcessEntity getProcessByKey(final String processKey) {
        List list = this.taProcessMapper.selectByMap(new HashMap<String, Object>(){
            {
                this.put("process_key", processKey);
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (TaProcessEntity)((Object)list.get(0));
        }
        return null;
    }

    @Override
    public TaProcessEntity saveTaProcess(TaProcessVO taProcessVO) {
        if (taProcessVO == null) {
            return null;
        }
        TaProcessEntity entity = null;
        if ("0".equals(taProcessVO.getId())) {
            entity = this.getProcessByKey(taProcessVO.getProcessKey());
            AssertUtils.isTrue((entity == null ? 1 : 0) != 0, (String)"\u6d41\u7a0bKey\u91cd\u590d\u4e86");
            entity = new TaProcessEntity();
        } else {
            entity = this.getProcessByKey(taProcessVO.getProcessKey());
        }
        entity.setNote(taProcessVO.getNote());
        entity.setProcessKey(taProcessVO.getProcessKey());
        entity.setProcessName(taProcessVO.getProcessName());
        entity.setProcessState(taProcessVO.getProcessState());
        String xml = taProcessVO.getProcessDescriptor();
        Map<String, String> nodeRoles = null;
        Map<String, Map<String, String>> nodePropertiesMap = this.buildNodesMultiProperties(taProcessVO.getNodes());
        try {
            nodeRoles = XmlActivitiUtil.getActNodeUserRoles(xml);
            xml = XmlActivitiUtil.addDefListenerXml(xml);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        if (nodePropertiesMap != null && !nodePropertiesMap.isEmpty()) {
            try {
                xml = XmlActivitiUtil.addMultiInstanceProperties(xml, nodePropertiesMap);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        entity.setProcessXml(BizStreamUtils.StringTObyte(this.translateFormula(xml)));
        if (StringUtils.isNotEmpty((CharSequence)entity.getId())) {
            this.taProcessMapper.updateById((Object)entity);
        } else {
            this.taProcessMapper.insert((Object)entity);
        }
        return entity;
    }

    private Map<String, Map<String, String>> buildNodesMultiProperties(String nodes) {
        String[] nodeArr = nodes.split("@@@");
        int num = nodeArr.length;
        HashMap nodePropMap = null;
        if (num > 1) {
            nodePropMap = new HashMap();
            for (int i = 0; i < num; ++i) {
                HashMap<String, String> propMap = new HashMap<String, String>();
                String[] node = nodeArr[i].split("###");
                int proNum = node.length;
                if (proNum > 0) {
                    for (int j = 0; j < proNum; ++j) {
                        String[] properties = node[j].split("=");
                        if (properties.length <= 1) continue;
                        propMap.put(properties[0], properties[1]);
                    }
                }
                if (propMap.size() <= 0) continue;
                nodePropMap.put(propMap.get("id"), propMap);
            }
        }
        return nodePropMap;
    }

    private String translateFormula(String xml) {
        return xml.replace("&gt;", ">").replace("&lt; ", "<").replace("&amp;", "&");
    }

    @Override
    public PageResult<TaProcessInfoRespVO> getProcessInfoList(TaProcessInfoReqVO reqVO) {
        Page page = new Page((long)reqVO.getPageNum().intValue(), (long)reqVO.getPageSize().intValue());
        List<TaProcessInfoRespVO> list = this.taProcessMapper.getProcessInfoList((Page<TaProcessInfoRespVO>)page, reqVO);
        if (CollectionUtils.isNotEmpty(list)) {
            for (TaProcessInfoRespVO vo : list) {
                vo.setProcessStateDesc(Column.PROCESS_STATE.getLabelByCode(vo.getProcessState()));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void deployProcessByKey(String processKey) {
        TaProcessEntity processEntity = this.getProcessByKey(processKey);
        AssertUtils.isNotNull((Object)((Object)processEntity), (CrmExceptionType)ActivitiException.PROCESS_MODEL_NOT_FOUND, (String[])new String[0]);
        AssertUtils.isTrue((processEntity.getProcessState().intValue() == Indicator.PROCESS_STATE_EDIT.getCode() ? 1 : 0) != 0, (CrmExceptionType)ActivitiException.PROCESS_STATUS_ERROR, (String[])new String[0]);
        String oldVersionKey = this.processMapper.getMaxProcessVersionByKey(processKey);
        this.deploy(processEntity);
        String maxVersionKey = this.processMapper.getMaxProcessVersionByKey(processKey);
        if (StringUtils.isEmpty((CharSequence)oldVersionKey)) {
            this.taNodeConfigService.initNodeConfig(processEntity, maxVersionKey);
        } else {
            this.taNodeConfigService.createNodeConfigWhenUpdateProcess(processEntity, oldVersionKey, maxVersionKey);
        }
        processEntity.setProcessState(Indicator.PROCESS_STATE_DEPLOY.getCode());
        processEntity.setLastReleaseTime(DateUtil.formatDate((long)System.currentTimeMillis()));
        this.taProcessMapper.updateById((Object)processEntity);
    }

    @Override
    public void updateProcessFormParam(TaProcessFormReqVO reqVO) {
        this.taProcessMapper.updateProcessFormParam(reqVO.getProcessKey(), reqVO.getFormParam());
    }

    public Deployment deploy(TaProcessEntity process) {
        Deployment deployment = null;
        try {
            InputStream inputStream = BizStreamUtils.byteTOInputStream(process.getProcessXml());
            String srt2 = new String(process.getProcessXml(), "UTF-8");
            deployment = this.repositoryService.createDeployment().addInputStream(process.getProcessKey() + ".bpmn", inputStream).name(process.getProcessKey()).deploy();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u6d41\u7a0b\u53d1\u5e03\u5931\u8d25!");
        }
        return deployment;
    }
}

