/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TaProcessBizRelationMapper;
import com.biz.crm.act.model.TaProcessBizRelationEntity;
import com.biz.crm.act.service.TaProcessBizRelationService;
import com.biz.crm.act.vo.RelationVo;
import com.biz.crm.act.vo.TaProcessBizRelationReqVo;
import com.biz.crm.act.vo.TaProcessBizRelationRespVo;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.activiti.act.TaProcessBizRelationEnum;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="TaProcessBizRelationService")
public class TaProcessBizRelationServiceImpl
extends ServiceImpl<TaProcessBizRelationMapper, TaProcessBizRelationEntity>
implements TaProcessBizRelationService {
    private static final Logger log = LoggerFactory.getLogger(TaProcessBizRelationServiceImpl.class);

    @Override
    public TaProcessBizRelationRespVo getRelationByProcessKey(String processKey) {
        if (processKey == null || StringUtils.isEmpty((String)processKey)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        List entityList = this.list((Wrapper)Wrappers.lambdaQuery(TaProcessBizRelationEntity.class).eq(TaProcessBizRelationEntity::getProcessKey, (Object)processKey));
        ArrayList<RelationVo> menuList = new ArrayList<RelationVo>();
        ArrayList<RelationVo> orgList = new ArrayList<RelationVo>();
        for (TaProcessBizRelationEntity entity : entityList) {
            RelationVo relationVo;
            if (TaProcessBizRelationEnum.BizRelationEnum.MENU.getVal().equals(entity.getRelationType())) {
                relationVo = new RelationVo();
                relationVo.setCode(entity.getBizCode());
                relationVo.setName(entity.getBizName());
                menuList.add(relationVo);
                continue;
            }
            relationVo = new RelationVo();
            relationVo.setCode(entity.getBizCode());
            relationVo.setName(entity.getBizName());
            orgList.add(relationVo);
        }
        TaProcessBizRelationRespVo respVo = new TaProcessBizRelationRespVo();
        respVo.setProcessKey(((TaProcessBizRelationEntity)((Object)entityList.get(1))).getProcessKey());
        respVo.setMenuList(menuList);
        respVo.setOrgList(orgList);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertRelation(TaProcessBizRelationReqVo taProcessBizRelationReqVo) {
        if (!this.checkVo(taProcessBizRelationReqVo)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        this.remove((Wrapper)Wrappers.lambdaQuery(TaProcessBizRelationEntity.class).eq(TaProcessBizRelationEntity::getProcessKey, (Object)taProcessBizRelationReqVo.getProcessKey()));
        List<RelationVo> menuList = taProcessBizRelationReqVo.getMenuList();
        List<RelationVo> orgList = taProcessBizRelationReqVo.getOrgList();
        this.saveBatch(this.getEntityList(menuList, orgList, taProcessBizRelationReqVo));
    }

    private boolean checkVo(TaProcessBizRelationReqVo taProcessBizRelationReqVo) {
        if (taProcessBizRelationReqVo == null) {
            return false;
        }
        String processKey = taProcessBizRelationReqVo.getProcessKey();
        List<RelationVo> menuList = taProcessBizRelationReqVo.getMenuList();
        List<RelationVo> orgList = taProcessBizRelationReqVo.getOrgList();
        if (processKey == null || StringUtils.isEmpty((String)processKey) || menuList == null || orgList == null) {
            return false;
        }
        if (menuList.size() == 0 || orgList.size() == 0) {
            return false;
        }
        if (!this.checkRepeat(menuList)) {
            throw new BusinessException("\u83dc\u5355\u91cd\u590d");
        }
        if (!this.checkRepeat(orgList)) {
            throw new BusinessException("\u7ec4\u7ec7\u91cd\u590d");
        }
        return true;
    }

    private List<TaProcessBizRelationEntity> getEntityList(List<RelationVo> menuList, List<RelationVo> orgList, TaProcessBizRelationReqVo taProcessBizRelationReqVo) {
        TaProcessBizRelationEntity entity;
        ArrayList<TaProcessBizRelationEntity> entityList = new ArrayList<TaProcessBizRelationEntity>();
        for (RelationVo relationVo : menuList) {
            entity = new TaProcessBizRelationEntity();
            entity.setRelationType(TaProcessBizRelationEnum.BizRelationEnum.MENU.getVal());
            entity.setBizCode(relationVo.getCode());
            entity.setBizName(relationVo.getName());
            entity.setProcessKey(taProcessBizRelationReqVo.getProcessKey());
            entityList.add(entity);
        }
        for (RelationVo relationVo : orgList) {
            entity = new TaProcessBizRelationEntity();
            entity.setRelationType(TaProcessBizRelationEnum.BizRelationEnum.ORG.getVal());
            entity.setBizCode(relationVo.getCode());
            entity.setBizName(relationVo.getName());
            entity.setProcessKey(taProcessBizRelationReqVo.getProcessKey());
            entityList.add(entity);
        }
        return entityList;
    }

    private boolean checkRepeat(List<RelationVo> list) {
        HashSet<String> hashSet = new HashSet<String>();
        for (RelationVo relationVo : list) {
            hashSet.add(relationVo.getCode());
        }
        return hashSet.size() == list.size();
    }
}

