/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.biz.crm.act.model.TaActBaseEntity;
import com.biz.crm.act.model.TaActBaseProcessEntity;
import com.biz.crm.act.model.TaProcessOptRecordEntity;
import com.biz.crm.act.service.ITaActBaseProcessService;
import com.biz.crm.act.service.ITaActBaseService;
import com.biz.crm.act.service.ITaProcessOptRecordService;
import com.biz.crm.act.service.ITaTaskService;
import com.biz.crm.act.service.TaskFlowControlService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.activiti.ActivitiException;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaskOptReqVO;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="taTaskService")
public class TaTaskServiceImpl
implements ITaTaskService {
    private static final Logger log = LoggerFactory.getLogger(TaTaskServiceImpl.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ITaProcessOptRecordService taProcessOptRecordService;
    @Autowired
    private ITaActBaseService taActBaseService;
    @Autowired
    private ITaActBaseProcessService taActBaseProcessService;
    @Autowired
    private TaskFlowControlService taskFlowControlService;

    @Override
    public Task getTaskById(String taskId) {
        return (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
    }

    @Override
    public HistoricTaskInstance getHisTaskById(String taskId) {
        return (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
    }

    @Override
    public TaskInfo getTaskInfoByTaskId(String taskId) {
        Task task = this.getTaskById(taskId);
        if (task == null) {
            return this.getHisTaskById(taskId);
        }
        return task;
    }

    @Override
    public String saveComplete(TaskOptReqVO reqVO) {
        Task task = this.getTaskById(reqVO.getTaskId());
        AssertUtils.isNotNull((Object)task, (CrmExceptionType)ActivitiException.ACT_PARAM_TASK_ID, (String[])new String[0]);
        UserRedis user = UserUtils.getUser();
        Map<String, Object> map = this.initOptMap(reqVO.getOptBtnCode(), user);
        TaProcessOptRecordEntity log = this.taProcessOptRecordService.buildOptLogByTaskOpt(user, reqVO.getOptBtnCode(), (TaskInfo)task);
        this.taskService.complete(task.getId(), map);
        this.taProcessOptRecordService.save((Object)log);
        return "\u64cd\u4f5c\u6210\u529f";
    }

    @Override
    public String taskReject(TaskOptReqVO reqVO) {
        Task task = this.getTaskById(reqVO.getTaskId());
        TaActBaseProcessEntity baseProcess = this.taActBaseProcessService.findActBaseByProcessInstId(task.getProcessInstanceId());
        UserRedis user = UserUtils.getUser();
        Map<String, Object> map = this.initOptMap(IndicatorStr.PROCESS_BTN_REJECT_FIRST.getCode(), user);
        TaProcessOptRecordEntity log = this.taProcessOptRecordService.buildOptLogByTaskOpt(user, reqVO.getOptBtnCode(), (TaskInfo)task);
        try {
            this.taskFlowControlService.jump(reqVO.getTaskId(), "DEFAULT_START", map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u9a73\u56de\u5931\u8d25");
        }
        baseProcess.setStatus(Indicator.ACT_BASE_STATUS_REJECT.getCode());
        this.taActBaseProcessService.updateById((Object)baseProcess);
        this.taProcessOptRecordService.save((Object)log);
        return "\u9a73\u56de\u6210\u529f";
    }

    @Override
    public String reStartProcess(TaskOptReqVO reqVO) {
        UserRedis user = UserUtils.getUser();
        TaskInfo taskInfo = this.getTaskInfoByTaskId(reqVO.getTaskId());
        TaActBaseProcessEntity baseProcess = this.taActBaseProcessService.findActBaseByProcessInstId(taskInfo.getProcessInstanceId());
        TaActBaseEntity actBase = (TaActBaseEntity)((Object)this.taActBaseService.getById((Serializable)((Object)baseProcess.getBaseId())));
        StartProcessReqVo startReqVo = new StartProcessReqVo();
        startReqVo.setFormNo(actBase.getFormKey());
        startReqVo.setFormUrl(baseProcess.getFormUrl());
        startReqVo.setPosCode(user.getPoscode());
        startReqVo.setUserCode(user.getUsername());
        startReqVo.setTitle(baseProcess.getTitle());
        startReqVo.setRemark(baseProcess.getRemark());
        startReqVo.setSignTicket("restart:" + new Date().getTime());
        startReqVo.setVariables(this.copyFormParam(taskInfo));
        this.taActBaseService.startProcess(startReqVo);
        return "\u91cd\u65b0\u53d1\u8d77\u6210\u529f";
    }

    private Map<String, Object> copyFormParam(TaskInfo task) {
        Map oldMap = task.getProcessVariables();
        HashMap newMap = null;
        for (Map.Entry entry : oldMap.entrySet()) {
            String mapKey = (String)entry.getKey();
            if (!((String)entry.getKey()).contains("form_")) continue;
            if (newMap == null) {
                newMap = new HashMap();
            }
            newMap.put(((String)entry.getKey()).replace("form_", ""), entry.getValue());
        }
        return newMap;
    }

    private Map<String, Object> initOptMap(String otpBtn, UserRedis user) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("optBtn", otpBtn);
        map.put("current_user", user.getUsername());
        return map;
    }
}

