/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.act.model.TaActBaseEntity;
import com.biz.crm.act.model.TaActBaseProcessEntity;
import com.biz.crm.act.model.TaProcessOptRecordEntity;
import com.biz.crm.act.model.TaTaskCopyEntity;
import com.biz.crm.act.service.ITaActBaseProcessService;
import com.biz.crm.act.service.ITaActBaseService;
import com.biz.crm.act.service.ITaProcessOptRecordService;
import com.biz.crm.act.service.ITaTaskService;
import com.biz.crm.act.service.impl.TaTaskCopyServiceImpl;
import com.biz.crm.activiti.mapper.ActivitiMyTaskMapper;
import com.biz.crm.activiti.service.IActivitiMyTaskService;
import com.biz.crm.common.PageResult;
import com.biz.crm.design.entity.TaFuncRoleEntity;
import com.biz.crm.design.entity.TaNodeConfigEntity;
import com.biz.crm.design.entity.TaProcessEntity;
import com.biz.crm.design.service.ITaFuncRoleService;
import com.biz.crm.design.service.ITaNodeConfigService;
import com.biz.crm.design.service.TaProcessService;
import com.biz.crm.eunm.activiti.Column;
import com.biz.crm.eunm.activiti.ColumnStr;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.activiti.ActivitiException;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.activiti.common.req.ActivitiMyStartReqVo;
import com.biz.crm.nebular.activiti.common.resp.ActivitiCommonRespVo;
import com.biz.crm.nebular.activiti.design.resp.OptBtnVO;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.start.req.ProcessInfoReqVO;
import com.biz.crm.nebular.activiti.task.req.FormParamQueryReqVO;
import com.biz.crm.nebular.activiti.task.req.TaskQueryReqVO;
import com.biz.crm.nebular.activiti.task.resp.FormParamQueryRspVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.activiti.task.resp.ProcessInfoRspVO;
import com.biz.crm.nebular.activiti.task.resp.TaskRspVO;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionDetailRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"ActivitiMyTaskServiceImpl"})
public class ActivitiMyTaskServiceImpl
implements IActivitiMyTaskService {
    private static final Logger log = LoggerFactory.getLogger(ActivitiMyTaskServiceImpl.class);
    @Resource
    private ActivitiMyTaskMapper activitiMyTaskMapper;
    @Autowired
    private ITaActBaseProcessService taActBaseProcessService;
    @Autowired
    private ITaActBaseService taActBaseService;
    @Autowired
    private ITaTaskService taTaskService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;
    @Autowired
    private ITaProcessOptRecordService taProcessOptRecordService;
    @Autowired
    private ITaNodeConfigService taNodeConfigService;
    @Autowired
    private ITaFuncRoleService taFuncRoleService;
    @Autowired
    private TaProcessService taProcessService;
    @Autowired
    private TaTaskCopyServiceImpl taTaskCopyService;

    @Override
    public PageResult<ActivitiCommonRespVo> findList(ActivitiMyStartReqVo activitiMyStartReqVo) {
        Page page = new Page((long)activitiMyStartReqVo.getPageNum().intValue(), (long)activitiMyStartReqVo.getPageSize().intValue());
        List<ActivitiCommonRespVo> list = this.activitiMyTaskMapper.findList((Page<ActivitiCommonRespVo>)page, activitiMyStartReqVo);
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(list).build();
    }

    @Override
    public PageResult<TaskRspVO> findMyCurrentTask(TaskQueryReqVO reqVO) {
        Page taskRspVOPage = PageUtil.buildPage((Integer)reqVO.getPageNum(), (Integer)reqVO.getPageSize());
        UserRedis user = UserUtils.getUser();
        AssertUtils.isNotNull((Object)user, (String)"\u672a\u83b7\u53d6\u5230\u767b\u5f55\u7528\u6237");
        AssertUtils.isNotEmpty((String)user.getPoscode(), (String)"\u8bf7\u5148\u8bbe\u7f6e\u767b\u5f55\u7528\u6237\u804c\u4f4d");
        reqVO.setPositionCode(user.getPoscode());
        List<TaskRspVO> taskRspVOS = this.activitiMyTaskMapper.queryCurrent((Page<TaskRspVO>)taskRspVOPage, reqVO);
        taskRspVOS.forEach(taskRspVO -> taskRspVO.setProcessStateDesc(Column.ACT_BASE_STATUS.getLabelByCode(taskRspVO.getProcessState())));
        return PageResult.builder().count(Long.valueOf(taskRspVOPage.getTotal())).data(taskRspVOS).build();
    }

    @Override
    public PageResult<TaskRspVO> findDoneTask(TaskQueryReqVO reqVO) {
        Page taskRspVOPage = PageUtil.buildPage((Integer)reqVO.getPageNum(), (Integer)reqVO.getPageSize());
        List<TaskRspVO> taskRspVOS = this.activitiMyTaskMapper.queryDone((Page<TaskRspVO>)taskRspVOPage, reqVO);
        return this.getTaskRspVOPageResult((Page<TaskRspVO>)taskRspVOPage, taskRspVOS);
    }

    @Override
    public PageResult<TaskRspVO> findStartTask(TaskQueryReqVO reqVO) {
        Page taskRspVOPage = PageUtil.buildPage((Integer)reqVO.getPageNum(), (Integer)reqVO.getPageSize());
        List<TaskRspVO> taskRspVOS = this.activitiMyTaskMapper.queryStart((Page<TaskRspVO>)taskRspVOPage, reqVO);
        return this.getTaskRspVOPageResult((Page<TaskRspVO>)taskRspVOPage, taskRspVOS);
    }

    private PageResult<TaskRspVO> getTaskRspVOPageResult(Page<TaskRspVO> taskRspVOPage, List<TaskRspVO> taskRspVOS) {
        taskRspVOS.forEach(taskRspVO -> {
            Result result;
            MdmPositionDetailRespVo positionUser;
            taskRspVO.setProcessStateDesc(Column.ACT_BASE_STATUS.getLabelByCode(taskRspVO.getProcessState()));
            if (StringUtils.isNotEmpty((String)taskRspVO.getPendingPostCode()) && ObjectUtils.isNotEmpty((Object)(positionUser = (MdmPositionDetailRespVo)(result = this.mdmPositionFeign.getPositionDetail(null, taskRspVO.getPendingPostCode())).getResult()))) {
                taskRspVO.setPendingPostCode(positionUser.getPositionCode());
                taskRspVO.setPendingPostName(positionUser.getPositionName());
                if (ObjectUtils.isNotEmpty((Object)positionUser.getUser())) {
                    taskRspVO.setPendingUserCode(positionUser.getUser().getUserName());
                    taskRspVO.setPendingUserName(positionUser.getUser().getFullName());
                }
            }
        });
        return PageResult.builder().count(Long.valueOf(taskRspVOPage.getTotal())).data(taskRspVOS).build();
    }

    @Override
    public List<OptRecordRspVO> getOptRecordNoPage(OptRecordReqVO optRecordReqVO) {
        List<OptRecordRspVO> taskRspVOS = this.activitiMyTaskMapper.getOptRecordNoPage(optRecordReqVO);
        taskRspVOS.forEach(taskRspVO -> taskRspVO.setOperationStr(ColumnStr.PROCESS_BTN.getLabelByCode(taskRspVO.getOperation())));
        String procInstId = taskRspVOS.get(0).getProcessInstId();
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procInstId)).orderByTaskCreateTime()).desc()).list();
        if (CollectionUtils.isNotEmpty((Collection)taskList)) {
            ArrayList<OptRecordRspVO> taskOptList = new ArrayList<OptRecordRspVO>();
            OptRecordRspVO tmp = taskRspVOS.get(0);
            for (Task task : taskList) {
                OptRecordRspVO rspVO = new OptRecordRspVO();
                rspVO.setProcessInstId(procInstId);
                Result result = this.mdmPositionFeign.getPositionDetail(null, task.getAssignee());
                MdmPositionDetailRespVo positionUser = (MdmPositionDetailRespVo)result.getResult();
                rspVO.setUserName(positionUser.getUser().getFullName());
                rspVO.setUserCode(positionUser.getUser().getUserName());
                rspVO.setPositionCode(positionUser.getPositionCode());
                rspVO.setPositionName(positionUser.getPositionName());
                rspVO.setCreateTime(task.getCreateTime());
                rspVO.setTaskDefKey(task.getTaskDefinitionKey());
                rspVO.setTaskName(task.getName());
                rspVO.setTaskId(task.getId());
                rspVO.setProcessVersionKey(task.getProcessDefinitionId());
                rspVO.setProcessKey(tmp.getProcessKey());
                rspVO.setProcessName(tmp.getProcessName());
                rspVO.setContent("\u5f53\u524d\u5f85\u529e\u8282\u70b9");
                rspVO.setTitle(tmp.getTitle());
                rspVO.setApplierName(tmp.getApplierName());
                rspVO.setFormNo(tmp.getFormNo());
                rspVO.setId(task.getId());
                rspVO.setOperation("BTN_999");
                rspVO.setOperationStr("\u5f85\u5904\u7406");
                taskOptList.add(rspVO);
            }
            taskOptList.addAll(taskRspVOS);
            return taskOptList;
        }
        return taskRspVOS;
    }

    @Override
    public PageResult<OptRecordRspVO> getOptRecords(OptRecordReqVO optRecordReqVO) {
        Page page = PageUtil.buildPage((Integer)optRecordReqVO.getPageNum(), (Integer)optRecordReqVO.getPageSize());
        List<OptRecordRspVO> taskRspVOS = this.activitiMyTaskMapper.queryOptRecords((Page<OptRecordRspVO>)page, optRecordReqVO);
        taskRspVOS.forEach(taskRspVO -> taskRspVO.setOperationStr(ColumnStr.PROCESS_BTN.getLabelByCode(taskRspVO.getOperation())));
        return PageResult.builder().count(Long.valueOf(page.getTotal())).data(taskRspVOS).build();
    }

    @Override
    public ProcessInfoRspVO getProcessInfo(ProcessInfoReqVO processInfoReqVO) {
        boolean copyTask = this.checkIsCopyTask(processInfoReqVO);
        ProcessInfoRspVO rspVO = new ProcessInfoRspVO();
        rspVO.setProcessInstanceId(processInfoReqVO.getProcessInstanceId());
        List<TaActBaseProcessEntity> baseProcessList = this.taActBaseProcessService.findActBase(processInfoReqVO);
        AssertUtils.isTrue((boolean)CollectionUtil.listNotEmpty(baseProcessList), (String)"\u672a\u83b7\u53d6\u5230\u6d41\u7a0b\u4fe1\u606f");
        TaActBaseProcessEntity baseProcess = baseProcessList.get(0);
        TaActBaseEntity actBase = (TaActBaseEntity)((Object)this.taActBaseService.getById((Serializable)((Object)baseProcess.getBaseId())));
        rspVO.setTaskId(processInfoReqVO.getTaskId());
        rspVO.setApplierCode(baseProcess.getApplierCode());
        rspVO.setApplierName(baseProcess.getApplierName());
        rspVO.setApplierPositionCode(baseProcess.getPositionCode());
        rspVO.setApplierPositionName(baseProcess.getPositionName());
        rspVO.setCauseType(baseProcess.getCauseType());
        rspVO.setStartTime(baseProcess.getStartTime());
        rspVO.setTitle(baseProcess.getTitle());
        rspVO.setFormNo(actBase.getFormKey());
        rspVO.setFormType(actBase.getFormType());
        rspVO.setCostType(actBase.getCostType());
        rspVO.setStatus(baseProcess.getStatus());
        rspVO.setFormUrl(baseProcess.getFormUrl());
        rspVO.setRemark(baseProcess.getRemark());
        rspVO.setProcessKey(baseProcess.getProcessKey());
        rspVO.setProcessVersionKey(baseProcess.getProcessVersionKey());
        TaskInfo taskInfo = null;
        taskInfo = copyTask ? this.setCopyTaskCurrent(processInfoReqVO, rspVO) : this.setTaskCurrentInfo(processInfoReqVO, rspVO, baseProcess);
        rspVO.setTaskDefKey(taskInfo.getTaskDefinitionKey());
        List<TaProcessOptRecordEntity> optList = this.taProcessOptRecordService.getOptRecordByProcInstId(baseProcess.getProcessInstanceId());
        TaProcessOptRecordEntity lastOpt = optList.get(0);
        rspVO.setLastOptBtn(lastOpt.getOperation());
        rspVO.setLastOptBtnDesc(ColumnStr.PROCESS_BTN.getLabelByCode(lastOpt.getOperation()));
        rspVO.setLastUserCode(lastOpt.getUserCode());
        rspVO.setLastUserName(lastOpt.getUserName());
        rspVO.setLastUserPositionCode(lastOpt.getPositionCode());
        rspVO.setLastUserPositionName(lastOpt.getPositionName());
        rspVO.setLastOptRemark(lastOpt.getContent());
        TaNodeConfigEntity nodeConfig = this.taNodeConfigService.findNodeByTaskVersionKey(baseProcess.getProcessVersionKey(), taskInfo.getTaskDefinitionKey());
        if (Indicator.COMMON_ENABLE.getCode() == nodeConfig.getAllowMobile().intValue()) {
            rspVO.setAllowMobile(Boolean.valueOf(true));
        } else {
            rspVO.setAllowMobile(Boolean.valueOf(false));
        }
        TaFuncRoleEntity funcRole = this.taFuncRoleService.findOneByCode(nodeConfig.getBtnAuthRoleId());
        AssertUtils.isNotNull((Object)((Object)funcRole), (CrmExceptionType)ActivitiException.TASK_NO_BTN_AUTH, (String[])new String[0]);
        if (copyTask) {
            rspVO.setBtnAuths(IndicatorStr.PROCESS_BTN_ISSUE.getCode());
            rspVO.setBtnList(this.getCopyTaskBtnList());
        } else {
            rspVO.setBtnAuths(funcRole.getRoleAuths());
            rspVO.setBtnList(this.getBtnList(funcRole.getRoleAuths()));
        }
        return rspVO;
    }

    private TaskInfo setTaskCurrentInfo(ProcessInfoReqVO processInfoReqVO, ProcessInfoRspVO rspVO, TaActBaseProcessEntity baseProcess) {
        Object taskInfo = null;
        Task task = null;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)processInfoReqVO.getTaskId())) {
            task = this.taTaskService.getTaskById(processInfoReqVO.getTaskId());
        }
        if (task == null) {
            taskInfo = org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)processInfoReqVO.getTaskId()) ? this.taTaskService.getHisTaskById(processInfoReqVO.getTaskId()) : (TaskInfo)this.taTaskService.getHisTaskInstId(baseProcess.getProcessInstanceId()).get(0);
            rspVO.setTaskType(Integer.valueOf(Indicator.TASK_TYPE_HIS.getCode()));
            TaProcessOptRecordEntity optRecord = this.taProcessOptRecordService.getOptRecordByTaskId(taskInfo.getId());
            rspVO.setCurrentUserCode(optRecord.getUserCode());
            rspVO.setCurrentUserName(optRecord.getUserName());
            rspVO.setCurrentUserPositionCode(optRecord.getPositionCode());
            rspVO.setCurrentUserPositionName(optRecord.getPositionName());
        } else {
            rspVO.setTaskType(Integer.valueOf(Indicator.TASK_TYPE_RUN.getCode()));
            taskInfo = this.taTaskService.getHisTaskById(task.getId());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)taskInfo.getAssignee())) {
                Result result = this.mdmPositionFeign.getPositionDetail(null, taskInfo.getAssignee());
                MdmPositionDetailRespVo positionUser = (MdmPositionDetailRespVo)result.getResult();
                rspVO.setCurrentUserCode(positionUser.getUser().getUserName());
                rspVO.setCurrentUserName(positionUser.getUser().getFullName());
                rspVO.setCurrentUserPositionCode(positionUser.getPositionCode());
                rspVO.setCurrentUserPositionName(positionUser.getPositionName());
            } else {
                log.info("\u5f85\u529e\u8282\u70b9\u6ca1\u6709\u5f85\u529e\u5c97\u4f4d\uff0c\u8bf7\u68c0\u67e5!");
            }
        }
        return taskInfo;
    }

    private TaskInfo setCopyTaskCurrent(ProcessInfoReqVO reqVO, ProcessInfoRspVO rspVO) {
        TaTaskCopyEntity taTaskCopy = (TaTaskCopyEntity)((Object)this.taTaskCopyService.getById((Serializable)((Object)reqVO.getCopyTaskId())));
        AssertUtils.isNotNull((Object)((Object)taTaskCopy), (String)"\u975e\u52a0\u7b7e\u8282\u70b9!");
        rspVO.setTaskType(Integer.valueOf(Indicator.TASK_TYPE_COPY.getCode()));
        rspVO.setCurrentUserCode(taTaskCopy.getUserCode());
        rspVO.setCurrentUserName(taTaskCopy.getUserName());
        rspVO.setCurrentUserPositionCode(taTaskCopy.getPosCode());
        rspVO.setCurrentUserPositionName(taTaskCopy.getPosName());
        return this.taTaskService.getTaskInfoByTaskId(taTaskCopy.getTaskId());
    }

    private boolean checkIsCopyTask(ProcessInfoReqVO reqVO) {
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVO.getCopyTaskId());
    }

    @Override
    public FormParamQueryRspVO getProcessFormParam(FormParamQueryReqVO reqVO) {
        TaskInfo taskInfo;
        FormParamQueryRspVO rspVO = new FormParamQueryRspVO();
        TaActBaseProcessEntity process = this.taActBaseProcessService.findActBaseByProcessInstId(reqVO.getProcessInstId());
        TaActBaseEntity base = (TaActBaseEntity)((Object)this.taActBaseService.getById((Serializable)((Object)process.getBaseId())));
        TaProcessEntity processDef = this.taProcessService.getProcessByKey(process.getProcessKey());
        rspVO.setUrlParam(processDef.getFormParam());
        rspVO.setId(base.getFormKey());
        rspVO.setStatus(false);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVO.getTaskId()) && (taskInfo = this.taTaskService.getTaskInfoByTaskId(reqVO.getTaskId())) != null) {
            TaNodeConfigEntity nodeConfig = this.taNodeConfigService.findNodeByTaskVersionKey(process.getProcessVersionKey(), taskInfo.getTaskDefinitionKey());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)nodeConfig.getFormRole()) && nodeConfig.getFormRole().contains("update")) {
                rspVO.setStatus(true);
            }
            rspVO.setFormRole(nodeConfig.getFormRole());
        }
        return rspVO;
    }

    private List<OptBtnVO> getBtnList(String btnAuth) {
        String[] btnStr = btnAuth.split(",");
        ArrayList<OptBtnVO> btnList = new ArrayList<OptBtnVO>();
        for (String btn : btnStr) {
            OptBtnVO btnVO = new OptBtnVO();
            btnVO.setBtnCode(btn);
            btnVO.setBtnName(ColumnStr.PROCESS_BTN.getLabelByCode(btn));
            btnList.add(btnVO);
        }
        return btnList;
    }

    private List<OptBtnVO> getCopyTaskBtnList() {
        ArrayList<OptBtnVO> btnList = new ArrayList<OptBtnVO>();
        OptBtnVO btnVO = new OptBtnVO();
        btnVO.setBtnCode(IndicatorStr.PROCESS_BTN_ISSUE.getCode());
        btnVO.setBtnName(IndicatorStr.PROCESS_BTN_ISSUE.getLabel());
        btnList.add(btnVO);
        return btnList;
    }

    private List<TaskRspVO> buildCurrentTestList(String userCode, Indicator status, Date dateTaskDone) {
        Date date = DateUtil.getDateByFormat((String)"2020-11-23 11:52:21", (String)"yyyy-MM-dd HH:mm:ss");
        Date dateTask = DateUtil.getDateByFormat((String)"2020-11-24 16:52:21", (String)"yyyy-MM-dd HH:mm:ss");
        ArrayList<TaskRspVO> taskList = new ArrayList<TaskRspVO>();
        TaskRspVO rspVO = new TaskRspVO();
        rspVO.setCreateTime(date);
        rspVO.setCurrentCode(userCode);
        rspVO.setCurrentName("\u6f14\u793a\u4eba\u5458");
        rspVO.setCurrentPosCode("testpos1");
        rspVO.setCurrentPosName("\u6f14\u793a\u5c97\u4f4d1");
        rspVO.setFormNo("TEST100001");
        rspVO.setFormTitle("\u6f14\u793a:XXX\u5e02\u6c83\u5c14\u739b\u8d85\u5e02\u5546\u54c1\u9648\u5217\u6d3b\u52a8\u8d39\u7528\u7533\u8bf7");
        rspVO.setFormType(IndicatorStr.FORM_TYPE_SFA.getCode());
        rspVO.setCostType(IndicatorStr.COST_TYPE_LEAVE.getCode());
        rspVO.setProcessInstanceId("test_pro_inst_10001");
        rspVO.setProcessKey("DEMO_SHOW_PROCESS");
        rspVO.setProcessName("\u6f14\u793a\u6d41\u7a0b:\u9648\u5217\u6d3b\u52a8\u7533\u8bf7\u6d41\u7a0b");
        rspVO.setProcessState(Integer.valueOf(status.getCode()));
        rspVO.setProcessStateDesc(status.getLabel());
        rspVO.setStartPosCode("testpos101");
        rspVO.setStartPosName("\u6f14\u793a\u5c97\u4f4d101");
        rspVO.setStartUserCode("start001");
        rspVO.setStartUserName("\u6f14\u793a\u53d1\u8d77\u4eba\u7532");
        rspVO.setTaskDefKey("MANAGER_AUDIT");
        rspVO.setTaskName("\u7ecf\u7406\u5ba1\u6279");
        rspVO.setTaskId("test1234567");
        rspVO.setTaskCreateTime(dateTask);
        rspVO.setTaskDoneTime(dateTaskDone);
        TaskRspVO rspVO2 = new TaskRspVO();
        rspVO2.setCreateTime(date);
        rspVO2.setCurrentCode(userCode);
        rspVO2.setCurrentName("\u6f14\u793a\u4eba\u5458");
        rspVO2.setCurrentPosCode("testpos1");
        rspVO2.setCurrentPosName("\u6f14\u793a\u5c97\u4f4d1");
        rspVO2.setFormNo("TEST100002");
        rspVO2.setFormTitle("\u6f14\u793a:XXX\u5e02\u5bb6\u4e50\u798f\u8d85\u5e02\u5546\u54c1\u9648\u5217\u6d3b\u52a8\u8d39\u7528\u7533\u8bf7");
        rspVO2.setFormType(IndicatorStr.FORM_TYPE_SFA.getCode());
        rspVO2.setCostType(IndicatorStr.COST_TYPE_OVERTIME.getCode());
        rspVO2.setProcessInstanceId("test_pro_inst_10002");
        rspVO2.setProcessKey("DEMO_SHOW_PROCESS");
        rspVO2.setProcessName("\u6f14\u793a\u6d41\u7a0b:\u9648\u5217\u6d3b\u52a8\u7533\u8bf7\u6d41\u7a0b");
        rspVO2.setProcessState(Integer.valueOf(status.getCode()));
        rspVO2.setProcessStateDesc(status.getLabel());
        rspVO2.setStartPosCode("testpos102");
        rspVO2.setStartPosName("\u6f14\u793a\u5c97\u4f4d102");
        rspVO2.setStartUserCode("start002");
        rspVO2.setStartUserName("\u6f14\u793a\u53d1\u8d77\u4eba\u4e59");
        rspVO2.setTaskDefKey("MANAGER_AUDIT");
        rspVO2.setTaskName("\u7ecf\u7406\u5ba1\u6279");
        rspVO2.setTaskId("test12345678");
        rspVO.setTaskCreateTime(dateTask);
        rspVO.setTaskDoneTime(dateTaskDone);
        TaskRspVO rspVO3 = new TaskRspVO();
        rspVO3.setCreateTime(date);
        rspVO3.setCurrentCode(userCode);
        rspVO3.setCurrentName("\u6f14\u793a\u4eba\u5458");
        rspVO3.setCurrentPosCode("testpos1");
        rspVO3.setCurrentPosName("\u6f14\u793a\u5c97\u4f4d1");
        rspVO3.setFormNo("TEST100003");
        rspVO3.setFormTitle("\u6f14\u793a:XXX\u4e07\u8fbe\u5546\u57ce\u5546\u54c1\u9648\u5217\u6d3b\u52a8\u8d39\u7528\u7533\u8bf7");
        rspVO3.setFormType(IndicatorStr.FORM_TYPE_SFA.getCode());
        rspVO3.setCostType(IndicatorStr.COST_TYPE_EXCEPTION.getCode());
        rspVO3.setProcessInstanceId("test_pro_inst_10003");
        rspVO3.setProcessKey("DEMO_SHOW_PROCESS");
        rspVO3.setProcessName("\u6f14\u793a\u6d41\u7a0b:\u9648\u5217\u6d3b\u52a8\u7533\u8bf7\u6d41\u7a0b");
        rspVO3.setProcessState(Integer.valueOf(status.getCode()));
        rspVO3.setProcessStateDesc(status.getLabel());
        rspVO3.setStartPosCode("testpos103");
        rspVO3.setStartPosName("\u6f14\u793a\u5c97\u4f4d103");
        rspVO3.setStartUserCode("start003");
        rspVO3.setStartUserName("\u6f14\u793a\u53d1\u8d77\u4eba\u4e19");
        rspVO3.setTaskDefKey("MANAGER_AUDIT");
        rspVO3.setTaskName("\u7ecf\u7406\u5ba1\u6279");
        rspVO3.setTaskId("test123456789");
        rspVO.setTaskCreateTime(dateTask);
        rspVO.setTaskDoneTime(dateTaskDone);
        taskList.add(rspVO);
        taskList.add(rspVO2);
        taskList.add(rspVO3);
        return taskList;
    }

    private List<TaskRspVO> buildStartTestList(String userCode, Indicator status) {
        Date date = DateUtil.getDateByFormat((String)"2020-11-23 11:52:21", (String)"yyyy-MM-dd HH:mm:ss");
        ArrayList<TaskRspVO> taskList = new ArrayList<TaskRspVO>();
        TaskRspVO rspVO = new TaskRspVO();
        rspVO.setCreateTime(date);
        rspVO.setCurrentCode(userCode);
        rspVO.setCurrentName("\u6f14\u793a\u53d1\u8d77\u4eba\u5458");
        rspVO.setCurrentPosCode("startPOS001");
        rspVO.setCurrentPosName("\u6f14\u793a\u53d1\u8d77\u5c97\u4f4d101");
        rspVO.setFormNo("TEST100001");
        rspVO.setFormTitle("\u6f14\u793a:XXX\u5e02\u6c83\u5c14\u739b\u8d85\u5e02\u5546\u54c1\u9648\u5217\u6d3b\u52a8\u8d39\u7528\u7533\u8bf7");
        rspVO.setFormType(IndicatorStr.FORM_TYPE_SFA.getCode());
        rspVO.setCostType(IndicatorStr.COST_TYPE_LEAVE.getCode());
        rspVO.setProcessInstanceId("test_pro_inst_10001");
        rspVO.setProcessKey("DEMO_SHOW_PROCESS");
        rspVO.setProcessName("\u6f14\u793a\u6d41\u7a0b:\u9648\u5217\u6d3b\u52a8\u7533\u8bf7\u6d41\u7a0b");
        rspVO.setProcessState(Integer.valueOf(Indicator.ACT_BASE_STATUS_FINISH.getCode()));
        rspVO.setProcessStateDesc(Indicator.ACT_BASE_STATUS_FINISH.getLabel());
        rspVO.setStartPosCode("startPOS001");
        rspVO.setStartPosName("\u6f14\u793a\u53d1\u8d77\u5c97\u4f4d101");
        rspVO.setStartUserCode(userCode);
        rspVO.setStartUserName("\u6f14\u793a\u53d1\u8d77\u4eba\u5458");
        rspVO.setTaskDefKey("DEFAULT_START");
        rspVO.setTaskName("\u53d1\u8d77\u8282\u70b9");
        rspVO.setTaskId("test1234567");
        rspVO.setTaskCreateTime(date);
        rspVO.setTaskDoneTime(date);
        TaskRspVO rspVO2 = new TaskRspVO();
        rspVO2.setCreateTime(date);
        rspVO2.setCurrentCode(userCode);
        rspVO2.setCurrentName("\u6f14\u793a\u53d1\u8d77\u4eba\u5458");
        rspVO2.setCurrentPosCode("startPOS001");
        rspVO2.setCurrentPosName("\u6f14\u793a\u53d1\u8d77\u5c97\u4f4d101");
        rspVO2.setFormNo("TEST100002");
        rspVO2.setFormTitle("\u6f14\u793a:XXX\u5e02\u5bb6\u4e50\u798f\u8d85\u5e02\u5546\u54c1\u9648\u5217\u6d3b\u52a8\u8d39\u7528\u7533\u8bf7");
        rspVO2.setFormType(IndicatorStr.FORM_TYPE_SFA.getCode());
        rspVO2.setCostType(IndicatorStr.COST_TYPE_OVERTIME.getCode());
        rspVO2.setProcessInstanceId("test_pro_inst_10002");
        rspVO2.setProcessKey("DEMO_SHOW_PROCESS");
        rspVO2.setProcessName("\u6f14\u793a\u6d41\u7a0b:\u9648\u5217\u6d3b\u52a8\u7533\u8bf7\u6d41\u7a0b");
        rspVO2.setProcessState(Integer.valueOf(status.getCode()));
        rspVO2.setProcessStateDesc(status.getLabel());
        rspVO2.setStartPosCode("startPOS001");
        rspVO2.setStartPosName("\u6f14\u793a\u53d1\u8d77\u5c97\u4f4d101");
        rspVO2.setStartUserCode(userCode);
        rspVO2.setStartUserName("\u6f14\u793a\u53d1\u8d77\u4eba\u5458");
        rspVO2.setTaskDefKey("DEFAULT_START");
        rspVO2.setTaskName("\u53d1\u8d77\u8282\u70b9");
        rspVO2.setTaskId("test12345678");
        rspVO.setTaskCreateTime(date);
        rspVO.setTaskDoneTime(date);
        TaskRspVO rspVO3 = new TaskRspVO();
        rspVO3.setCreateTime(date);
        rspVO3.setCurrentCode(userCode);
        rspVO3.setCurrentName("\u6f14\u793a\u53d1\u8d77\u4eba\u5458");
        rspVO3.setCurrentPosCode("startPOS001");
        rspVO3.setCurrentPosName("\u6f14\u793a\u53d1\u8d77\u5c97\u4f4d101");
        rspVO3.setFormNo("TEST100003");
        rspVO3.setFormTitle("\u6f14\u793a:XXX\u4e07\u8fbe\u5546\u57ce\u5546\u54c1\u9648\u5217\u6d3b\u52a8\u8d39\u7528\u7533\u8bf7");
        rspVO3.setFormType(IndicatorStr.FORM_TYPE_SFA.getCode());
        rspVO3.setCostType(IndicatorStr.COST_TYPE_EXCEPTION.getCode());
        rspVO3.setProcessInstanceId("test_pro_inst_10003");
        rspVO3.setProcessKey("DEMO_SHOW_PROCESS");
        rspVO3.setProcessName("\u6f14\u793a\u6d41\u7a0b:\u9648\u5217\u6d3b\u52a8\u7533\u8bf7\u6d41\u7a0b");
        rspVO3.setProcessState(Integer.valueOf(status.getCode()));
        rspVO3.setProcessStateDesc(status.getLabel());
        rspVO3.setStartPosCode("startPOS001");
        rspVO3.setStartPosName("\u6f14\u793a\u53d1\u8d77\u5c97\u4f4d101");
        rspVO3.setStartUserCode(userCode);
        rspVO3.setStartUserName("\u6f14\u793a\u53d1\u8d77\u4eba\u5458");
        rspVO3.setTaskDefKey("DEFAULT_START");
        rspVO3.setTaskName("\u53d1\u8d77\u8282\u70b9");
        rspVO3.setTaskId("test123456789");
        rspVO.setTaskCreateTime(date);
        rspVO.setTaskDoneTime(date);
        taskList.add(rspVO);
        taskList.add(rspVO2);
        taskList.add(rspVO3);
        return taskList;
    }
}

