/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TaProcessOptRecordMapper;
import com.biz.crm.act.model.TaActBaseProcessEntity;
import com.biz.crm.act.model.TaProcessOptRecordEntity;
import com.biz.crm.act.service.ITaProcessOptRecordService;
import com.biz.crm.eunm.activiti.ColumnStr;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.util.UserRedis;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="taProcessOptRecordService")
public class TaProcessOptRecordServiceImpl
extends ServiceImpl<TaProcessOptRecordMapper, TaProcessOptRecordEntity>
implements ITaProcessOptRecordService {
    private static final Logger log = LoggerFactory.getLogger(TaProcessOptRecordServiceImpl.class);
    @Resource
    private TaProcessOptRecordMapper taProcessOptRecordMapper;

    @Override
    public TaProcessOptRecordEntity buildOptLogWhenProcessStart(ProcessInstance instance, TaActBaseProcessEntity baseProcess) {
        TaProcessOptRecordEntity log = new TaProcessOptRecordEntity();
        log.setCreateTime(new Date());
        log.setTaskId(null);
        log.setUserCode(baseProcess.getApplierCode());
        log.setUserName(baseProcess.getApplierName());
        log.setOperation(IndicatorStr.PROCESS_BTN_START.getCode());
        log.setContent(baseProcess.getRemark());
        log.setTaskDefKey("start_process");
        log.setTaskName("\u53d1\u8d77\u6d41\u7a0b");
        log.setPositionCode(baseProcess.getPositionCode());
        log.setPositionName(baseProcess.getPositionName());
        this.setParamByActBase(log, instance.getProcessInstanceId(), instance.getProcessDefinitionId(), "autoStartProcess");
        return log;
    }

    private void setParamByActBase(TaProcessOptRecordEntity log, String processInstanceId, String processDefinitionId, String autoStartProcess) {
        log.setProcessInstId(processInstanceId);
        log.setProcessVersionKey(processDefinitionId);
        if (StringUtils.isEmpty((String)log.getUserCode())) {
            log.setUserCode(autoStartProcess);
        }
        if (StringUtils.isEmpty((String)log.getUserName())) {
            log.setUserName(autoStartProcess);
        }
        if (StringUtils.isEmpty((String)log.getProcessInstId())) {
            log.setProcessInstId(autoStartProcess);
        }
        if (StringUtils.isEmpty((String)log.getProcessVersionKey())) {
            log.setProcessVersionKey(autoStartProcess);
        }
    }

    @Override
    public TaProcessOptRecordEntity buildOptLogWhenPassStartTask(Task task, TaActBaseProcessEntity baseProcess) {
        TaProcessOptRecordEntity log = new TaProcessOptRecordEntity();
        log.setCreateTime(new Date());
        log.setTaskId(task.getId());
        log.setUserCode(baseProcess.getApplierCode());
        log.setUserName(baseProcess.getApplierName());
        log.setOperation(IndicatorStr.PROCESS_BTN_SUBMIT.getCode());
        log.setContent("\u81ea\u52a8\u5b8c\u6210\u53d1\u8d77\u8282\u70b9");
        log.setTaskDefKey(task.getTaskDefinitionKey());
        log.setTaskName(task.getName());
        log.setPositionCode(baseProcess.getPositionCode());
        log.setPositionName(baseProcess.getPositionName());
        this.setParamByActBase(log, task.getProcessInstanceId(), task.getProcessDefinitionId(), "autoPassStartTask");
        return log;
    }

    @Override
    public TaProcessOptRecordEntity getOptRecordByTaskId(String taskId) {
        return this.taProcessOptRecordMapper.getOptRecordByTaskId(taskId);
    }

    @Override
    public List<TaProcessOptRecordEntity> getOptRecordByProcInstId(String procInstId) {
        return this.taProcessOptRecordMapper.getOptRecordByProcInstId(procInstId);
    }

    @Override
    public TaProcessOptRecordEntity buildOptLogByTaskOpt(UserRedis user, String optBtn, TaskInfo taskInfo, String remark) {
        TaProcessOptRecordEntity log = new TaProcessOptRecordEntity();
        log.setCreateTime(new Date());
        log.setTaskId(taskInfo.getId());
        log.setUserCode(user.getUsername());
        log.setUserName(user.getRealname());
        log.setOperation(optBtn);
        if (StringUtils.isNotEmpty((String)remark)) {
            log.setContent(remark);
        } else {
            log.setContent(ColumnStr.PROCESS_BTN.getLabelByCode(optBtn));
        }
        log.setTaskDefKey(taskInfo.getTaskDefinitionKey());
        log.setTaskName(taskInfo.getName());
        log.setPositionCode(user.getPoscode());
        log.setPositionName(user.getPosname());
        log.setProcessInstId(taskInfo.getProcessInstanceId());
        log.setProcessVersionKey(taskInfo.getProcessDefinitionId());
        return log;
    }
}

