/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.design.service.impl;

import com.biz.crm.design.mapper.HistoryMapper;
import com.biz.crm.design.mapper.RuntimeMapper;
import com.biz.crm.design.service.RuntimeInfoService;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.RuntimeServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RuntimInfoServiceImpl
implements RuntimeInfoService {
    private static final Logger log = LoggerFactory.getLogger(RuntimInfoServiceImpl.class);
    @Resource
    private RuntimeMapper runtimeMapper;
    @Resource
    private HistoryMapper historyMapper;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private TaskService taskService;

    @Override
    public List<Map<String, Object>> myTasks(String userId) {
        return this.runtimeMapper.selectMyTasksToDo(userId);
    }

    @Override
    @Transactional
    public boolean rejected(String taskId, String rejectElemKey, String dealReason) {
        int res = 0;
        Map<String, Object> endEvent = this.historyMapper.selectEndEventByTaskId(taskId);
        log.info("\u67e5\u8be2hi_taskinst\u7ed3\u675f\u4e8b\u4ef6\u7684\u7ed3\u679c\uff0c{}", endEvent);
        List<Map<String, Object>> hiTask = this.historyMapper.selectHiTaskByTaskId(taskId);
        String ruExcutionId = (String)hiTask.get(0).get("EXECUTION_ID_");
        String _processId = (String)hiTask.get(0).get("PROC_INST_ID_");
        if ("S00000".equals(rejectElemKey)) {
            if (null == endEvent || endEvent.isEmpty()) {
                res = this.runtimeMapper.deleteRuVariable(taskId);
                log.info("\u5220ru_variables\u7ed3\u675f\uff0c{}", (Object)res);
                TaskEntity currentTaskEntity = (TaskEntity)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(_processId)).singleResult();
                currentTaskEntity.setExecutionId(null);
                this.taskService.saveTask((Task)currentTaskEntity);
                this.taskService.deleteTask(currentTaskEntity.getId(), true);
                log.info("\u5220ru_task\u7ed3\u675f\uff0c{}", (Object)currentTaskEntity);
                res = this.runtimeMapper.deleteRuExecution(taskId);
                log.info("\u5220ru_execution\u7ed3\u675f\uff0c{}", (Object)res);
                res = this.runtimeMapper.deleteRuIdentity(taskId);
                log.info("\u5220ru_identitylink\u7ed3\u675f\uff0c{}", (Object)res);
            } else {
                res = this.historyMapper.deleteHiEndEvent(taskId);
                log.info("\u5220\u6389hi_actinst\u4e2dendEvent\u7ed3\u675f\uff0c{}", (Object)res);
            }
        } else {
            this.jumpEndActivity(ruExcutionId, rejectElemKey, dealReason);
        }
        return true;
    }

    public ActivityImpl queryTargetActivity(String id) {
        ProcessDefinitionEntity deployedProcessDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition("ziyouliu:1:4");
        List activities = deployedProcessDefinition.getActivities();
        for (ActivityImpl activityImpl : activities) {
            if (!activityImpl.getId().equals(id)) continue;
            return activityImpl;
        }
        return null;
    }

    public ActivityImpl qureyCurrentTask(String processDefinitionId) {
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processDefinitionId(processDefinitionId).singleResult();
        String activityId = execution.getActivityId();
        ActivityImpl currentActivity = this.queryTargetActivity(activityId);
        log.info(currentActivity.getId() + "" + currentActivity.getProperty("name"));
        return currentActivity;
    }

    public void jumpEndActivity(final String executionId, final String targetActId, final String reason) {
        ((RuntimeServiceImpl)this.runtimeService).getCommandExecutor().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                ExecutionEntity execution = commandContext.getExecutionEntityManager().findExecutionById(executionId);
                execution.destroyScope(reason);
                ProcessDefinitionImpl processDefinition = execution.getProcessDefinition();
                ActivityImpl findActivity = processDefinition.findActivity(targetActId);
                execution.executeActivity((PvmActivity)findActivity);
                return execution;
            }
        });
        log.info("\u81ea\u7531\u8df3\u8f6c\u81f3\u8282\u70b9\uff1a{}-----\u5b8c\u6210", (Object)targetActId);
    }
}

