/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TaProcessBizRelationMapper;
import com.biz.crm.act.model.TaProcessBizRelationEntity;
import com.biz.crm.act.service.TaProcessBizRelationService;
import com.biz.crm.act.vo.RelationVo;
import com.biz.crm.act.vo.TaProcessBizRelationReqVo;
import com.biz.crm.act.vo.TaProcessBizRelationRespVo;
import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.activiti.act.TaProcessBizRelationEnum;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TaProcessBizRelationServiceImpl"})
public class TaProcessBizRelationServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TaProcessBizRelationMapper, TaProcessBizRelationEntity>
implements TaProcessBizRelationService {
    private static final Logger log = LoggerFactory.getLogger(TaProcessBizRelationServiceImpl.class);

    @Override
    public TaProcessBizRelationRespVo getRelationByProcessKey(String processKey) {
        if (processKey == null || StringUtils.isEmpty((String)processKey)) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        List entityList = this.list((Wrapper)Wrappers.lambdaQuery(TaProcessBizRelationEntity.class).eq(TaProcessBizRelationEntity::getProcessKey, (Object)processKey));
        List menuList = entityList.stream().filter(data -> TaProcessBizRelationEnum.BizRelationEnum.MENU.getVal().equals(data.getRelationType())).collect(Collectors.toList());
        List menuVoList = CrmBeanUtil.copyList(menuList, RelationVo.class);
        List orgList = entityList.stream().filter(data -> TaProcessBizRelationEnum.BizRelationEnum.ORG.getVal().equals(data.getRelationType())).collect(Collectors.toList());
        List orgVoList = CrmBeanUtil.copyList(orgList, RelationVo.class);
        TaProcessBizRelationRespVo respVo = new TaProcessBizRelationRespVo();
        respVo.setProcessKey(((TaProcessBizRelationEntity)((Object)entityList.get(1))).getProcessKey());
        respVo.setMenuList(menuVoList);
        respVo.setOrgList(orgVoList);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void insertRelation(TaProcessBizRelationReqVo taProcessBizRelationReqVo) {
        this.checkVo(taProcessBizRelationReqVo);
        this.remove((Wrapper)Wrappers.lambdaQuery(TaProcessBizRelationEntity.class).eq(TaProcessBizRelationEntity::getProcessKey, (Object)taProcessBizRelationReqVo.getProcessKey()));
        List<RelationVo> menuList = taProcessBizRelationReqVo.getMenuList();
        List<RelationVo> orgList = taProcessBizRelationReqVo.getOrgList();
        this.saveBatch(this.getEntityList(menuList, orgList, taProcessBizRelationReqVo));
    }

    private void checkVo(TaProcessBizRelationReqVo taProcessBizRelationReqVo) {
        if (taProcessBizRelationReqVo == null) {
            throw new BusinessException("\u53c2\u6570\u9519\u8bef");
        }
        String processKey = taProcessBizRelationReqVo.getProcessKey();
        List<RelationVo> menuList = taProcessBizRelationReqVo.getMenuList();
        List<RelationVo> orgList = taProcessBizRelationReqVo.getOrgList();
        if (processKey == null || StringUtils.isEmpty((String)processKey)) {
            throw new BusinessException("\u6d41\u7a0bkey\u4e3a\u7a7a");
        }
        if (menuList == null || menuList.size() == 0) {
            throw new BusinessException("\u83dc\u5355\u4e3a\u7a7a");
        }
        if (orgList == null || orgList.size() == 0) {
            throw new BusinessException("\u7ec4\u7ec7\u4e3a\u7a7a");
        }
        if (!this.checkRepeat(menuList)) {
            throw new BusinessException("\u83dc\u5355\u91cd\u590d");
        }
        if (!this.checkRepeat(orgList)) {
            throw new BusinessException("\u7ec4\u7ec7\u91cd\u590d");
        }
    }

    private List<TaProcessBizRelationEntity> getEntityList(List<RelationVo> menuList, List<RelationVo> orgList, TaProcessBizRelationReqVo taProcessBizRelationReqVo) {
        List entityMenuList = CrmBeanUtil.copyList(menuList, TaProcessBizRelationEntity.class);
        entityMenuList.stream().forEach(data -> data.setRelationType(TaProcessBizRelationEnum.BizRelationEnum.MENU.getVal()).setProcessKey(taProcessBizRelationReqVo.getProcessKey()));
        List entityOrgList = CrmBeanUtil.copyList(orgList, TaProcessBizRelationEntity.class);
        entityOrgList.stream().forEach(data -> data.setRelationType(TaProcessBizRelationEnum.BizRelationEnum.ORG.getVal()).setProcessKey(taProcessBizRelationReqVo.getProcessKey()));
        entityMenuList.addAll(entityOrgList);
        return entityMenuList;
    }

    private boolean checkRepeat(List<RelationVo> list) {
        List collect = list.stream().distinct().collect(Collectors.toList());
        return collect.size() == list.size();
    }
}

