/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TaActBaseProcessMapper;
import com.biz.crm.act.model.TaActBaseProcessEntity;
import com.biz.crm.act.model.TaProcessOptRecordEntity;
import com.biz.crm.act.service.ITaActBaseProcessService;
import com.biz.crm.act.service.impl.TaProcessOptRecordServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.nebular.activiti.act.req.StartProcessFormEngReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActBaseProcessReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActBaseProcessRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionDetailRespVo;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taActBaseProcessService")
public class TaActBaseProcessServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TaActBaseProcessMapper, TaActBaseProcessEntity>
implements ITaActBaseProcessService {
    private static final Logger log = LoggerFactory.getLogger(TaActBaseProcessServiceImpl.class);
    @Resource
    private TaActBaseProcessMapper taActBaseProcessMapper;
    @Autowired
    private TaProcessOptRecordServiceImpl taProcessOptRecordService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;

    @Override
    public PageResult<TaActBaseProcessRespVo> findList(TaActBaseProcessReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TaActBaseProcessRespVo> list = this.taActBaseProcessMapper.findList((Page<TaActBaseProcessRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TaActBaseProcessRespVo query(String id) {
        TaActBaseProcessEntity entity = (TaActBaseProcessEntity)((Object)this.taActBaseProcessMapper.selectById((Serializable)((Object)id)));
        if (ObjectUtils.isNotEmpty((Object)((Object)entity))) {
            return (TaActBaseProcessRespVo)CrmBeanUtil.copy((Object)((Object)entity), TaActBaseProcessRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TaActBaseProcessReqVo reqVo) {
        TaActBaseProcessEntity entity = (TaActBaseProcessEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TaActBaseProcessEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TaActBaseProcessReqVo reqVo) {
        TaActBaseProcessEntity entity = (TaActBaseProcessEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List taActBaseProcessEntities = this.taActBaseProcessMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)taActBaseProcessEntities)) {
            this.taActBaseProcessMapper.deleteBatchIds(ids);
        }
    }

    @Override
    public TaActBaseProcessEntity initActBaseProcess(StartProcessFormEngReqVo paramVO, String actBaseId, String processDefKey, int status, MdmPositionDetailRespVo positionUser) {
        log.info("====>create actBaseProcess object!");
        TaActBaseProcessEntity process = new TaActBaseProcessEntity();
        process.setStatus(status);
        process.setBaseId(actBaseId);
        process.setCreateTime(new Date());
        process.setTitle(paramVO.getTitle());
        process.setProcessKey(processDefKey);
        process.setFormUrl(paramVO.getFormUrl());
        process.setApplierCode(paramVO.getUserCode());
        process.setApplierName(positionUser.getUser().getFullName());
        process.setPositionCode(paramVO.getPosCode());
        process.setPositionName(positionUser.getPositionName());
        process.setCauseType(Indicator.PROCESS_CAUSE_TYPE_COMMON.getCode());
        this.saveOrUpdate((Object)process);
        return process;
    }

    @Override
    public ProcessInstance startProcess(TaActBaseProcessEntity process, String currentUser, Map<String, String> variables) {
        log.info("come in start to process:" + process.getTitle());
        ProcessInstance instance = null;
        if (process != null) {
            process.setStartTime(new Date());
            this.identityService.setAuthenticatedUserId(process.getPositionCode());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("startPosCode", process.getPositionCode());
            map.put("startUserCode", currentUser);
            map.put("optBtn", IndicatorStr.PROCESS_BTN_START.getCode());
            map.put("current_user", process.getApplierCode());
            if (variables != null && variables.size() > 0) {
                map.putAll(variables);
            }
            log.info("start to process:" + process.getTitle());
            instance = this.runtimeService.startProcessInstanceByKey(process.getProcessKey(), process.getId(), map);
            if (instance != null) {
                log.info("==========>get instance success!" + instance.getId());
            }
            TaProcessOptRecordEntity log = this.taProcessOptRecordService.buildOptLogWhenProcessStart(instance, process);
            this.taProcessOptRecordService.save((Object)log);
        }
        return instance;
    }

    @Override
    public void autoNextTask(ProcessInstance instance, TaActBaseProcessEntity process) {
        log.info("==========>begin to next task!");
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(instance.getId())).singleResult();
        if (task != null) {
            log.info("==========>get task!" + task.getId());
            TaProcessOptRecordEntity optRecord = this.taProcessOptRecordService.buildOptLogWhenPassStartTask(task, process);
            this.taProcessOptRecordService.save((Object)optRecord);
            this.taskService.complete(task.getId());
            log.info("==========>to next task,Done!");
        }
    }

    @Override
    public TaActBaseProcessEntity findActBaseByProcessInstId(String procInstId) {
        return this.taActBaseProcessMapper.findActBaseByProcessInstId(procInstId);
    }
}

