/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TaTaskCommunicateMapper;
import com.biz.crm.act.model.TaProcessOptRecordEntity;
import com.biz.crm.act.model.TaTaskCommunicateEntity;
import com.biz.crm.act.service.ITaProcessOptRecordService;
import com.biz.crm.act.service.ITaTaskCommunicateService;
import com.biz.crm.act.service.ITaTaskService;
import com.biz.crm.activiti.entity.ActRuTaskEntity;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.design.mapper.ActRuTaskMapper;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.activiti.act.req.CopyToUserReqVO;
import com.biz.crm.nebular.activiti.act.req.TaskCommunicateReqVO;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionDetailRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import javax.annotation.Resource;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taTaskCommunicateService")
public class TaTaskCommunicateServiceImpl
extends ServiceImpl<TaTaskCommunicateMapper, TaTaskCommunicateEntity>
implements ITaTaskCommunicateService {
    @Resource
    private TaTaskCommunicateMapper taTaskCommunicateMapper;
    @Resource
    private ActRuTaskMapper actRuTaskMapper;
    @Autowired
    private ITaTaskService taTaskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;
    @Autowired
    private ITaProcessOptRecordService taProcessOptRecordService;

    @Override
    @Transactional
    public String communicateTo(TaskCommunicateReqVO reqVO) {
        Task task = this.taTaskService.getTaskById(reqVO.getTaskId());
        AssertUtils.isNotNull((Object)task, (String)"\u672a\u627e\u5230\u5f85\u6c9f\u901a\u7684\u8282\u70b9");
        AssertUtils.isNotEmpty((Collection)reqVO.getUsers(), (String)"\u6c9f\u901a\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a!");
        int num = reqVO.getUsers().size();
        AssertUtils.isTrue((!task.isSuspended() ? 1 : 0) != 0, (String)"\u8282\u70b9\u5df2\u7ecf\u88ab\u6302\u8d77(\u6c9f\u901a)!");
        Timestamp nowTime = new Timestamp(System.currentTimeMillis());
        Result resultSend = this.mdmPositionFeign.getPositionDetail(null, reqVO.getFromUserPosCode());
        MdmPositionDetailRespVo positionUserSend = (MdmPositionDetailRespVo)ApiResultUtil.objResult((Result)resultSend, (boolean)Boolean.TRUE);
        AssertUtils.isTrue((boolean)reqVO.getFromUserCode().equals(positionUserSend.getUser().getUserName()), (String)"\u5f53\u524d\u5c97\u4f4d\u4e0b\u4eba\u5458\u4e0d\u5339\u914d!");
        for (int i = 0; i < num; ++i) {
            CopyToUserReqVO user = (CopyToUserReqVO)reqVO.getUsers().get(i);
            ActRuTaskEntity ruTask = new ActRuTaskEntity();
            ruTask.setId(task.getId() + "_" + (i + 1)).setTaskDefKey("CM:" + task.getTaskDefinitionKey()).setName("\u6c9f\u901a:" + task.getName()).setProcDefId(task.getProcessDefinitionId()).setProcInstId(task.getProcessInstanceId()).setExecutionId(task.getExecutionId()).setAssignee(user.getPosCode()).setRev(1).setPriority(50).setDescription(task.getDescription()).setParentTaskId(task.getId()).setSuspensionState(1).setCreateTime(nowTime);
            TaTaskCommunicateEntity communicate = new TaTaskCommunicateEntity();
            communicate.setContent(reqVO.getContent()).setFromUser(reqVO.getFromUserCode()).setFromUserName(positionUserSend.getUser().getFullName()).setFromPosCode(reqVO.getFromUserPosCode()).setFromPosName(positionUserSend.getPositionName()).setTargetUserCode(user.getUserCode()).setTargetUserName(user.getUserName()).setTargetPosCode(user.getPosCode()).setTargetPosName(user.getPosName()).setProcessInstId(ruTask.getProcInstId()).setTaskId(ruTask.getId()).setTaskDefKey(ruTask.getTaskDefKey()).setSourceTaskId(task.getId()).setTaskName(task.getName()).setCreateTime(nowTime);
            TaProcessOptRecordEntity optRecord = new TaProcessOptRecordEntity();
            optRecord.setProcessInstId(ruTask.getProcInstId()).setTaskId(task.getId()).setTaskDefKey(task.getTaskDefinitionKey()).setTaskName(task.getName()).setUserCode(reqVO.getFromUserCode()).setUserName(positionUserSend.getUser().getFullName()).setPositionCode(positionUserSend.getPositionCode()).setPositionName(positionUserSend.getPositionName()).setProcessVersionKey(task.getProcessDefinitionId()).setOperation(IndicatorStr.PROCESS_BTN_COMMUNICATE.getCode()).setContent(positionUserSend.getUser().getFullName() + "\u53d1\u8d77\u4e86\u6c9f\u901a\u64cd\u4f5c\uff0c\u5bf9\u8c61:" + user.getUserName() + "\u3002\u6c9f\u901a\u5185\u5bb9:").setCreateTime(new Date()).setSourceId(task.getId());
            this.actRuTaskMapper.insertSelective(ruTask);
            this.taTaskCommunicateMapper.insert((Object)communicate);
            this.taProcessOptRecordService.save((Object)optRecord);
        }
        this.runtimeService.suspendProcessInstanceById(task.getProcessInstanceId());
        return "\u64cd\u4f5c\u6210\u529f!";
    }
}

