/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.alibaba.druid.support.json.JSONUtils;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TaActBaseMapper;
import com.biz.crm.act.mapper.TaFormSignTicketMapper;
import com.biz.crm.act.model.TaActBaseEntity;
import com.biz.crm.act.model.TaActBaseProcessEntity;
import com.biz.crm.act.model.TaFormSignTicketEntity;
import com.biz.crm.act.model.TaProcessOptRecordEntity;
import com.biz.crm.act.service.ITaActBaseProcessService;
import com.biz.crm.act.service.ITaActBaseService;
import com.biz.crm.act.service.ITaProcessCostTypeService;
import com.biz.crm.act.service.ITaProcessOptRecordService;
import com.biz.crm.act.service.TaProcessBizRelationService;
import com.biz.crm.act.vo.SubmitActivitiKeyDetail;
import com.biz.crm.act.vo.SubmitActivitiResp;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.design.entity.TaProcessEntity;
import com.biz.crm.design.service.TaProcessService;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.activiti.ActivitiException;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.activiti.act.req.FormSignTicketQueryVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActBaseQueryReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActBaseReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActBaseRespVo;
import com.biz.crm.nebular.activiti.start.req.CancelProcessReqVO;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionDetailRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taActBaseService")
public class TaActBaseServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TaActBaseMapper, TaActBaseEntity>
implements ITaActBaseService {
    private static final Logger log = LoggerFactory.getLogger(TaActBaseServiceImpl.class);
    @Resource
    private TaActBaseMapper taActBaseMapper;
    @Resource
    private TaFormSignTicketMapper taFormSignTicketMapper;
    @Autowired
    ITaProcessCostTypeService taProcessCostTypeService;
    @Autowired
    ITaActBaseProcessService taActBaseProcessService;
    @Autowired
    ITaProcessOptRecordService taProcessOptRecordService;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;
    @Autowired
    private TaProcessService taProcessService;
    @Autowired
    private TaProcessBizRelationService taProcessBizRelationService;

    @Override
    public PageResult<TaActBaseRespVo> findList(TaActBaseReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TaActBaseRespVo> list = this.taActBaseMapper.findList((Page<TaActBaseRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TaActBaseRespVo query(String id) {
        TaActBaseEntity entity = (TaActBaseEntity)((Object)this.taActBaseMapper.selectById((Serializable)((Object)id)));
        if (ObjectUtils.isNotEmpty((Object)((Object)entity))) {
            return (TaActBaseRespVo)CrmBeanUtil.copy((Object)((Object)entity), TaActBaseRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TaActBaseReqVo reqVo) {
        TaActBaseEntity entity = (TaActBaseEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TaActBaseEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TaActBaseReqVo reqVo) {
        TaActBaseEntity entity = (TaActBaseEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (ObjectUtils.isNotEmpty((Object)((Object)entity))) {
            this.updateById(CrmBeanUtil.copy((Object)reqVo, TaActBaseEntity.class));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List taActBaseEntities = this.taActBaseMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)taActBaseEntities)) {
            this.taActBaseMapper.deleteBatchIds(ids);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TaActBaseProcessEntity startProcess(StartProcessReqVo reqVo) {
        TaActBaseProcessEntity process = null;
        ProcessInstance instance = null;
        log.info("========>come in! startProcess:" + reqVo.getFormNo());
        this.checkStartParam(reqVo);
        Result result = this.mdmPositionFeign.getPositionDetail(null, reqVo.getPosCode());
        MdmPositionDetailRespVo positionUser = (MdmPositionDetailRespVo)ApiResultUtil.objResult((Result)result, (boolean)Boolean.TRUE);
        AssertUtils.isTrue((boolean)reqVo.getUserCode().equals(positionUser.getUser().getUserName()), (String)"\u5f53\u524d\u5c97\u4f4d\u4e0b\u4eba\u5458\u4e0d\u5339\u914d!");
        TaProcessEntity taProcess = this.taProcessService.getProcessByKey(reqVo.getProcessKey());
        this.checkProcessDef(taProcess);
        TaFormSignTicketEntity signTicket = this.checkSignTicket(reqVo);
        TaActBaseQueryReqVo actBaseQueryReqVo = new TaActBaseQueryReqVo().setFormKey(reqVo.getFormNo());
        TaActBaseEntity actBase = this.taActBaseMapper.findByFormNo(actBaseQueryReqVo);
        if (actBase == null) {
            actBase = this.createActBase(reqVo);
            process = this.taActBaseProcessService.initActBaseProcess(reqVo, actBase.getId(), taProcess.getProcessKey(), Indicator.ACT_BASE_STATUS_DOING.getCode(), positionUser);
        } else {
            this.taActBaseProcessService.endOldProc(actBase.getId(), "\u7ec8\u6b62\u4ee5\u524d\u7684\u6d41\u7a0b\uff01", Indicator.ACT_BASE_STATUS_CANCEL.getCode());
            actBase.setTitle(reqVo.getTitle());
            this.taActBaseMapper.updateById((Object)actBase);
            process = this.taActBaseProcessService.findByActBaseId(actBase.getId()).get(0);
            if (StringUtils.isNotEmpty((CharSequence)process.getProcessInstanceId())) {
                process = this.taActBaseProcessService.initActBaseProcess(reqVo, actBase.getId(), taProcess.getProcessKey(), Indicator.ACT_BASE_STATUS_DRAFT.getCode(), positionUser);
            } else {
                log.info("========>update actBaseProcess draft!");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getRemark())) {
            process.setRemark(reqVo.getRemark());
        }
        log.info("variable paramMap:" + JSONUtils.toJSONString((Object)reqVo.getVariables()) + "|" + reqVo.getFormNo());
        instance = this.taActBaseProcessService.startProcess(process, reqVo.getUserCode(), this.getFormVariablesForEng(reqVo.getVariables()));
        this.updateProcessByInstanceWhenStart(process, instance, signTicket);
        this.taActBaseProcessService.autoNextTask(instance, process);
        if (StringUtils.isEmpty((CharSequence)process.getProcessNo())) {
            throw new BusinessException("\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25");
        }
        return process;
    }

    @Override
    public String cancelProcess(CancelProcessReqVO reqVO) {
        TaActBaseQueryReqVo actBaseQueryReqVo = new TaActBaseQueryReqVo(reqVO.getFormNo(), reqVO.getCostType(), reqVO.getFormType(), reqVO.getSmallType());
        UserRedis user = UserUtils.getUser();
        TaActBaseEntity actBase = this.taActBaseMapper.findByFormNo(actBaseQueryReqVo);
        TaActBaseProcessEntity process = this.taActBaseProcessService.findByActBaseId(actBase.getId()).get(0);
        if (!(process.getApplierCode().equals(user.getUsername()) || process.getPositionCode().equals(user.getPoscode()) || "admin".equals(user.getUsername()))) {
            throw new BusinessException("\u53ea\u6709\u53d1\u8d77\u4eba\u80fd\u64a4\u9500\u6d41\u7a0b!");
        }
        try {
            List<TaProcessOptRecordEntity> optList;
            if (Indicator.ACT_BASE_STATUS_REJECT.getCode() != process.getStatus().intValue() && (optList = this.taProcessOptRecordService.getOptRecordByProcInstId(process.getProcessInstanceId())) != null && optList.size() > 2) {
                throw new BusinessException("\u6d41\u7a0b\u5df2\u7ecf\u5728\u5ba1\u6279\u4e2d\uff0c\u4e0d\u53ef\u64a4\u9500");
            }
            this.taActBaseProcessService.cancelProcess(process.getProcessInstanceId(), "\u6d41\u7a0b\u64a4\u9500", user);
            this.taActBaseProcessService.updateProcessStatus(Indicator.ACT_BASE_STATUS_CANCEL.getCode(), process.getProcessInstanceId());
            this.taActBaseProcessService.updateProcessTitle(process.getTitle() + "(\u64a4\u9500)", process.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "\u64a4\u9500\u6210\u529f";
    }

    private void checkStartParam(StartProcessReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getSignTicket(), (CrmExceptionType)ActivitiException.ACT_PARAM_SIGN);
        AssertUtils.isNotEmpty((String)reqVo.getTitle(), (CrmExceptionType)ActivitiException.ACT_PARAM_TITLE);
        AssertUtils.isNotEmpty((String)reqVo.getUserCode(), (CrmExceptionType)ActivitiException.ACT_PARAM_USER);
        AssertUtils.isNotEmpty((String)reqVo.getPosCode(), (CrmExceptionType)ActivitiException.ACT_PARAM_POS_CODE);
        AssertUtils.isNotEmpty((String)reqVo.getCallBackFeign(), (CrmExceptionType)ActivitiException.ACT_PARAM_CALL_BACK);
    }

    private void checkProcessDef(TaProcessEntity taProcess) {
        AssertUtils.isNotNull((Object)((Object)taProcess), (CrmExceptionType)ActivitiException.PROCESS_MODEL_NOT_FOUND, (String[])new String[0]);
        AssertUtils.isTrue((Indicator.PROCESS_STATE_DEPLOY.getCode() == taProcess.getProcessState().intValue() ? 1 : 0) != 0, (CrmExceptionType)ActivitiException.PROCESS_STATUS_ERROR, (String[])new String[0]);
    }

    private TaFormSignTicketEntity checkSignTicket(StartProcessReqVo reqVo) {
        FormSignTicketQueryVo queryVo = new FormSignTicketQueryVo(reqVo.getSignTicket(), reqVo.getFormNo());
        List<TaFormSignTicketEntity> signTicketList = this.taFormSignTicketMapper.findBySignTicketFromNo(queryVo);
        TaFormSignTicketEntity signTicket = null;
        if (CollectionUtils.isEmpty(signTicketList)) {
            signTicket = new TaFormSignTicketEntity();
            signTicket.setFormNo(reqVo.getFormNo());
            signTicket.setType(Indicator.TICKET_TYPE_NEW.getCode());
            signTicket.setSignTicket(reqVo.getSignTicket());
            signTicket.setCreateTime(new Date());
            signTicket.setStatus(Indicator.TICKET_STATUS_INIT.getCode());
            this.taFormSignTicketMapper.insert((Object)signTicket);
        } else {
            signTicket = signTicketList.get(0);
            if (Indicator.TICKET_STATUS_ERROR.getCode() == signTicket.getStatus().intValue()) {
                signTicket.setStatus(Indicator.TICKET_STATUS_INIT.getCode());
            } else {
                throw new BusinessException("\u8868\u5355" + reqVo.getFormNo() + "\u5df2\u7ecf\u53d1\u8d77\u8fc7\u6d41\u7a0b\u4e86!\u63a7\u5236\u7801\uff1a" + reqVo.getSignTicket());
            }
        }
        return signTicket;
    }

    public TaActBaseEntity createActBase(StartProcessReqVo paramVO) {
        TaActBaseEntity actBase = new TaActBaseEntity();
        actBase.setTitle(paramVO.getTitle());
        actBase.setFormKey(paramVO.getFormNo());
        actBase.setCreateTime(new Date());
        actBase.setCostType(paramVO.getCostType());
        actBase.setFormType(paramVO.getFormType());
        actBase.setSmallType(paramVO.getSmallType());
        actBase.setStatus(0);
        this.saveOrUpdate((Object)actBase);
        return actBase;
    }

    private Map<String, String> getFormVariablesForEng(Map<String, Object> paramMap) {
        if (paramMap != null && paramMap.size() > 0) {
            HashMap<String, String> formVariables = new HashMap<String, String>();
            for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                formVariables.put("form_" + entry.getKey(), entry.getValue().toString().replace(" ", ""));
            }
            return formVariables;
        }
        return null;
    }

    private void updateProcessByInstanceWhenStart(TaActBaseProcessEntity process, ProcessInstance instance, TaFormSignTicketEntity ticket) {
        if (instance != null) {
            process.setProcessInstanceId(instance.getProcessInstanceId());
            process.setStatus(Indicator.ACT_BASE_STATUS_DOING.getCode());
            process.setProcessVersionKey(instance.getProcessDefinitionId());
            this.taActBaseProcessService.saveOrUpdate((Object)process);
        }
        this.updateTicketStatus(instance.getProcessInstanceId(), ticket, Indicator.TICKET_STATUS_FINISH.getCode());
    }

    private void updateTicketStatus(String procInstId, TaFormSignTicketEntity ticket, Integer status) {
        if (ticket != null) {
            ticket.setProcInstId(procInstId);
            ticket.setStatus(status);
            ticket.setUpdateTime(new Date());
            this.taFormSignTicketMapper.updateById((Object)ticket);
        }
    }

    @Override
    public SubmitActivitiResp getSubmitActiviti(String key) {
        SubmitActivitiResp submitActivitiResp = new SubmitActivitiResp();
        UserRedis userRedis = UserUtils.getUser();
        submitActivitiResp.setCreateDate(DateUtil.formatDate());
        submitActivitiResp.setApplierName(userRedis.getUsername());
        submitActivitiResp.setOrgName(userRedis.getOrgname());
        ArrayList<SubmitActivitiKeyDetail> details = new ArrayList<SubmitActivitiKeyDetail>();
        SubmitActivitiKeyDetail submitActivitiKeyDetail = new SubmitActivitiKeyDetail();
        Object obj = ThreadLocalUtil.getObj((String)"menuCode");
        AssertUtils.isNotNull((Object)obj, (String)"\u672a\u83b7\u53d6\u5230\u83dc\u5355\u7f16\u7801");
        AssertUtils.isNotEmpty((String)userRedis.getOrgcode(), (String)"\u767b\u5f55\u4eba\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        List<TaProcessEntity> listTaProcess = this.taProcessBizRelationService.getListTaProcess(userRedis.getOrgcode(), String.valueOf(obj));
        listTaProcess.stream().forEach(data -> submitActivitiKeyDetail.setProcessKey(data.getProcessKey()).setProcessName(data.getProcessName()));
        details.add(submitActivitiKeyDetail);
        submitActivitiResp.setDetails(details);
        return submitActivitiResp;
    }
}

