/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.alibaba.druid.support.json.JSONUtils;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TaActBaseMapper;
import com.biz.crm.act.mapper.TaActFileMapper;
import com.biz.crm.act.mapper.TaFormSignTicketMapper;
import com.biz.crm.act.model.TaActBaseEntity;
import com.biz.crm.act.model.TaActBaseProcessEntity;
import com.biz.crm.act.model.TaActFileEntity;
import com.biz.crm.act.model.TaFormSignTicketEntity;
import com.biz.crm.act.model.TaProcessOptRecordEntity;
import com.biz.crm.act.service.ITaActBaseProcessService;
import com.biz.crm.act.service.ITaActBaseService;
import com.biz.crm.act.service.ITaProcessCostTypeService;
import com.biz.crm.act.service.ITaProcessOptRecordService;
import com.biz.crm.act.service.ITaTaskService;
import com.biz.crm.act.service.TaProcessBizRelationService;
import com.biz.crm.act.vo.SubmitActivitiKeyDetail;
import com.biz.crm.act.vo.SubmitActivitiResp;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.PageResult;
import com.biz.crm.design.entity.TaProcessEntity;
import com.biz.crm.design.service.TaProcessService;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.activiti.ActivitiException;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.activiti.act.req.FormSignTicketQueryVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActBaseQueryReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActBaseReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActBaseRespVo;
import com.biz.crm.nebular.activiti.design.resp.TaProcessOrgRespVO;
import com.biz.crm.nebular.activiti.start.req.CancelProcessReqVO;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionDetailRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taActBaseService")
public class TaActBaseServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TaActBaseMapper, TaActBaseEntity>
implements ITaActBaseService {
    private static final Logger log = LoggerFactory.getLogger(TaActBaseServiceImpl.class);
    @Resource
    private TaActBaseMapper taActBaseMapper;
    @Resource
    private TaFormSignTicketMapper taFormSignTicketMapper;
    @Autowired
    ITaProcessCostTypeService taProcessCostTypeService;
    @Autowired
    ITaActBaseProcessService taActBaseProcessService;
    @Autowired
    ITaProcessOptRecordService taProcessOptRecordService;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;
    @Autowired
    private TaProcessService taProcessService;
    @Resource
    private TaActFileMapper taActFileMapper;
    @Autowired
    private TaProcessBizRelationService taProcessBizRelationService;
    @Autowired
    private ITaTaskService taTaskService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private MdmOrgFeign mdmOrgFeign;

    @Override
    public PageResult<TaActBaseRespVo> findList(TaActBaseReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TaActBaseRespVo> list = this.taActBaseMapper.findList((Page<TaActBaseRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TaActBaseRespVo query(String id) {
        TaActBaseEntity entity = (TaActBaseEntity)((Object)this.taActBaseMapper.selectById((Serializable)((Object)id)));
        if (ObjectUtils.isNotEmpty((Object)((Object)entity))) {
            return (TaActBaseRespVo)CrmBeanUtil.copy((Object)((Object)entity), TaActBaseRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TaActBaseReqVo reqVo) {
        TaActBaseEntity entity = (TaActBaseEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TaActBaseEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TaActBaseReqVo reqVo) {
        TaActBaseEntity entity = (TaActBaseEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (ObjectUtils.isNotEmpty((Object)((Object)entity))) {
            this.updateById(CrmBeanUtil.copy((Object)reqVo, TaActBaseEntity.class));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List taActBaseEntities = this.taActBaseMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)taActBaseEntities)) {
            this.taActBaseMapper.deleteBatchIds(ids);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public TaActBaseProcessEntity startProcess(StartProcessReqVo reqVo) {
        TaActBaseProcessEntity process = null;
        ProcessInstance instance = null;
        log.info("========>come in! startProcess:" + reqVo.getFormNo());
        this.checkStartParam(reqVo);
        Result result = this.mdmPositionFeign.getPositionDetail(null, reqVo.getPosCode());
        MdmPositionDetailRespVo positionUser = (MdmPositionDetailRespVo)ApiResultUtil.objResult((Result)result, (boolean)Boolean.TRUE);
        AssertUtils.isTrue((boolean)reqVo.getUserCode().equals(positionUser.getUser().getUserName()), (String)"\u5f53\u524d\u5c97\u4f4d\u4e0b\u4eba\u5458\u4e0d\u5339\u914d!");
        TaProcessEntity taProcess = this.taProcessService.getProcessByKey(reqVo.getProcessKey());
        this.checkProcessDef(taProcess);
        TaFormSignTicketEntity signTicket = this.checkSignTicket(reqVo);
        TaActBaseQueryReqVo actBaseQueryReqVo = new TaActBaseQueryReqVo().setFormKey(reqVo.getFormNo());
        TaActBaseEntity actBase = this.taActBaseMapper.findByFormNo(actBaseQueryReqVo);
        if (actBase == null) {
            actBase = this.createActBase(reqVo);
            process = this.taActBaseProcessService.initActBaseProcess(reqVo, actBase.getId(), taProcess.getProcessKey(), Indicator.ACT_BASE_STATUS_DOING.getCode(), positionUser);
        } else {
            this.taActBaseProcessService.endOldProc(actBase.getId(), "\u7ec8\u6b62\u4ee5\u524d\u7684\u6d41\u7a0b\uff01", Indicator.ACT_BASE_STATUS_CANCEL.getCode());
            actBase.setTitle(reqVo.getTitle());
            this.taActBaseMapper.updateById((Object)actBase);
            process = this.taActBaseProcessService.findByActBaseId(actBase.getId()).get(0);
            if (StringUtils.isNotEmpty((CharSequence)process.getProcessInstanceId())) {
                process = this.taActBaseProcessService.initActBaseProcess(reqVo, actBase.getId(), taProcess.getProcessKey(), Indicator.ACT_BASE_STATUS_DRAFT.getCode(), positionUser);
            } else {
                log.info("========>update actBaseProcess draft!");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getRemark())) {
            process.setRemark(reqVo.getRemark());
        }
        log.info("variable paramMap:" + JSONUtils.toJSONString((Object)reqVo.getVariables()) + "|" + reqVo.getFormNo());
        Map<String, String> paramMap = this.getFormVariablesForEng(reqVo.getVariables());
        paramMap = this.setBtnWhenRestart(paramMap, reqVo.getOptBtn());
        instance = this.taActBaseProcessService.startProcess(process, reqVo.getUserCode(), paramMap);
        this.updateProcessByInstanceWhenStart(process, instance, signTicket);
        this.taActBaseProcessService.autoNextTask(instance, process);
        String processInstanceId = instance.getProcessInstanceId();
        if (CollectionUtil.collectionNotEmpty((Collection)reqVo.getFileList())) {
            reqVo.getFileList().forEach(file -> {
                TaActFileEntity entity = (TaActFileEntity)CrmBeanUtil.copy((Object)file, TaActFileEntity.class);
                entity.setFileType(Indicator.ACTIVITI_FILE_START.getCode());
                entity.setProcessInstId(processInstanceId);
                this.taActFileMapper.insert(entity);
            });
        }
        if (StringUtils.isEmpty((CharSequence)process.getProcessNo())) {
            throw new BusinessException("\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25");
        }
        return process;
    }

    @Override
    public String cancelProcess(CancelProcessReqVO reqVO) {
        TaActBaseQueryReqVo actBaseQueryReqVo = new TaActBaseQueryReqVo(reqVO.getFormNo(), reqVO.getCostType(), reqVO.getFormType(), reqVO.getSmallType());
        UserRedis user = UserUtils.getUser();
        TaActBaseEntity actBase = this.taActBaseMapper.findByFormNo(actBaseQueryReqVo);
        TaActBaseProcessEntity process = this.taActBaseProcessService.findByActBaseId(actBase.getId()).get(0);
        try {
            List<TaProcessOptRecordEntity> optList;
            if (Indicator.ACT_BASE_STATUS_REJECT.getCode() != process.getStatus().intValue() && (optList = this.taProcessOptRecordService.getOptRecordByProcInstIdFilterStart(process.getProcessInstanceId())) != null && optList.size() > 0) {
                throw new BusinessException("\u6d41\u7a0b\u5df2\u7ecf\u5ba1\u6279\u8fc7\uff0c\u4e0d\u53ef\u64a4\u9500");
            }
            this.taActBaseProcessService.cancelProcess(process.getProcessInstanceId(), "\u6d41\u7a0b\u64a4\u9500", user);
            this.taActBaseProcessService.updateProcessStatus(Indicator.ACT_BASE_STATUS_CANCEL.getCode(), process.getProcessInstanceId());
            this.taActBaseProcessService.updateProcessTitle(process.getTitle() + "(\u64a4\u9500)", process.getId());
            List<TaFormSignTicketEntity> taFormSignTicketEntities = this.taFormSignTicketMapper.findBySignTicketFromNo(new FormSignTicketQueryVo().setFormNo(actBase.getFormKey()));
            TaFormSignTicketEntity taFormSignTicketEntity = taFormSignTicketEntities.get(0);
            this.taFormSignTicketMapper.deleteById((Serializable)((Object)taFormSignTicketEntity.getId()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u64a4\u9500\u5931\u8d25\uff01\u9519\u8bef\u539f\u56e0\uff1a" + e.getMessage());
        }
        return "\u64a4\u9500\u6210\u529f";
    }

    @Override
    public String retrieveProcess(CancelProcessReqVO reqVO) {
        HistoricTaskInstance currTask = this.taTaskService.getHisTaskById(reqVO.getTaskId());
        AssertUtils.isNotNull((Object)currTask, (String)(reqVO.getTaskId() + "\u5bf9\u5e94\u7684\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728"));
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).singleResult();
        AssertUtils.isNotNull((Object)instance, (String)"\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f\uff0c\u65e0\u6cd5\u53d6\u56de");
        Map variables = instance.getProcessVariables();
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(currTask.getProcessDefinitionId());
        AssertUtils.isNotNull((Object)definition, (String)"\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230");
        ActivityImpl currActivity = definition.findActivity(currTask.getTaskDefinitionKey());
        List nextTransitionList = currActivity.getOutgoingTransitions();
        for (PvmTransition nextTransition : nextTransitionList) {
            PvmActivity nextActivity = nextTransition.getDestination();
            List completeTasks = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(instance.getId())).taskDefinitionKey(nextActivity.getId())).finished().list();
            int finished = completeTasks.size();
            AssertUtils.isTrue((finished < 1 ? 1 : 0) != 0, (String)"\u5b58\u5728\u5df2\u7ecf\u5b8c\u6210\u7684\u4e0b\u4e00\u6b65\uff0c\u6d41\u7a0b\u4e0d\u80fd\u53d6\u56de");
            List nextTasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(instance.getId())).taskDefinitionKey(nextActivity.getId())).list();
            for (Task nextTask : nextTasks) {
                List pvmTransitionList = nextActivity.getOutgoingTransitions();
                ArrayList oriPvmTransitionList = new ArrayList(pvmTransitionList);
                pvmTransitionList.clear();
                ActivityImpl nextActivityImpl = definition.findActivity(nextTask.getTaskDefinitionKey());
                TransitionImpl newTransition = nextActivityImpl.createOutgoingTransition();
                newTransition.setDestination(currActivity);
                this.taskService.complete(nextTask.getId(), variables);
                this.historyService.deleteHistoricTaskInstance(nextTask.getId());
                currActivity.getIncomingTransitions().remove(newTransition);
                List pvmTList = nextActivity.getOutgoingTransitions();
                pvmTList.clear();
                pvmTransitionList.addAll(oriPvmTransitionList);
            }
        }
        this.historyService.deleteHistoricTaskInstance(currTask.getId());
        this.taActBaseProcessService.updateProcessStatus(Indicator.ACT_BASE_STATUS_DOING.getCode(), currTask.getProcessInstanceId());
        this.taProcessOptRecordService.updateProcessStatus(Indicator.RECORD_STATUS_RETRIEVE.getCode(), reqVO.getTaskId());
        return "\u53d6\u56de\u6210\u529f\uff01";
    }

    private void checkStartParam(StartProcessReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getSignTicket(), (CrmExceptionType)ActivitiException.ACT_PARAM_SIGN);
        AssertUtils.isNotEmpty((String)reqVo.getTitle(), (CrmExceptionType)ActivitiException.ACT_PARAM_TITLE);
        AssertUtils.isNotEmpty((String)reqVo.getUserCode(), (CrmExceptionType)ActivitiException.ACT_PARAM_USER);
        AssertUtils.isNotEmpty((String)reqVo.getPosCode(), (CrmExceptionType)ActivitiException.ACT_PARAM_POS_CODE);
        AssertUtils.isNotEmpty((String)reqVo.getCallBackFeign(), (CrmExceptionType)ActivitiException.ACT_PARAM_CALL_BACK);
    }

    private void checkProcessDef(TaProcessEntity taProcess) {
        AssertUtils.isNotNull((Object)((Object)taProcess), (CrmExceptionType)ActivitiException.PROCESS_MODEL_NOT_FOUND, (String[])new String[0]);
        AssertUtils.isTrue((Indicator.PROCESS_STATE_DEPLOY.getCode() == taProcess.getProcessState().intValue() ? 1 : 0) != 0, (CrmExceptionType)ActivitiException.PROCESS_STATUS_ERROR, (String[])new String[0]);
    }

    private TaFormSignTicketEntity checkSignTicket(StartProcessReqVo reqVo) {
        FormSignTicketQueryVo queryVo = new FormSignTicketQueryVo(reqVo.getSignTicket(), reqVo.getFormNo());
        List<TaFormSignTicketEntity> signTicketList = this.taFormSignTicketMapper.findBySignTicketFromNo(queryVo);
        TaFormSignTicketEntity signTicket = null;
        if (CollectionUtils.isEmpty(signTicketList)) {
            signTicket = new TaFormSignTicketEntity();
            signTicket.setFormNo(reqVo.getFormNo());
            signTicket.setType(Indicator.TICKET_TYPE_NEW.getCode());
            signTicket.setSignTicket(reqVo.getSignTicket());
            signTicket.setCreateTime(new Date());
            signTicket.setStatus(Indicator.TICKET_STATUS_INIT.getCode());
            this.taFormSignTicketMapper.insert((Object)signTicket);
        } else {
            signTicket = signTicketList.get(0);
            if (Indicator.TICKET_STATUS_ERROR.getCode() == signTicket.getStatus().intValue()) {
                signTicket.setStatus(Indicator.TICKET_STATUS_INIT.getCode());
            } else {
                throw new BusinessException("\u8868\u5355" + reqVo.getFormNo() + "\u5df2\u7ecf\u53d1\u8d77\u8fc7\u6d41\u7a0b\u4e86!\u63a7\u5236\u7801\uff1a" + reqVo.getSignTicket());
            }
        }
        return signTicket;
    }

    public TaActBaseEntity createActBase(StartProcessReqVo paramVO) {
        TaActBaseEntity actBase = new TaActBaseEntity();
        actBase.setTitle(paramVO.getTitle());
        actBase.setFormKey(paramVO.getFormNo());
        actBase.setCreateTime(new Date());
        actBase.setCostType(paramVO.getCostType());
        actBase.setFormType(paramVO.getFormType());
        actBase.setSmallType(paramVO.getSmallType());
        actBase.setBusinessCode(paramVO.getBusinessCode());
        actBase.setStatus(0);
        this.saveOrUpdate((Object)actBase);
        return actBase;
    }

    private Map<String, String> getFormVariablesForEng(Map<String, Object> paramMap) {
        if (paramMap != null && paramMap.size() > 0) {
            HashMap<String, String> formVariables = new HashMap<String, String>();
            for (Map.Entry<String, Object> entry : paramMap.entrySet()) {
                formVariables.put("form_" + entry.getKey(), entry.getValue().toString().replace(" ", ""));
            }
            return formVariables;
        }
        return null;
    }

    private Map<String, String> setBtnWhenRestart(Map<String, String> paramMap, String optBtn) {
        if (IndicatorStr.PROCESS_BTN_SUBMIT.getCode().equals(optBtn)) {
            if (paramMap == null) {
                paramMap = new HashMap<String, String>();
            }
            paramMap.put("optBtn", optBtn);
        }
        return paramMap;
    }

    private void updateProcessByInstanceWhenStart(TaActBaseProcessEntity process, ProcessInstance instance, TaFormSignTicketEntity ticket) {
        if (instance != null) {
            process.setProcessInstanceId(instance.getProcessInstanceId());
            process.setStatus(Indicator.ACT_BASE_STATUS_DOING.getCode());
            process.setProcessVersionKey(instance.getProcessDefinitionId());
            this.taActBaseProcessService.saveOrUpdate((Object)process);
        }
        this.updateTicketStatus(instance.getProcessInstanceId(), ticket, Indicator.TICKET_STATUS_FINISH.getCode());
    }

    private void updateTicketStatus(String procInstId, TaFormSignTicketEntity ticket, Integer status) {
        if (ticket != null) {
            ticket.setProcInstId(procInstId);
            ticket.setStatus(status);
            ticket.setUpdateTime(new Date());
            this.taFormSignTicketMapper.updateById((Object)ticket);
        }
    }

    @Override
    public SubmitActivitiResp getSubmitActiviti(String key) {
        SubmitActivitiResp submitActivitiResp = new SubmitActivitiResp();
        UserRedis userRedis = UserUtils.getUser();
        submitActivitiResp.setCreateDate(DateUtil.formatDate());
        submitActivitiResp.setApplierName(userRedis.getUsername());
        submitActivitiResp.setOrgName(userRedis.getOrgname());
        ArrayList<SubmitActivitiKeyDetail> details = new ArrayList();
        Object obj = ThreadLocalUtil.getObj((String)"menuCode");
        AssertUtils.isNotNull((Object)obj, (String)"\u672a\u83b7\u53d6\u5230\u83dc\u5355\u7f16\u7801");
        AssertUtils.isNotEmpty((String)userRedis.getOrgcode(), (String)"\u767b\u5f55\u4eba\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        List<Object> parentOrgs = Lists.newArrayList();
        Result orgs = this.mdmOrgFeign.findAllParentOrgList(new MdmOrgReqVo().setOrgCode(userRedis.getOrgcode()));
        if (orgs.isSuccess() && CollectionUtil.collectionNotEmpty((Collection)((Collection)orgs.getResult()))) {
            parentOrgs = ((List)orgs.getResult()).stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
        }
        List<TaProcessOrgRespVO> listTaProcess = this.taProcessBizRelationService.getListTaProcessByParentOrgs(parentOrgs, String.valueOf(obj), userRedis.getOrgcode());
        details = Optional.ofNullable(listTaProcess).orElse(Lists.newArrayList()).stream().map(data -> {
            SubmitActivitiKeyDetail submitActivitiKeyDetail = new SubmitActivitiKeyDetail();
            submitActivitiKeyDetail.setProcessKey(data.getProcessKey()).setProcessName(data.getProcessName());
            return submitActivitiKeyDetail;
        }).collect(Collectors.toList());
        submitActivitiResp.setDetails(details);
        return submitActivitiResp;
    }
}

