/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.design.controller;

import com.biz.crm.common.RestServiceController;
import com.biz.crm.common.Result;
import com.biz.crm.common.ToWeb;
import com.biz.crm.design.service.ProcessInfoService;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"models"})
public class ModelerController
implements RestServiceController<Model, String> {
    @Resource
    RepositoryService repositoryService;
    @Autowired
    ObjectMapper objectMapper;
    @Autowired
    private ProcessInfoService processInfoService;

    @PostMapping(value={"newModel"})
    public Object newModel() throws UnsupportedEncodingException {
        Model model = this.repositoryService.newModel();
        String name = "new-process";
        String description = "";
        int revision = 1;
        String key = "process";
        ObjectNode modelNode = this.objectMapper.createObjectNode();
        modelNode.put("name", name);
        modelNode.put("description", description);
        modelNode.put("revision", revision);
        model.setName(name);
        model.setKey(key);
        model.setMetaInfo(modelNode.toString());
        this.repositoryService.saveModel(model);
        String id = model.getId();
        ObjectNode editorNode = this.objectMapper.createObjectNode();
        editorNode.put("id", "canvas");
        editorNode.put("resourceId", "canvas");
        ObjectNode stencilSetNode = this.objectMapper.createObjectNode();
        stencilSetNode.put("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
        editorNode.put("stencilset", (JsonNode)stencilSetNode);
        this.repositoryService.addModelEditorSource(id, editorNode.toString().getBytes("utf-8"));
        return ToWeb.buildResult().redirectUrl("/activiti/editor?modelId=" + id);
    }

    @PostMapping(value={"{id}/deployment"})
    public Object deploy(@PathVariable(value="id") String id) throws Exception {
        Model modelData = this.repositoryService.getModel(id);
        byte[] bytes = this.repositoryService.getModelEditorSource(modelData.getId());
        if (bytes == null) {
            return ToWeb.buildResult().status("001").msg("\u6a21\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u8ba1\u6d41\u7a0b\u5e76\u6210\u529f\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u53d1\u5e03\u3002");
        }
        JsonNode modelNode = new ObjectMapper().readTree(bytes);
        BpmnModel model = new BpmnJsonConverter().convertToBpmnModel(modelNode);
        if (model.getProcesses().size() == 0) {
            return ToWeb.buildResult().status("001").msg("\u6570\u636e\u6a21\u578b\u4e0d\u7b26\u8981\u6c42\uff0c\u8bf7\u81f3\u5c11\u8bbe\u8ba1\u4e00\u6761\u4e3b\u7ebf\u6d41\u7a0b\u3002");
        }
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(model);
        String processName = modelData.getName() + ".bpmn20.xml";
        Deployment deployment = this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, "UTF-8")).deploy();
        modelData.setDeploymentId(deployment.getId());
        this.repositoryService.saveModel(modelData);
        return ToWeb.buildResult().refresh();
    }

    @GetMapping(value={"models"})
    public Result<List<Map<String, Object>>> list() {
        List<Map<String, Object>> list = this.processInfoService.models();
        return new Result<List<Map<String, Object>>>(list);
    }

    @Override
    public Object getOne(@PathVariable(value="id") String id) {
        Model model = (Model)this.repositoryService.createModelQuery().modelId(id).singleResult();
        return ToWeb.buildResult().setObjData(model);
    }

    @Override
    public Object getList(@RequestParam(value="rowSize", defaultValue="1000", required=false) Integer rowSize, @RequestParam(value="page", defaultValue="1", required=false) Integer page) {
        List list = this.repositoryService.createModelQuery().listPage(rowSize * (page - 1), rowSize.intValue());
        long count = this.repositoryService.createModelQuery().count();
        return ToWeb.buildResult().setRows(ToWeb.Rows.buildRows().setCurrent(page).setTotalPages((int)(count / (long)rowSize.intValue() + 1L)).setTotalRows(count).setList(list).setRowSize(rowSize));
    }

    @Override
    public Object deleteOne(@PathVariable(value="id") String id) {
        this.repositoryService.deleteModel(id);
        return ToWeb.buildResult().refresh();
    }

    @Override
    public Object postOne(@RequestBody Model entity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object putOne(@PathVariable(value="id") String s, @RequestBody Model entity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object patchOne(@PathVariable(value="id") String s, @RequestBody Model entity) {
        throw new UnsupportedOperationException();
    }
}

