/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.biz.crm.act.mapper.TaActFileMapper;
import com.biz.crm.act.model.TaActBaseEntity;
import com.biz.crm.act.model.TaActBaseProcessEntity;
import com.biz.crm.act.model.TaActFileEntity;
import com.biz.crm.act.model.TaProcessOptRecordEntity;
import com.biz.crm.act.service.ITaActBaseProcessService;
import com.biz.crm.act.service.ITaActBaseService;
import com.biz.crm.act.service.ITaProcessOptRecordService;
import com.biz.crm.act.service.ITaTaskService;
import com.biz.crm.act.service.TaskFlowControlService;
import com.biz.crm.activiti.mapper.ActivitiMyTaskMapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.design.entity.TaNodeConfigEntity;
import com.biz.crm.design.service.ITaNodeConfigService;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.activiti.ActivitiException;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaskOptReqVO;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="taTaskService")
public class TaTaskServiceImpl
implements ITaTaskService {
    private static final Logger log = LoggerFactory.getLogger(TaTaskServiceImpl.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ITaProcessOptRecordService taProcessOptRecordService;
    @Autowired
    private ITaActBaseService taActBaseService;
    @Autowired
    private ITaActBaseProcessService taActBaseProcessService;
    @Autowired
    private TaskFlowControlService taskFlowControlService;
    @Resource
    private TaActFileMapper taActFileMapper;
    @Resource
    private ITaNodeConfigService taNodeConfigService;
    @Resource
    private ITaTaskService taTaskService;
    @Resource
    private ActivitiMyTaskMapper activitiMyTaskMapper;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;

    @Override
    public Task getTaskById(String taskId) {
        return (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
    }

    @Override
    public HistoricTaskInstance getHisTaskById(String taskId) {
        return (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
    }

    @Override
    public TaskInfo getTaskInfoByTaskId(String taskId) {
        Task task = this.getTaskById(taskId);
        if (task == null) {
            return this.getHisTaskById(taskId);
        }
        return task;
    }

    @Override
    public Task getTaskInfoByInstId(String instId) {
        List result = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(instId)).orderByTaskCreateTime()).desc()).list();
        if (CollectionUtil.listNotEmpty((List)result)) {
            return (Task)result.get(0);
        }
        return null;
    }

    @Override
    public List<HistoricTaskInstance> getHisTaskInstId(String instId) {
        return ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(instId)).orderByHistoricTaskInstanceEndTime().desc()).list();
    }

    @Override
    public String saveComplete(TaskOptReqVO reqVO) {
        Task task = this.getTaskById(reqVO.getTaskId());
        AssertUtils.isNotNull((Object)task, (String)(reqVO.getTaskId() + "\u5bf9\u5e94\u7684task\u4e0d\u5b58\u5728\uff01"));
        String proInstId = task.getProcessInstanceId();
        AssertUtils.isNotNull((Object)task, (CrmExceptionType)ActivitiException.ACT_TASK_NOT_FOUND, (String[])new String[0]);
        AssertUtils.isTrue((!task.isSuspended() ? 1 : 0) != 0, (CrmExceptionType)ActivitiException.TASK_IS_SUSPENSION, (String[])new String[0]);
        if (StringUtils.isEmpty((CharSequence)reqVO.getPositionCode())) {
            reqVO.setPositionCode(UserUtils.getUser().getPoscode());
        }
        Result mdmPositionUserOrgRespVo = this.mdmPositionFeign.getPositionUserOrgByPositionCode(reqVO.getPositionCode());
        AssertUtils.isTrue((boolean)mdmPositionUserOrgRespVo.isSuccess(), (String)"\u5ba1\u6279\u4eba\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u6838\u5bf9");
        Map<String, Object> map = this.initOptMap(reqVO.getOptBtnCode(), (MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult());
        TaProcessOptRecordEntity log = this.taProcessOptRecordService.buildOptLogByTaskOpt((MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult(), reqVO.getOptBtnCode(), (TaskInfo)task, reqVO.getRemark());
        this.taskService.complete(task.getId(), map);
        this.taProcessOptRecordService.save((Object)log);
        if (this.isLastTask(proInstId)) {
            try {
                this.taActBaseProcessService.updateProcessStatus(Indicator.ACT_BASE_STATUS_FINISH.getCode(), proInstId, new Date());
                this.saveCompleteFiles(reqVO, proInstId);
            }
            catch (Exception e) {
                return "\u64cd\u4f5c\u6210\u529f\u4f46\u66f4\u65b0\u6d41\u7a0b\u72b6\u6001\u5931\u8d25\uff01" + e.getMessage();
            }
        } else {
            this.checkAutoComplete(log);
        }
        return "\u64cd\u4f5c\u6210\u529f";
    }

    private void saveCompleteFiles(TaskOptReqVO reqVO, String proInstId) {
        if (CollectionUtil.collectionNotEmpty((Collection)reqVO.getFileList())) {
            reqVO.getFileList().forEach(file -> {
                TaActFileEntity entity = (TaActFileEntity)CrmBeanUtil.copy((Object)file, TaActFileEntity.class);
                entity.setFileType(Indicator.ACTIVITI_FILE_APPROVE.getCode());
                entity.setProcessInstId(proInstId);
                entity.setTaskId(reqVO.getTaskId());
                this.taActFileMapper.insert(entity);
            });
        }
    }

    private void checkAutoComplete(TaProcessOptRecordEntity log) {
        List<OptRecordRspVO> taskRspVos;
        TaNodeConfigEntity nodeConfig;
        Task taskInfo = this.taTaskService.getTaskInfoByInstId(log.getProcessInstId());
        if (ObjectUtils.isNotEmpty((Object)taskInfo) && (nodeConfig = this.taNodeConfigService.findNodeByTaskVersionKey(log.getProcessVersionKey(), taskInfo.getTaskDefinitionKey())).getAuditRepeatSkip().intValue() == Indicator.REPEAT_SKIP_TRUE.getCode() && CollectionUtils.isNotEmpty(taskRspVos = this.activitiMyTaskMapper.getOptRecordByUserCode(new OptRecordReqVO().setPositionCode(taskInfo.getAssignee()).setProcessInstanceId(log.getProcessInstId()))) && taskRspVos.size() > 0) {
            this.saveComplete(new TaskOptReqVO().setTaskId(taskInfo.getId()).setOptBtnCode(IndicatorStr.PROCESS_BTN_APPROVAL.getCode()).setPositionCode(taskInfo.getAssignee()).setRemark("\u81ea\u52a8\u8df3\u8fc7"));
        }
    }

    @Override
    public String taskReject(TaskOptReqVO reqVO) {
        Task task = this.getTaskById(reqVO.getTaskId());
        AssertUtils.isNotNull((Object)task, (CrmExceptionType)ActivitiException.ACT_TASK_NOT_FOUND, (String[])new String[0]);
        AssertUtils.isTrue((!task.isSuspended() ? 1 : 0) != 0, (CrmExceptionType)ActivitiException.TASK_IS_SUSPENSION, (String[])new String[0]);
        TaActBaseProcessEntity baseProcess = this.taActBaseProcessService.findActBaseByProcessInstId(task.getProcessInstanceId());
        Result mdmPositionUserOrgRespVo = this.mdmPositionFeign.getPositionUserOrgByPositionCode(UserUtils.getUser().getPoscode());
        AssertUtils.isTrue((boolean)mdmPositionUserOrgRespVo.isSuccess(), (String)"\u5ba1\u6279\u4eba\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u6838\u5bf9");
        Map<String, Object> map = this.initOptMap(IndicatorStr.PROCESS_BTN_REJECT_FIRST.getCode(), (MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult());
        TaProcessOptRecordEntity log = this.taProcessOptRecordService.buildOptLogByTaskOpt((MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult(), reqVO.getOptBtnCode(), (TaskInfo)task, reqVO.getRemark());
        try {
            this.taskFlowControlService.jump(reqVO.getTaskId(), "DEFAULT_START", map);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u9a73\u56de\u5931\u8d25:" + e.getMessage());
        }
        baseProcess.setStatus(Indicator.ACT_BASE_STATUS_REJECT.getCode());
        this.taActBaseProcessService.updateById((Object)baseProcess);
        this.taProcessOptRecordService.save((Object)log);
        return "\u9a73\u56de\u6210\u529f";
    }

    @Override
    public String taskRejectEnd(TaskOptReqVO reqVO) {
        Task task = this.getTaskById(reqVO.getTaskId());
        AssertUtils.isNotNull((Object)task, (CrmExceptionType)ActivitiException.ACT_TASK_NOT_FOUND, (String[])new String[0]);
        AssertUtils.isTrue((!task.isSuspended() ? 1 : 0) != 0, (CrmExceptionType)ActivitiException.TASK_IS_SUSPENSION, (String[])new String[0]);
        TaActBaseProcessEntity baseProcess = this.taActBaseProcessService.findActBaseByProcessInstId(task.getProcessInstanceId());
        Result mdmPositionUserOrgRespVo = this.mdmPositionFeign.getPositionUserOrgByPositionCode(UserUtils.getUser().getPoscode());
        AssertUtils.isTrue((boolean)mdmPositionUserOrgRespVo.isSuccess(), (String)"\u5ba1\u6279\u4eba\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u6838\u5bf9");
        Map<String, Object> map = this.initOptMap(IndicatorStr.PROCESS_BTN_REJECT_FIRST.getCode(), (MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult());
        TaProcessOptRecordEntity log = this.taProcessOptRecordService.buildOptLogByTaskOpt((MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult(), reqVO.getOptBtnCode(), (TaskInfo)task, reqVO.getRemark());
        try {
            this.taActBaseProcessService.cancelProcess(task.getProcessInstanceId(), "\u9a73\u56de\u5e76\u7ed3\u675f", UserUtils.getUser());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u9a73\u56de\u5931\u8d25\u5e76\u7ed3\u675f\u5931\u8d25:" + e.getMessage());
        }
        baseProcess.setStatus(Indicator.ACT_BASE_STATUS_END.getCode());
        this.taActBaseProcessService.updateById((Object)baseProcess);
        this.taProcessOptRecordService.save((Object)log);
        return "\u9a73\u56de\u5e76\u7ed3\u675f\u6210\u529f";
    }

    @Override
    public String reStartProcess(TaskOptReqVO reqVO) {
        UserRedis user = UserUtils.getUser();
        TaskInfo taskInfo = this.getTaskInfoByTaskId(reqVO.getTaskId());
        TaActBaseProcessEntity baseProcess = this.taActBaseProcessService.findActBaseByProcessInstId(taskInfo.getProcessInstanceId());
        AssertUtils.isTrue((baseProcess.getStatus().intValue() == Indicator.ACT_BASE_STATUS_REJECT.getCode() ? 1 : 0) != 0, (String)"\u975e\u9a73\u56de\u72b6\u6001\u7684\u6d41\u7a0b\u4e0d\u80fd\u518d\u91cd\u65b0\u63d0\u4ea4!");
        TaActBaseEntity actBase = (TaActBaseEntity)((Object)this.taActBaseService.getById((Serializable)((Object)baseProcess.getBaseId())));
        StartProcessReqVo startReqVo = new StartProcessReqVo();
        startReqVo.setFormNo(actBase.getFormKey());
        startReqVo.setFormUrl(baseProcess.getFormUrl());
        startReqVo.setPosCode(user.getPoscode());
        startReqVo.setUserCode(user.getUsername());
        startReqVo.setTitle(baseProcess.getTitle());
        if (StringUtils.isNotEmpty((CharSequence)reqVO.getRemark())) {
            startReqVo.setRemark(reqVO.getRemark());
        } else {
            startReqVo.setRemark(baseProcess.getRemark());
        }
        startReqVo.setSignTicket("restart:" + new Date().getTime());
        startReqVo.setVariables(this.copyFormParam(taskInfo));
        startReqVo.setOptBtn(reqVO.getOptBtnCode());
        this.taActBaseService.startProcess(startReqVo);
        return "\u91cd\u65b0\u53d1\u8d77\u6210\u529f";
    }

    private Map<String, Object> copyFormParam(TaskInfo task) {
        Map oldMap = task.getProcessVariables();
        HashMap newMap = null;
        for (Map.Entry entry : oldMap.entrySet()) {
            if (!((String)entry.getKey()).contains("form_")) continue;
            if (newMap == null) {
                newMap = new HashMap();
            }
            newMap.put(((String)entry.getKey()).replace("form_", ""), entry.getValue());
        }
        return newMap;
    }

    @Override
    public Map<String, Object> initOptMap(String otpBtn, MdmPositionUserOrgRespVo user) {
        HashMap map = Maps.newHashMap();
        map.put("optBtn", otpBtn);
        map.put("current_user", user.getFullName());
        return map;
    }

    @Override
    public boolean isLastTask(String processInstanceId) {
        log.info("=====>isLastTask start");
        List list = this.historyService.createHistoricActivityInstanceQuery().finished().processInstanceId(processInstanceId).activityId("end").list();
        log.info("=====>isLastTask list size:" + list.size());
        return CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0;
    }
}

