/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.listener.base;

import com.biz.crm.base.BusinessException;
import com.biz.crm.listener.base.FlowListenerFactory;
import com.biz.crm.listener.exception.ActivitiRuntimeException;
import com.biz.crm.listener.service.ITaListenerService;
import com.biz.crm.listener.vo.TaListenerQueryVO;
import com.biz.crm.util.ApplicationContextUtils;
import com.biz.crm.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class AbstractDefTaskListener
implements TaskListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractDefTaskListener.class);
    private static final long serialVersionUID = 332954756707734456L;
    private String eventCode;
    private ApplicationContext applicationContext;
    private ITaListenerService taListenerService;
    private FlowListenerFactory flowListenerFactory;

    public void notify(DelegateTask delegateTask) {
        this.applicationContext = ApplicationContextUtils.getContext();
        this.taListenerService = (ITaListenerService)this.applicationContext.getBean("taListenerService");
        this.flowListenerFactory = (FlowListenerFactory)this.applicationContext.getBean("flowListenerFactory");
        TaListenerQueryVO query = this.getTaListenerQueryVO(delegateTask);
        List<TaListenerQueryVO> list = this.taListenerService.findExtListenerList(query);
        for (TaListenerQueryVO listener : list) {
            String packageName = listener.getListenerValue();
            Object obj = this.flowListenerFactory.getListener(packageName);
            if (obj == null) continue;
            try {
                delegateTask = this.flowListenerFactory.notifyTask(obj, delegateTask);
            }
            catch (Exception e) {
                e.printStackTrace();
                Throwable cause = e.getCause();
                String msg = e.getMessage();
                if (cause == null) {
                    if (e instanceof InvocationTargetException) {
                        InvocationTargetException ex = (InvocationTargetException)e;
                        msg = ex.getTargetException().getMessage();
                    }
                    cause = e;
                } else if (cause instanceof ActivitiRuntimeException) {
                    if (msg == null || msg == "") {
                        msg = cause.getMessage();
                    }
                } else if (cause instanceof NullPointerException) {
                    if (msg == null || msg == "") {
                        msg = "java.lang.NullPointerException";
                    }
                } else if (cause instanceof RuntimeException && (msg == null || msg == "")) {
                    msg = cause.getMessage();
                }
                msg = StringUtils.isNotEmpty((String)msg) && msg.contains("Exception while invoking TaskListener") ? msg.substring(msg.lastIndexOf("TaskListener:") + 13) : msg + ":" + cause.getStackTrace()[0].getClassName() + "." + cause.getStackTrace()[0].getMethodName() + ",\u884c:" + cause.getStackTrace()[0].getLineNumber();
                throw new BusinessException(msg);
            }
        }
    }

    private TaListenerQueryVO getTaListenerQueryVO(DelegateTask delegateTask) {
        String proDefId = delegateTask.getProcessDefinitionId();
        String processKey = proDefId.substring(0, proDefId.indexOf(":"));
        TaListenerQueryVO query = new TaListenerQueryVO();
        query.setNodeCode(delegateTask.getTaskDefinitionKey());
        query.setListenerEvent(this.eventCode);
        query.setProcessKey(processKey);
        query.setListenerState(Integer.valueOf("1"));
        query.setProcessVersionKey(delegateTask.getProcessDefinitionId());
        return query;
    }

    public String getEventCode() {
        return this.eventCode;
    }

    public void setEventCode(String eventCode) {
        this.eventCode = eventCode;
    }
}

