/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.listener.process;

import com.alibaba.fastjson.JSON;
import com.biz.crm.act.model.TaActBaseEntity;
import com.biz.crm.act.model.TaActBaseProcessEntity;
import com.biz.crm.act.model.TaProcessOptRecordEntity;
import com.biz.crm.act.model.TaTaskCopyEntity;
import com.biz.crm.act.service.ITaProcessCopyService;
import com.biz.crm.act.service.ITaProcessOptRecordService;
import com.biz.crm.act.service.ITaTaskCopyService;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.listener.base.BaseListener;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.task.resp.CopyProcessRspVO;
import com.biz.crm.util.Result;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessEndListener
extends BaseListener {
    private static final Logger log = LoggerFactory.getLogger(ProcessEndListener.class);
    private ITaProcessCopyService processCopyService;
    private ITaTaskCopyService taTaskCopyService;
    private ITaProcessOptRecordService taProcessOptRecordService;
    private TaskService taskService;

    public DelegateExecution toNotify(DelegateExecution execution) {
        this.initTaActBaseProcessService();
        this.initTaActBaseService();
        TaActBaseProcessEntity baseProcess = this.taActBaseProcessService.findActBaseByProcessInstId(execution.getProcessInstanceId());
        TaActBaseEntity actBaseEntity = (TaActBaseEntity)((Object)this.taActBaseService.getById((Serializable)((Object)baseProcess.getBaseId())));
        ActivitiCallBackVo callBackVo = new ActivitiCallBackVo();
        callBackVo.setFormNo(actBaseEntity.getFormKey());
        callBackVo.setProcessNo(baseProcess.getProcessNo());
        String optBtn = (String)execution.getVariable("optBtn");
        boolean cancelFlag = false;
        if (IndicatorStr.PROCESS_BTN_CANCEL.getCode().equals(optBtn) || baseProcess.getStatus().intValue() == Indicator.ACT_BASE_STATUS_CANCEL.getCode()) {
            callBackVo.setProcessState(Integer.valueOf(5));
            cancelFlag = true;
        } else if (IndicatorStr.PROCESS_BTN_END.getCode().equals(optBtn) || IndicatorStr.PROCESS_BTN_KILL.getCode().equals(optBtn)) {
            callBackVo.setProcessState(Integer.valueOf(4));
        } else {
            callBackVo.setProcessState(Integer.valueOf(2));
        }
        if (baseProcess.getStatus().intValue() == Indicator.ACT_BASE_STATUS_DOING.getCode() || baseProcess.getStatus().intValue() == Indicator.ACT_BASE_STATUS_SAVE.getCode() || baseProcess.getStatus().intValue() == Indicator.ACT_BASE_STATUS_CANCEL.getCode()) {
            this.initCallBackExecutionFeign(execution);
            Result result = this.callbackFeign.callback(callBackVo);
            log.info("\u8c03\u7528\u4e1a\u52a1\u7cfb\u7edfcallBack params={},return={}", (Object)JSON.toJSONString((Object)callBackVo), (Object)JSON.toJSONString((Object)result));
            if (!result.isSuccess()) {
                throw new RuntimeException(result.getMessage());
            }
        }
        if (!cancelFlag) {
            this.doCopyTaskByProcess(baseProcess.getProcessKey(), execution.getProcessInstanceId());
        }
        log.info("\u6267\u884c\u7ed3\u675f\u76d1\u542c,\u6d41\u7a0b\u72b6\u6001:" + baseProcess.getStatus());
        return execution;
    }

    private void doCopyTaskByProcess(final String processKey, final String processInstId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                    ProcessEndListener.this.processCopyService = (ITaProcessCopyService)ProcessEndListener.this.applicationContext.getBean("taProcessCopyService");
                    List<CopyProcessRspVO> processCopyEntities = ProcessEndListener.this.processCopyService.findAllByProcessKey(processKey);
                    if (CollectionUtils.isNotEmpty(processCopyEntities)) {
                        ProcessEndListener.this.taTaskCopyService = (ITaTaskCopyService)ProcessEndListener.this.applicationContext.getBean("taTaskCopyService");
                        ProcessEndListener.this.taskService = (TaskService)ProcessEndListener.this.applicationContext.getBean("taskService");
                        ProcessEndListener.this.taProcessOptRecordService = (ITaProcessOptRecordService)ProcessEndListener.this.applicationContext.getBean("taProcessOptRecordService");
                        processCopyEntities.forEach(vo -> {
                            TaskInfo startTask = (TaskInfo)((TaskQuery)ProcessEndListener.this.taskService.createTaskQuery().taskDefinitionKey("DEFAULT_START")).list().get(0);
                            if (startTask != null) {
                                TaTaskCopyEntity taskCopy = new TaTaskCopyEntity();
                                taskCopy.setTaskId(startTask.getId()).setProcessInstId(processInstId).setTaskDefKey("CP:" + startTask.getTaskDefinitionKey()).setTaskName(startTask.getName()).setUserCode(vo.getUserCode()).setUserName(vo.getUserName()).setPosCode(vo.getPosCode()).setPosName(vo.getPosName()).setFromUser("system_auto").setFromUserName("\u7cfb\u7edf\u81ea\u52a8\u6284\u9001").setFromPosCode("system_auto").setFromPosName("\u7cfb\u7edf\u81ea\u52a8\u6284\u9001").setStatus(Indicator.COPY_TASK_STATUS_UNREAD.getCode());
                                ProcessEndListener.this.taTaskCopyService.save((Object)taskCopy);
                                TaProcessOptRecordEntity optRecord = new TaProcessOptRecordEntity();
                                optRecord.setProcessInstId(taskCopy.getProcessInstId()).setTaskId(taskCopy.getId()).setTaskDefKey(taskCopy.getTaskDefKey()).setTaskName("\u7cfb\u7edf\u81ea\u52a8\u6284\u9001").setUserCode(vo.getUserCode()).setUserName(vo.getUserName()).setPositionCode(vo.getPosCode()).setPositionName(vo.getUserName()).setProcessVersionKey(startTask.getProcessDefinitionId()).setOperation(IndicatorStr.PROCESS_BTN_COPY.getCode()).setContent("\u7cfb\u7edf\u81ea\u52a8\u6284\u9001\u7ed9:" + vo.getUserName()).setCreateTime(new Date()).setSourceId(taskCopy.getId());
                                ProcessEndListener.this.taProcessOptRecordService.save((Object)optRecord);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        }).start();
    }
}

