/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TaProcessOptRecordMapper;
import com.biz.crm.act.model.TaActBaseProcessEntity;
import com.biz.crm.act.model.TaProcessOptRecordEntity;
import com.biz.crm.act.service.ITaProcessOptRecordService;
import com.biz.crm.act.service.ITaTaskService;
import com.biz.crm.act.service.TaskFlowControlService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.design.entity.TaNodeConfigEntity;
import com.biz.crm.design.service.ITaNodeConfigService;
import com.biz.crm.eunm.activiti.ColumnStr;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.activiti.ActivitiException;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.activiti.act.req.RejectToHisTaskReqVO;
import com.biz.crm.nebular.activiti.act.resp.RejectHisTaskRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="taProcessOptRecordService")
public class TaProcessOptRecordServiceImpl
extends ServiceImpl<TaProcessOptRecordMapper, TaProcessOptRecordEntity>
implements ITaProcessOptRecordService {
    private static final Logger log = LoggerFactory.getLogger(TaProcessOptRecordServiceImpl.class);
    @Resource
    private TaProcessOptRecordMapper taProcessOptRecordMapper;
    @Autowired
    private ITaTaskService taTaskService;
    @Autowired
    private ITaNodeConfigService taNodeConfigService;
    @Autowired
    private TaskFlowControlService taskFlowControlService;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;

    @Override
    public TaProcessOptRecordEntity buildOptLogWhenProcessStart(ProcessInstance instance, TaActBaseProcessEntity baseProcess) {
        TaProcessOptRecordEntity log = new TaProcessOptRecordEntity();
        log.setCreateTime(new Date());
        log.setTaskId(null);
        log.setUserCode(baseProcess.getApplierCode());
        log.setUserName(baseProcess.getApplierName());
        log.setOperation(IndicatorStr.PROCESS_BTN_START.getCode());
        log.setContent(baseProcess.getRemark());
        log.setTaskDefKey("start_process");
        log.setTaskName("\u53d1\u8d77\u6d41\u7a0b");
        log.setPositionCode(baseProcess.getPositionCode());
        log.setPositionName(baseProcess.getPositionName());
        this.setParamByActBase(log, instance.getProcessInstanceId(), instance.getProcessDefinitionId(), "autoStartProcess");
        return log;
    }

    private void setParamByActBase(TaProcessOptRecordEntity log, String processInstanceId, String processDefinitionId, String autoStartProcess) {
        log.setProcessInstId(processInstanceId);
        log.setProcessVersionKey(processDefinitionId);
        if (StringUtils.isEmpty((String)log.getUserCode())) {
            log.setUserCode(autoStartProcess);
        }
        if (StringUtils.isEmpty((String)log.getUserName())) {
            log.setUserName(autoStartProcess);
        }
        if (StringUtils.isEmpty((String)log.getProcessInstId())) {
            log.setProcessInstId(autoStartProcess);
        }
        if (StringUtils.isEmpty((String)log.getProcessVersionKey())) {
            log.setProcessVersionKey(autoStartProcess);
        }
    }

    @Override
    public TaProcessOptRecordEntity buildOptLogWhenPassStartTask(Task task, TaActBaseProcessEntity baseProcess) {
        TaProcessOptRecordEntity log = new TaProcessOptRecordEntity();
        log.setCreateTime(new Date());
        log.setTaskId(task.getId());
        log.setUserCode(baseProcess.getApplierCode());
        log.setUserName(baseProcess.getApplierName());
        log.setOperation(IndicatorStr.PROCESS_BTN_SUBMIT.getCode());
        log.setContent("\u81ea\u52a8\u5b8c\u6210\u53d1\u8d77\u8282\u70b9");
        log.setTaskDefKey(task.getTaskDefinitionKey());
        log.setTaskName(task.getName());
        log.setPositionCode(baseProcess.getPositionCode());
        log.setPositionName(baseProcess.getPositionName());
        this.setParamByActBase(log, task.getProcessInstanceId(), task.getProcessDefinitionId(), "autoPassStartTask");
        return log;
    }

    @Override
    public TaProcessOptRecordEntity getOptRecordByTaskId(String taskId) {
        return this.taProcessOptRecordMapper.getOptRecordByTaskId(taskId);
    }

    @Override
    public List<TaProcessOptRecordEntity> getOptRecordByProcInstId(String procInstId) {
        return this.taProcessOptRecordMapper.getOptRecordByProcInstId(procInstId);
    }

    @Override
    public List<TaProcessOptRecordEntity> getOptRecordByProcInstIdFilterStart(String procInstId) {
        return this.taProcessOptRecordMapper.getOptRecordByProcInstIdFilterStart(procInstId);
    }

    @Override
    public TaProcessOptRecordEntity buildOptLogByTaskOpt(MdmPositionUserOrgRespVo user, String optBtn, TaskInfo taskInfo, String remark) {
        TaProcessOptRecordEntity log = new TaProcessOptRecordEntity();
        log.setCreateTime(new Date());
        log.setTaskId(taskInfo.getId());
        log.setUserCode(user.getUserName());
        log.setUserName(user.getFullName());
        log.setOperation(optBtn);
        if (StringUtils.isNotEmpty((String)remark)) {
            log.setContent(remark);
        } else {
            log.setContent(ColumnStr.PROCESS_BTN.getLabelByCode(optBtn));
        }
        log.setTaskDefKey(taskInfo.getTaskDefinitionKey());
        log.setTaskName(taskInfo.getName());
        log.setPositionCode(user.getPositionCode());
        log.setPositionName(user.getPositionCode());
        log.setProcessInstId(taskInfo.getProcessInstanceId());
        log.setProcessVersionKey(taskInfo.getProcessDefinitionId());
        return log;
    }

    @Override
    public List<RejectHisTaskRespVo> queryRejectHisTask(String taskId) {
        Task task = this.taTaskService.getTaskById(taskId);
        AssertUtils.isNotNull((Object)task, (CrmExceptionType)ActivitiException.ACT_TASK_NOT_FOUND, (String[])new String[0]);
        List<TaProcessOptRecordEntity> optList = this.taProcessOptRecordMapper.getRejectBackToHis(task.getProcessInstanceId(), task.getTaskDefinitionKey());
        Map<String, TaNodeConfigEntity> nodeConfigMap = this.taNodeConfigService.configListToMap(this.taNodeConfigService.findNodeByProcessVersionKey(task.getProcessDefinitionId()));
        if (CollectionUtils.isNotEmpty(optList)) {
            HashSet taskDefKeySet = new HashSet();
            ArrayList<RejectHisTaskRespVo> hisTaskList = new ArrayList<RejectHisTaskRespVo>();
            optList.forEach(opt -> {
                if (!taskDefKeySet.contains(opt.getTaskDefKey())) {
                    TaNodeConfigEntity config = (TaNodeConfigEntity)nodeConfigMap.get(opt.getTaskDefKey());
                    if (Indicator.CAN_BACK_YES.getCode() == config.getCanBack().intValue()) {
                        RejectHisTaskRespVo vo = new RejectHisTaskRespVo();
                        vo.setTaskDefKey(opt.getTaskDefKey());
                        vo.setTaskName(opt.getTaskName());
                        hisTaskList.add(vo);
                    }
                    taskDefKeySet.add(opt.getTaskDefKey());
                }
            });
            return hisTaskList;
        }
        return null;
    }

    @Override
    public String rejectToHisTask(RejectToHisTaskReqVO reqVO) {
        Task task = this.taTaskService.getTaskById(reqVO.getTaskId());
        AssertUtils.isNotNull((Object)task, (CrmExceptionType)ActivitiException.ACT_TASK_NOT_FOUND, (String[])new String[0]);
        TaNodeConfigEntity config = this.taNodeConfigService.findNodeByTaskVersionKey(task.getProcessDefinitionId(), reqVO.getTaskDefKey());
        AssertUtils.isTrue((config != null && config.getCanBack().intValue() == Indicator.CAN_BACK_YES.getCode() ? 1 : 0) != 0, (String)"\u6ca1\u627e\u5230\u76ee\u6807\u8282\u70b9\u6216\u4e0d\u53ef\u56de\u9000!");
        Result mdmPositionUserOrgRespVo = this.mdmPositionFeign.getPositionUserOrgByPositionCode(UserUtils.getUser().getPoscode());
        AssertUtils.isTrue((boolean)mdmPositionUserOrgRespVo.isSuccess(), (String)"\u5ba1\u6279\u4eba\u7ec4\u7ec7\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u6838\u5b9e");
        TaProcessOptRecordEntity log = this.buildOptLogByTaskOpt((MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult(), IndicatorStr.PROCESS_BTN_REJECT_LAST.getCode(), (TaskInfo)task, reqVO.getRemark());
        try {
            this.taskFlowControlService.jump(reqVO.getTaskId(), reqVO.getTaskDefKey(), this.taTaskService.initOptMap(IndicatorStr.PROCESS_BTN_REJECT_LAST.getCode(), (MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult()));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u56de\u9000\u5931\u8d25" + e.getMessage());
        }
        this.save((Object)log);
        return "\u56de\u9000\u6210\u529f";
    }

    @Override
    public void updateProcessStatus(Integer status, String taskId) {
        this.taProcessOptRecordMapper.updateRecordStatus(status, taskId);
    }
}

