/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TaActBaseProcessMapper;
import com.biz.crm.act.model.TaActBaseProcessEntity;
import com.biz.crm.act.model.TaProcessOptRecordEntity;
import com.biz.crm.act.service.ITaActBaseProcessService;
import com.biz.crm.act.service.ProcessHelper;
import com.biz.crm.act.service.TaskFlowControlService;
import com.biz.crm.act.service.impl.TaProcessOptRecordServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.design.mapper.ActRuTaskMapper;
import com.biz.crm.design.mapper.HistoryMapper;
import com.biz.crm.eunm.activiti.ActivitiCodeRuleEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActBaseProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaActDelegateReqVo;
import com.biz.crm.nebular.activiti.act.resp.TaActBaseProcessRespVo;
import com.biz.crm.nebular.activiti.start.req.ProcessInfoReqVO;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionDetailRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.IdentityService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taActBaseProcessService")
public class TaActBaseProcessServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TaActBaseProcessMapper, TaActBaseProcessEntity>
implements ITaActBaseProcessService {
    private static final Logger log = LoggerFactory.getLogger(TaActBaseProcessServiceImpl.class);
    @Resource
    private TaActBaseProcessMapper taActBaseProcessMapper;
    @Autowired
    private TaProcessOptRecordServiceImpl taProcessOptRecordService;
    @Autowired
    private TaskFlowControlService taskFlowControlService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Resource
    private ActRuTaskMapper actRuTaskMapper;
    @Resource
    private HistoryMapper historyMapper;
    @Autowired
    private ProcessHelper processHelper;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;

    @Override
    public PageResult<TaActBaseProcessRespVo> findList(TaActBaseProcessReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<TaActBaseProcessRespVo> list = this.taActBaseProcessMapper.findList((Page<TaActBaseProcessRespVo>)page, reqVo);
        list.forEach(vo -> {
            Result result;
            MdmPositionDetailRespVo positionUser;
            this.processHelper.convertProcessStatus((TaActBaseProcessRespVo)vo);
            if (StringUtils.isNotEmpty((CharSequence)vo.getCurrentCode()) && ObjectUtils.isNotEmpty((Object)(positionUser = (MdmPositionDetailRespVo)(result = this.mdmPositionFeign.getPositionDetail(null, vo.getCurrentCode())).getResult()))) {
                vo.setCurrentCode(positionUser.getPositionCode());
                vo.setCurrentName(positionUser.getPositionName());
                if (ObjectUtils.isNotEmpty((Object)positionUser.getUser())) {
                    vo.setCurrentCode(positionUser.getUser().getUserCode());
                    vo.setCurrentUserName(positionUser.getUser().getFullName());
                }
            }
            vo.setConsumingTime(DateUtil.getDiffTimeBetween((Date)vo.getStartTime(), (Date)(ObjectUtils.isEmpty((Object)vo.getEndTime()) ? new Date() : vo.getEndTime())));
        });
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TaActBaseProcessRespVo query(String id) {
        TaActBaseProcessEntity entity = (TaActBaseProcessEntity)((Object)this.taActBaseProcessMapper.selectById((Serializable)((Object)id)));
        if (ObjectUtils.isNotEmpty((Object)((Object)entity))) {
            return (TaActBaseProcessRespVo)CrmBeanUtil.copy((Object)((Object)entity), TaActBaseProcessRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(TaActBaseProcessReqVo reqVo) {
        TaActBaseProcessEntity entity = (TaActBaseProcessEntity)((Object)CrmBeanUtil.copy((Object)reqVo, TaActBaseProcessEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(TaActBaseProcessReqVo reqVo) {
        TaActBaseProcessEntity entity = (TaActBaseProcessEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List taActBaseProcessEntities = this.taActBaseProcessMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)taActBaseProcessEntities)) {
            this.taActBaseProcessMapper.deleteBatchIds(ids);
        }
    }

    @Override
    public void updateProcessStatus(Integer status, String procInstId) {
        this.taActBaseProcessMapper.updateProcessStatus(status, procInstId);
    }

    @Override
    public void updateProcessStatus(Integer status, String procInstId, Date finishDate) {
        TaActBaseProcessEntity taActBaseProcessEntity = this.taActBaseProcessMapper.findActBaseByProcessInstId(procInstId);
        if (ObjectUtils.isNotEmpty((Object)((Object)taActBaseProcessEntity))) {
            taActBaseProcessEntity.setStatus(status);
            taActBaseProcessEntity.setEndTime(finishDate);
            this.taActBaseProcessMapper.updateById((Object)taActBaseProcessEntity);
        }
    }

    @Override
    public void updateProcessTitle(String title, String id) {
        this.taActBaseProcessMapper.updateProcessTitle(title, id);
    }

    @Override
    public TaActBaseProcessEntity initActBaseProcess(StartProcessReqVo paramVO, String actBaseId, String processDefKey, int status, MdmPositionDetailRespVo positionUser) {
        log.info("====>create actBaseProcess object!");
        TaActBaseProcessEntity process = new TaActBaseProcessEntity();
        process.setStatus(status);
        process.setBaseId(actBaseId);
        process.setCreateTime(new Date());
        process.setTitle(paramVO.getTitle());
        process.setProcessKey(processDefKey);
        process.setFormUrl(paramVO.getFormUrl());
        process.setApplierCode(paramVO.getUserCode());
        process.setApplierName(positionUser.getUser().getFullName());
        process.setPositionCode(paramVO.getPosCode());
        process.setPositionName(positionUser.getPositionName());
        process.setCallBackFeign(paramVO.getCallBackFeign());
        process.setCauseType(Indicator.PROCESS_CAUSE_TYPE_COMMON.getCode());
        process.setAvailableStatus(Indicator.AVAILABLE_STATUS_START.getCode());
        process.setProcessNo(CodeUtil.generateCode((String)ActivitiCodeRuleEnum.ACTIVITI_PROCESS_NO.getCode()));
        this.saveOrUpdate((Object)process);
        return process;
    }

    @Override
    public ProcessInstance startProcess(TaActBaseProcessEntity process, String currentUser, Map<String, String> variables) {
        log.info("come in start to process:" + process.getTitle());
        ProcessInstance instance = null;
        if (process != null) {
            process.setStartTime(new Date());
            this.identityService.setAuthenticatedUserId(process.getPositionCode());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("startPosCode", process.getPositionCode());
            map.put("startUserCode", currentUser);
            map.put("optBtn", IndicatorStr.PROCESS_BTN_START.getCode());
            map.put("current_user", process.getApplierCode());
            if (variables != null && variables.size() > 0) {
                map.putAll(variables);
            }
            log.info("start to process:" + process.getTitle());
            instance = this.runtimeService.startProcessInstanceByKey(process.getProcessKey(), process.getId(), map);
            if (instance != null) {
                log.info("==========>get instance success!" + instance.getId());
            }
            TaProcessOptRecordEntity log = this.taProcessOptRecordService.buildOptLogWhenProcessStart(instance, process);
            this.taProcessOptRecordService.save((Object)log);
        }
        return instance;
    }

    @Override
    public void autoNextTask(String instanceId, TaActBaseProcessEntity process) {
        log.info("==========>begin to next task!");
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(instanceId)).singleResult();
        if (task != null) {
            log.info("==========>get task!" + task.getId());
            TaProcessOptRecordEntity optRecord = this.taProcessOptRecordService.buildOptLogWhenPassStartTask(task, process);
            this.taProcessOptRecordService.save((Object)optRecord);
            this.taskService.complete(task.getId());
            log.info("==========>to next task,Done!");
        }
    }

    @Override
    public TaActBaseProcessEntity findActBaseByProcessInstId(String procInstId) {
        return this.taActBaseProcessMapper.findActBaseByProcessInstId(procInstId);
    }

    @Override
    public TaActBaseProcessEntity findActBaseByProcessNo(String processNo) {
        return this.taActBaseProcessMapper.findActBaseByProcessNo(processNo);
    }

    @Override
    public List<TaActBaseProcessEntity> findActBase(ProcessInfoReqVO vo) {
        return this.taActBaseProcessMapper.findActBase(vo);
    }

    @Override
    public void endOldProc(String baseId, String desc, Integer status) {
        List<TaActBaseProcessEntity> procList = this.taActBaseProcessMapper.findByActBaseId(baseId);
        for (TaActBaseProcessEntity haveProc : procList) {
            List taskList;
            List tasks;
            if (!StringUtils.isNotEmpty((CharSequence)haveProc.getProcessInstanceId())) continue;
            if (!(haveProc.getStatus().intValue() != Indicator.ACT_BASE_STATUS_DOING.getCode() && haveProc.getStatus().intValue() != Indicator.ACT_BASE_STATUS_SAVE.getCode() || !CollectionUtils.isNotEmpty((Collection)(tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(haveProc.getProcessInstanceId())).list())) || tasks.size() <= 1 && ((Task)tasks.get(0)).getTaskDefinitionKey().equals("DEFAULT_START"))) {
                log.info("this formNo is exist!");
                throw new BusinessException("\u6b64\u5355\u53f7\u5df2\u7ecf\u6709\u6b63\u5728\u5ba1\u6279\u4e2d\u7684\u6d41\u7a0b!");
            }
            if ((haveProc.getStatus().intValue() == Indicator.ACT_BASE_STATUS_REJECT.getCode() || haveProc.getStatus().intValue() == Indicator.ACT_BASE_STATUS_CANCEL.getCode()) && CollectionUtils.isNotEmpty((Collection)(taskList = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(haveProc.getProcessInstanceId())).taskDefinitionKey("DEFAULT_START")).list()))) {
                Task task = (Task)taskList.get(0);
                if (task != null && task.getTaskDefinitionKey().equals("DEFAULT_START")) {
                    this.endProcess(haveProc.getProcessInstanceId(), desc);
                    this.taActBaseProcessMapper.updateProcessStatus(status, haveProc.getProcessInstanceId());
                    this.taActBaseProcessMapper.updateProcessTitle(haveProc.getTitle() + "(\u9a73\u56de)", haveProc.getId());
                } else if (task != null) {
                    log.info("this formNo is exist!");
                    throw new RuntimeException("\u6b64\u5355\u53f7\u5df2\u7ecf\u6709\u6b63\u5728\u5ba1\u6279\u4e2d\u7684\u6d41\u7a0b\u4e86!");
                }
            }
            if (haveProc.getStatus().intValue() != Indicator.ACT_BASE_STATUS_CANCEL.getCode() || status.intValue() != Indicator.ACT_BASE_STATUS_RESTART.getCode()) continue;
            this.taActBaseProcessMapper.updateProcessStatus(status, haveProc.getProcessInstanceId());
            this.taActBaseProcessMapper.updateProcessTitle(haveProc.getTitle() + "(\u64a4\u9500)", haveProc.getId());
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(haveProc.getProcessInstanceId())).singleResult();
            if (task == null || !task.getTaskDefinitionKey().equals("DEFAULT_START")) continue;
            this.endProcess(haveProc.getProcessInstanceId(), desc);
        }
    }

    @Override
    public List<TaActBaseProcessEntity> findByActBaseId(String baseId) {
        return this.taActBaseProcessMapper.findByActBaseId(baseId);
    }

    @Override
    public void endProcess(String processInstanceId, String desc) {
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)taskList)) {
            HashSet<String> executionSet = new HashSet<String>();
            for (Task task : taskList) {
                if (StringUtils.isNotEmpty((CharSequence)task.getExecutionId()) && !executionSet.contains(task.getExecutionId())) {
                    this.cancelAndSaveLog(desc, task, "autoEnd", "autoEnd", "autoEnd", "autoEnd");
                }
                executionSet.add(task.getExecutionId());
            }
            this.deleteTasksByProcInsId(processInstanceId);
        }
    }

    private void cancelAndSaveLog(String desc, Task task, String userName, String userCode, String posname, String poscode) {
        log.info("====>taskId is" + task.getId());
        log.info("====>save log record");
        TaProcessOptRecordEntity optLog = new TaProcessOptRecordEntity();
        optLog.setCreateTime(new Date());
        optLog.setTaskId(task.getId());
        optLog.setUserName(userName);
        optLog.setUserCode(userCode);
        optLog.setOperation(IndicatorStr.PROCESS_BTN_KILL.getCode());
        optLog.setContent(desc);
        optLog.setTaskDefKey(task.getTaskDefinitionKey());
        optLog.setPositionName(posname);
        optLog.setPositionCode(poscode);
        optLog.setProcessInstId(task.getProcessInstanceId());
        optLog.setProcessVersionKey(task.getProcessDefinitionId());
        log.info("====>to cancel process");
        Map variables = task.getProcessVariables();
        variables.put("startPosCode", poscode);
        variables.put("startUserCode", userCode);
        variables.put("optBtn", IndicatorStr.PROCESS_BTN_CANCEL.getCode());
        this.taskFlowControlService.jump(task.getId(), "end", variables);
        this.taProcessOptRecordService.save((Object)optLog);
    }

    @Override
    public void cancelProcess(String processInstanceId, String desc, UserRedis user) throws Exception {
        List taskList = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)taskList)) {
            HashSet<String> executionSet = new HashSet<String>();
            for (Task task : taskList) {
                if (StringUtils.isNotEmpty((CharSequence)task.getExecutionId()) && !executionSet.contains(task.getExecutionId())) {
                    this.cancelAndSaveLog(desc, task, user.getRealname(), user.getUsername(), user.getPosname(), user.getPoscode());
                }
                executionSet.add(task.getExecutionId());
            }
            this.deleteTasksByProcInsId(processInstanceId);
        }
    }

    @Override
    public void enableBatch(List<String> ids) {
        ids.forEach(id -> {
            TaActBaseProcessEntity respVo = (TaActBaseProcessEntity)((Object)((Object)this.taActBaseProcessMapper.selectById((Serializable)((Object)id))));
            if (ObjectUtils.isNotEmpty((Object)((Object)respVo)) & respVo.getAvailableStatus().intValue() == Indicator.AVAILABLE_STATUS_STOP.getCode()) {
                respVo.setAvailableStatus(Indicator.AVAILABLE_STATUS_START.getCode());
                this.taActBaseProcessMapper.updateById((Object)respVo);
            }
        });
    }

    @Override
    public void closeBatch(TaActBaseProcessReqVo reqVo) {
        AssertUtils.isTrue((!StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{reqVo.getId(), reqVo.getFormNo(), reqVo.getProcessKey()}) ? 1 : 0) != 0, (String)"\u6d41\u7a0b\u5b9e\u4f8bid\u6216\u8868\u5355id\u4e0d\u80fd\u90fd\u4e3a\u7a7a\uff01");
        List<TaActBaseProcessEntity> respVos = this.taActBaseProcessMapper.queryProcessStatus(reqVo);
        if (CollectionUtil.collectionNotEmpty(respVos)) {
            respVos.forEach(vo -> {
                vo.setAvailableStatus(Indicator.AVAILABLE_STATUS_CANCEL.getCode());
                this.taActBaseProcessMapper.updateById(vo);
            });
        }
    }

    @Override
    public void disableBatch(List<String> ids) {
        ids.forEach(id -> {
            TaActBaseProcessEntity respVo = (TaActBaseProcessEntity)((Object)((Object)this.taActBaseProcessMapper.selectById((Serializable)((Object)id))));
            if (ObjectUtils.isNotEmpty((Object)((Object)respVo)) & respVo.getAvailableStatus().intValue() == Indicator.AVAILABLE_STATUS_START.getCode()) {
                respVo.setAvailableStatus(Indicator.AVAILABLE_STATUS_STOP.getCode());
                this.taActBaseProcessMapper.updateById((Object)respVo);
            }
        });
    }

    @Override
    public void delegateProcess(TaActDelegateReqVo reqVo) {
        Result result = this.mdmPositionFeign.getPositionDetail(null, reqVo.getDelegatePositionCode());
        MdmPositionDetailRespVo positionUser = (MdmPositionDetailRespVo)result.getResult();
        AssertUtils.isNotNull((Object)positionUser, (String)("\u5c97\u4f4d\u7f16\u7801\uff1a" + reqVo.getDelegatePositionCode() + "\u4e0d\u5408\u6cd5\uff01"));
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(reqVo.getTaskId())).singleResult();
        AssertUtils.isNotNull((Object)task, (String)(reqVo.getTaskId() + "\u5bf9\u5e94\u7684task\u4e0d\u5b58\u5728\uff01"));
        task.setAssignee(reqVo.getDelegatePositionCode());
        this.taskService.saveTask(task);
    }

    @Override
    public List<TaActBaseProcessRespVo> findByFormNo(String formNo) {
        return this.taActBaseProcessMapper.findByFormNo(formNo);
    }

    @Override
    public List<TaActBaseProcessRespVo> findDoingByFormNo(String formNo) {
        return this.taActBaseProcessMapper.findByFormNo(formNo);
    }

    private void deleteTasksByProcInsId(String procInsId) {
        List allTasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procInsId)).list();
        if (CollectionUtils.isNotEmpty((Collection)allTasks)) {
            for (Task t : allTasks) {
                this.actRuTaskMapper.deleteByPrimaryKey(t.getId());
                if (!StringUtils.isNotEmpty((CharSequence)t.getExecutionId())) continue;
                this.historyMapper.deleteHiActByExecutionId(t.getExecutionId());
            }
        }
    }
}

