/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TaProcessCopyMapper;
import com.biz.crm.act.model.TaProcessCopyEntity;
import com.biz.crm.act.service.ITaProcessCopyService;
import com.biz.crm.design.entity.TaProcessEntity;
import com.biz.crm.design.service.TaProcessService;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.activiti.ActivitiException;
import com.biz.crm.nebular.activiti.act.req.ProcessCopyReqVO;
import com.biz.crm.nebular.activiti.task.resp.CopyProcessRspVO;
import com.biz.crm.util.AssertUtils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="taProcessCopyService")
public class TaProcessCopyServiceImpl
extends ServiceImpl<TaProcessCopyMapper, TaProcessCopyEntity>
implements ITaProcessCopyService {
    private static final Logger log = LoggerFactory.getLogger(TaProcessCopyServiceImpl.class);
    @Resource
    private TaProcessCopyMapper taProcessCopyMapper;
    @Autowired
    private TaProcessService taProcessService;

    @Override
    public String saveProcessCopy(ProcessCopyReqVO reqVO) {
        TaProcessEntity process = this.taProcessService.getProcessByKey(reqVO.getProcessKey());
        AssertUtils.isNotNull((Object)((Object)process), (CrmExceptionType)ActivitiException.PROCESS_MODEL_NOT_FOUND, (String[])new String[0]);
        this.taProcessCopyMapper.deleteByProcessKey(reqVO.getProcessKey());
        if (CollectionUtils.isNotEmpty((Collection)reqVO.getUsers())) {
            reqVO.getUsers().forEach(vo -> {
                TaProcessCopyEntity copy = new TaProcessCopyEntity();
                copy.setPosCode(vo.getPosCode()).setPosName(vo.getPosName()).setUserCode(vo.getUserCode()).setUserName(vo.getUserName()).setProcessKey(reqVO.getProcessKey());
                this.taProcessCopyMapper.insert((Object)copy);
            });
        }
        return "\u64cd\u4f5c\u5b8c\u6210!";
    }

    @Override
    public List<CopyProcessRspVO> findAllByProcessKey(String processKey) {
        return this.taProcessCopyMapper.findAllByProcessKey(processKey);
    }
}

