/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.listener.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.listener.mapper.TaListenerMapper;
import com.biz.crm.listener.mapper.TaListenerProcMapper;
import com.biz.crm.listener.model.TaListenerProcEntity;
import com.biz.crm.listener.service.ITaListenerProcService;
import com.biz.crm.listener.service.impl.ListenerHelper;
import com.biz.crm.listener.vo.TaListenerQueryVO;
import com.biz.crm.nebular.activiti.listener.req.TaListenerProcReqVo;
import com.biz.crm.nebular.activiti.listener.resp.TaListenerProcRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"TaListenerProcServiceExpandImpl"})
public class TaListenerProcServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<TaListenerProcMapper, TaListenerProcEntity>
implements ITaListenerProcService {
    private static final Logger log = LoggerFactory.getLogger(TaListenerProcServiceImpl.class);
    @Resource
    private TaListenerProcMapper taListenerProcMapper;
    @Resource
    private TaListenerMapper taListenerMapper;
    @Autowired
    private ListenerHelper listenerHelper;

    @Override
    public PageResult<TaListenerProcRespVo> findList(TaListenerProcReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<TaListenerProcRespVo> list = this.taListenerProcMapper.findList((Page<TaListenerProcRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public TaListenerProcRespVo query(String id) {
        TaListenerProcEntity entity = (TaListenerProcEntity)this.taListenerProcMapper.selectById((Serializable)((Object)id));
        if (ObjectUtils.isEmpty((Object)entity)) {
            return (TaListenerProcRespVo)CrmBeanUtil.copy((Object)entity, TaListenerProcRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(List<TaListenerProcReqVo> reqVos) {
        reqVos.forEach(reqVo -> {
            this.listenerHelper.procSaveCheck((TaListenerProcReqVo)reqVo);
            TaListenerProcEntity entity = (TaListenerProcEntity)CrmBeanUtil.copy((Object)reqVo, TaListenerProcEntity.class);
            if (StringUtils.isEmpty((String)reqVo.getId())) {
                this.taListenerProcMapper.insert(entity);
            } else {
                this.taListenerProcMapper.updateById(entity);
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(List<TaListenerProcReqVo> reqVos) {
        reqVos.forEach(reqVo -> {
            this.listenerHelper.procSaveCheck((TaListenerProcReqVo)reqVo);
            TaListenerProcEntity entity = (TaListenerProcEntity)this.getById((Serializable)((Object)reqVo.getId()));
            if (ObjectUtils.isNotEmpty((Object)entity)) {
                this.updateById(CrmBeanUtil.copy((Object)reqVo, TaListenerProcEntity.class));
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        ArrayList deleteIds = Lists.newArrayList();
        HashSet procEntityList = Sets.newHashSet();
        ids.forEach(id -> {
            TaListenerProcEntity entity = (TaListenerProcEntity)this.taListenerProcMapper.selectById((Serializable)((Object)id));
            if (ObjectUtils.isNotNull((Object[])new Object[]{entity})) {
                procEntityList.add(entity);
                deleteIds.add(id);
            }
        });
        this.taListenerProcMapper.deleteBatchIds(deleteIds);
        TaListenerQueryVO reqVo = new TaListenerQueryVO();
        procEntityList.forEach(pro -> {
            reqVo.setNodeCode(pro.getNodeCode());
            reqVo.setProcessVersionKey(pro.getProcessVersionKey());
            List<TaListenerQueryVO> listenerQueryVOS = this.queryByNode(reqVo);
            AssertUtils.isTrue((boolean)CollectionUtil.listNotEmptyNotSizeZero(listenerQueryVOS), (String)"\u8282\u70b9\u81f3\u5c11\u9700\u8981\u6302\u8f7d\u4e00\u4e2a\u76d1\u542c\u5668\uff01");
            if (pro.getNodeCode().equals("DEFAULT_START")) {
                List listeners = listenerQueryVOS.stream().map(TaListenerQueryVO::getListenerValue).collect(Collectors.toList());
                AssertUtils.isTrue((boolean)listeners.contains("com.biz.crm.listener.task.DefaultPositionListener"), (String)"\u9ed8\u8ba4\u53d1\u8d77\u8282\u70b9\u5fc5\u987b\u6302\u8f7d\u521d\u59cb\u53d1\u8d77\u76d1\u542c\u5668");
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        List taListenerProcEntities = this.taListenerProcMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)taListenerProcEntities)) {
            taListenerProcEntities.forEach(o -> o.setListenerState(Indicator.COMMON_ENABLE.getCode()));
        }
        this.updateBatchById(taListenerProcEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        List taListenerProcEntities = this.taListenerProcMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)taListenerProcEntities)) {
            taListenerProcEntities.forEach(o -> o.setListenerState(Indicator.COMMON_DISABLE.getCode()));
        }
        this.updateBatchById(taListenerProcEntities);
    }

    @Override
    public List<TaListenerQueryVO> queryByNode(TaListenerQueryVO queryVO) {
        Page page = PageUtil.buildPage((Integer)queryVO.getPageNum(), (Integer)queryVO.getPageSize());
        List<TaListenerQueryVO> taListenerQueryVOS = this.taListenerMapper.queryByNode((Page<TaListenerQueryVO>)page, queryVO);
        taListenerQueryVOS.forEach(taListenerQueryVO -> this.listenerHelper.convertValue((TaListenerQueryVO)((Object)taListenerQueryVO)));
        return taListenerQueryVOS;
    }
}

