/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.controller;

import com.biz.crm.activiti.service.BizRuntimeService;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.activiti.vo.ActivitiBusinessVo;
import com.biz.crm.nebular.activiti.vo.BpmQueryVo;
import com.biz.crm.nebular.activiti.vo.CompleteTaskVo;
import com.biz.crm.nebular.activiti.vo.CurrentTaskVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u6d41\u7a0b\u4e1a\u52a1\u5904\u7406", tags={"\u6d41\u7a0b\u4e1a\u52a1\u5904\u7406"})
@RestController
@RequestMapping(value={"/runtimeController"})
public class RuntimeController {
    private static final Logger log = LoggerFactory.getLogger(RuntimeController.class);
    @Autowired
    private BizRuntimeService bizRuntimeService;

    @CrmLog
    @ApiOperation(value="\u53d1\u8d77\u6d41\u7a0b")
    @PostMapping(value={"startProcess"})
    public Result<String> startProcess(@RequestBody ActivitiBusinessVo activitiBusinessVo) {
        Result result = new Result();
        if (StringUtils.isEmpty((String)activitiBusinessVo.getPositionCode())) {
            UserRedis userRedis = UserUtils.getUser();
            activitiBusinessVo.setPositionCode(userRedis.getPoscode());
        }
        if (StringUtils.isEmpty((String)activitiBusinessVo.getBusinessIdOrNum())) {
            result.error500("\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3010businessIdOrNum\u3011");
            return result;
        }
        String processInstId = this.bizRuntimeService.startProcess(activitiBusinessVo);
        result.setResult((Object)processInstId);
        return result;
    }

    @ApiOperation(value="\u67e5\u8be2\u4ee3\u529e\u4efb\u52a1", notes="\u67e5\u8be2\u4ee3\u529e\u4efb\u52a1")
    @PostMapping(value={"listByPositionCode"})
    public Result<PageResult<CurrentTaskVo>> listByPositionCode(@RequestBody BpmQueryVo bpmQueryVo) {
        return Result.ok(this.bizRuntimeService.listByPositionCode(bpmQueryVo));
    }

    @ApiOperation(value="\u6211\u63d0\u4ea4\u7684\u6d41\u7a0b")
    @PostMapping(value={"listMyBpm"})
    public Result<PageResult<CurrentTaskVo>> listMyBpm(@RequestBody BpmQueryVo bpmQueryVo) {
        return Result.ok(this.bizRuntimeService.listMyBpm(bpmQueryVo));
    }

    @ApiOperation(value="\u6211\u88ab\u9a73\u56de\u7684\u6d41\u7a0b")
    @PostMapping(value={"listMyRejectBpm"})
    public Result<PageResult<CurrentTaskVo>> listMyRejectBpm(@RequestBody BpmQueryVo bpmQueryVo) {
        return Result.ok(this.bizRuntimeService.listMyBpm(bpmQueryVo));
    }

    @ApiOperation(value="\u5ba1\u6279\u6d41\u7a0b")
    @PostMapping(value={"completeTasks"})
    @CrmLog
    public Result completeTasks(@RequestBody CompleteTaskVo completeTaskVo) {
        this.bizRuntimeService.completeTasks(completeTaskVo);
        return Result.ok();
    }
}

