/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.biz.crm.act.mapper.TaActFileMapper;
import com.biz.crm.act.model.TaActBaseEntity;
import com.biz.crm.act.model.TaActBaseProcessEntity;
import com.biz.crm.act.model.TaActFileEntity;
import com.biz.crm.act.model.TaProcessOptRecordEntity;
import com.biz.crm.act.service.ITaActBaseProcessService;
import com.biz.crm.act.service.ITaActBaseService;
import com.biz.crm.act.service.ITaProcessOptRecordService;
import com.biz.crm.act.service.ITaTaskService;
import com.biz.crm.act.service.TaskFlowControlService;
import com.biz.crm.activiti.mapper.ActivitiMyTaskMapper;
import com.biz.crm.base.BusinessException;
import com.biz.crm.design.entity.TaNodeConfigEntity;
import com.biz.crm.design.service.ITaNodeConfigService;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.activiti.ActivitiException;
import com.biz.crm.listener.model.ExecutionEntity;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.activiti.act.req.RushProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.StartProcessReqVo;
import com.biz.crm.nebular.activiti.act.req.TaskOptReqVO;
import com.biz.crm.nebular.activiti.act.resp.TaActBaseProcessRespVo;
import com.biz.crm.nebular.activiti.start.req.OptRecordReqVO;
import com.biz.crm.nebular.activiti.task.resp.OptRecordRspVO;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngines;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taTaskService")
public class TaTaskServiceImpl
implements ITaTaskService {
    private static final Logger log = LoggerFactory.getLogger(TaTaskServiceImpl.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private ITaProcessOptRecordService taProcessOptRecordService;
    @Autowired
    private ITaActBaseService taActBaseService;
    @Autowired
    private ITaActBaseProcessService taActBaseProcessService;
    @Autowired
    private TaskFlowControlService taskFlowControlService;
    @Resource
    private TaActFileMapper taActFileMapper;
    @Resource
    private ITaNodeConfigService taNodeConfigService;
    @Resource
    private ITaTaskService taTaskService;
    @Resource
    private ActivitiMyTaskMapper activitiMyTaskMapper;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;
    @Autowired
    private RuntimeService runtimeService;

    @Override
    public Task getTaskById(String taskId) {
        return (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
    }

    @Override
    public HistoricTaskInstance getHisTaskById(String taskId) {
        return (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
    }

    @Override
    public TaskInfo getTaskInfoByTaskId(String taskId) {
        Task task = this.getTaskById(taskId);
        if (task == null) {
            return this.getHisTaskById(taskId);
        }
        return task;
    }

    @Override
    public Task getTaskInfoByInstId(String instId) {
        List result = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(instId)).orderByTaskCreateTime()).desc()).list();
        if (CollectionUtil.listNotEmpty((List)result)) {
            return (Task)result.get(0);
        }
        return null;
    }

    @Override
    public List<HistoricTaskInstance> getHisTaskInstId(String instId) {
        return ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(instId)).orderByHistoricTaskInstanceEndTime().desc()).list();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveComplete(TaskOptReqVO reqVO) {
        Task task = this.getTaskById(reqVO.getTaskId());
        if (task == null) {
            log.error("\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c\uff0c\u60a8\u53ef\u4ee5\u5237\u65b0\u5217\u8868\u9875\u9762\uff01\uff01", (Object)reqVO);
            throw new BusinessException("\u4efb\u52a1\u5df2\u5904\u7406\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c\uff0c\u60a8\u53ef\u4ee5\u5237\u65b0\u5217\u8868\u9875\u9762\uff01\uff01");
        }
        String proInstId = task.getProcessInstanceId();
        AssertUtils.isNotNull((Object)task, (CrmExceptionType)ActivitiException.ACT_TASK_NOT_FOUND, (String[])new String[0]);
        AssertUtils.isTrue((!task.isSuspended() ? 1 : 0) != 0, (CrmExceptionType)ActivitiException.TASK_IS_SUSPENSION, (String[])new String[0]);
        if (StringUtils.isEmpty((CharSequence)reqVO.getPositionCode())) {
            reqVO.setPositionCode(UserUtils.getUser().getPoscode());
        }
        Result mdmPositionUserOrgRespVo = this.mdmPositionFeign.getPositionUserOrgByPositionCode(reqVO.getPositionCode());
        AssertUtils.isTrue((boolean)mdmPositionUserOrgRespVo.isSuccess(), (String)"\u5ba1\u6279\u4eba\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u6838\u5bf9");
        Map<String, Object> map = this.initOptMap(reqVO.getOptBtnCode(), (MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult());
        TaProcessOptRecordEntity completeLog = this.taProcessOptRecordService.buildOptLogByTaskOpt((MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult(), reqVO.getOptBtnCode(), (TaskInfo)task, reqVO.getRemark());
        if (this.nextTaskIsEnd(reqVO.getTaskId()).booleanValue()) {
            try {
                log.info("\u8be5\u8282\u70b9\u662f\u6700\u540e\u4e00\u4e2a\u8282\u70b9\uff0c\u8d70\u5ba1\u6279\u7ed3\u675f\u6d41\u7a0b");
                this.taActBaseProcessService.updateProcessStatus(Indicator.ACT_BASE_STATUS_FINISH.getCode(), proInstId, new Date());
                this.runtimeService.deleteProcessInstance(proInstId, "\u6d41\u7a0b\u7ed3\u675f");
            }
            catch (Exception e) {
                throw new BusinessException("\u5ba1\u6279\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff01" + e.getMessage());
            }
        } else {
            log.info("\u4e0d\u662f\u6700\u540e\u4e00\u4e2a\u8282\u70b9\uff0c\u8d70\u6b63\u5e38\u5ba1\u6279\u6d41\u7a0b");
            this.taskService.complete(task.getId(), map);
            this.checkAutoComplete(completeLog);
        }
        this.taProcessOptRecordService.save((Object)completeLog);
        this.saveCompleteFiles(reqVO, proInstId);
        return "\u64cd\u4f5c\u6210\u529f";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String rushProcessState(RushProcessReqVo reqVO) {
        List<TaActBaseProcessRespVo> taActBaseProcessEntities = this.taActBaseProcessService.findDoingByFormNo(reqVO.getFormNo());
        if (CollectionUtil.listNotEmptyNotSizeZero(taActBaseProcessEntities)) {
            if (reqVO.getProcessState() == 2) {
                taActBaseProcessEntities.forEach(process -> {
                    Task task = this.taTaskService.getTaskInfoByInstId(process.getProcessInstanceId());
                    if (ObjectUtils.isNull((Object[])new Object[]{task})) {
                        return;
                    }
                    Result mdmPositionUserOrgRespVo = this.mdmPositionFeign.getPositionUserOrgByPositionCode(UserUtils.getUser().getPoscode());
                    Map<String, Object> map = this.initOptMap(IndicatorStr.PROCESS_BTN_APPROVAL.getCode(), (MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult());
                    map.put("rushProcessState", "Y");
                    this.runtimeService.setVariables(task.getExecutionId(), map);
                    TaProcessOptRecordEntity completeLog = this.taProcessOptRecordService.buildOptLogByTaskOpt((MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult(), IndicatorStr.PROCESS_BTN_APPROVAL.getCode(), (TaskInfo)task, null);
                    try {
                        this.taActBaseProcessService.updateProcessStatus(Indicator.ACT_BASE_STATUS_FINISH.getCode(), process.getProcessInstanceId(), new Date());
                        this.runtimeService.deleteProcessInstance(process.getProcessInstanceId(), "\u5237\u65b0\u6d41\u7a0b\u72b6\u6001");
                    }
                    catch (Exception e) {
                        throw new BusinessException("\u5237\u65b0\u6d41\u7a0b\u72b6\u6001\u5230\u5ba1\u6279\u901a\u8fc7\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:" + e.getMessage());
                    }
                    this.taProcessOptRecordService.save((Object)completeLog);
                });
            } else if (reqVO.getProcessState() == 3) {
                taActBaseProcessEntities.forEach(process -> {
                    Task task = this.taTaskService.getTaskInfoByInstId(process.getProcessInstanceId());
                    if (ObjectUtils.isNull((Object[])new Object[]{task})) {
                        return;
                    }
                    Result mdmPositionUserOrgRespVo = this.mdmPositionFeign.getPositionUserOrgByPositionCode(UserUtils.getUser().getPoscode());
                    Map<String, Object> map = this.initOptMap(IndicatorStr.PROCESS_BTN_REJECT_FIRST.getCode(), (MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult());
                    map.put("rushProcessState", "Y");
                    TaProcessOptRecordEntity log = this.taProcessOptRecordService.buildOptLogByTaskOpt((MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult(), IndicatorStr.PROCESS_BTN_REJECT_FIRST.getCode(), (TaskInfo)task, null);
                    try {
                        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).list();
                        tasks.forEach(t -> {
                            if (t.getId().equals(task.getId())) {
                                this.taskFlowControlService.jump(t.getId(), "DEFAULT_START", map);
                            } else {
                                this.taTaskService.removeTask(t.getId());
                            }
                        });
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new BusinessException("\u5237\u65b0\u6d41\u7a0b\u72b6\u6001\u5230\u9a73\u56de\u5931\u8d25:" + e.getMessage());
                    }
                    this.taProcessOptRecordService.save((Object)log);
                    this.taActBaseProcessService.updateProcessStatus(Indicator.ACT_BASE_STATUS_REJECT.getCode(), process.getProcessInstanceId(), null);
                });
            }
        }
        return "\u5237\u65b0\u6d41\u7a0b\u72b6\u6001\u6210\u529f";
    }

    private void saveCompleteFiles(TaskOptReqVO reqVO, String proInstId) {
        if (CollectionUtil.collectionNotEmpty((Collection)reqVO.getFileList())) {
            reqVO.getFileList().forEach(file -> {
                TaActFileEntity entity = (TaActFileEntity)CrmBeanUtil.copy((Object)file, TaActFileEntity.class);
                entity.setFileType(Indicator.ACTIVITI_FILE_APPROVE.getCode());
                entity.setProcessInstId(proInstId);
                entity.setTaskId(reqVO.getTaskId());
                this.taActFileMapper.insert(entity);
            });
        }
    }

    private void checkAutoComplete(TaProcessOptRecordEntity recordLog) {
        List<OptRecordRspVO> taskRspVos;
        TaNodeConfigEntity nodeConfig;
        Task taskInfo = this.taTaskService.getTaskInfoByInstId(recordLog.getProcessInstId());
        if (ObjectUtils.isNotEmpty((Object)taskInfo) && (nodeConfig = this.taNodeConfigService.findNodeByTaskVersionKey(recordLog.getProcessVersionKey(), taskInfo.getTaskDefinitionKey())).getAuditRepeatSkip().intValue() == Indicator.REPEAT_SKIP_TRUE.getCode() && CollectionUtils.isNotEmpty(taskRspVos = this.activitiMyTaskMapper.getOptRecordByUserCode(new OptRecordReqVO().setPositionCode(taskInfo.getAssignee()).setProcessInstanceId(recordLog.getProcessInstId()))) && taskRspVos.size() > 0) {
            this.saveComplete(new TaskOptReqVO().setTaskId(taskInfo.getId()).setOptBtnCode(IndicatorStr.PROCESS_BTN_APPROVAL.getCode()).setPositionCode(taskInfo.getAssignee()).setRemark("\u81ea\u52a8\u8df3\u8fc7"));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String taskReject(TaskOptReqVO reqVO) {
        Task task = this.getTaskById(reqVO.getTaskId());
        AssertUtils.isNotNull((Object)task, (CrmExceptionType)ActivitiException.ACT_TASK_NOT_FOUND, (String[])new String[0]);
        AssertUtils.isTrue((!task.isSuspended() ? 1 : 0) != 0, (CrmExceptionType)ActivitiException.TASK_IS_SUSPENSION, (String[])new String[0]);
        TaActBaseProcessEntity baseProcess = this.taActBaseProcessService.findActBaseByProcessInstId(task.getProcessInstanceId());
        Result mdmPositionUserOrgRespVo = this.mdmPositionFeign.getPositionUserOrgByPositionCode(UserUtils.getUser().getPoscode());
        AssertUtils.isTrue((boolean)mdmPositionUserOrgRespVo.isSuccess(), (String)"\u5ba1\u6279\u4eba\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u6838\u5bf9");
        Map<String, Object> map = this.initOptMap(IndicatorStr.PROCESS_BTN_REJECT_FIRST.getCode(), (MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult());
        TaProcessOptRecordEntity log = this.taProcessOptRecordService.buildOptLogByTaskOpt((MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult(), reqVO.getOptBtnCode(), (TaskInfo)task, reqVO.getRemark());
        try {
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).list();
            tasks.forEach(t -> {
                if (t.getId().equals(reqVO.getTaskId())) {
                    this.taskFlowControlService.jump(t.getId(), "DEFAULT_START", map);
                } else {
                    this.taTaskService.removeTask(t.getId());
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u9a73\u56de\u5931\u8d25:" + e.getMessage());
        }
        baseProcess.setStatus(Indicator.ACT_BASE_STATUS_REJECT.getCode());
        this.taActBaseProcessService.updateById((Object)baseProcess);
        this.taProcessOptRecordService.save((Object)log);
        this.saveCompleteFiles(reqVO, log.getProcessInstId());
        this.taProcessOptRecordService.updateRecordStatusByProcessInstId(Indicator.RECORD_STATUS_REJECT.getCode(), task.getProcessInstanceId());
        if (StringUtils.isNotEmpty((CharSequence)reqVO.getDeleteFiles()) && GlobalWhetherEnum.YES.getCode().equals(reqVO.getDeleteFiles())) {
            this.taActFileMapper.delete((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(TaActFileEntity::getFileType, (Object)Indicator.ACTIVITI_FILE_START.getCode())).eq(TaActFileEntity::getProcessInstId, (Object)task.getProcessInstanceId()));
        }
        return "\u9a73\u56de\u6210\u529f";
    }

    @Override
    public String taskRejectEnd(TaskOptReqVO reqVO) {
        Task task = this.getTaskById(reqVO.getTaskId());
        AssertUtils.isNotNull((Object)task, (CrmExceptionType)ActivitiException.ACT_TASK_NOT_FOUND, (String[])new String[0]);
        AssertUtils.isTrue((!task.isSuspended() ? 1 : 0) != 0, (CrmExceptionType)ActivitiException.TASK_IS_SUSPENSION, (String[])new String[0]);
        TaActBaseProcessEntity baseProcess = this.taActBaseProcessService.findActBaseByProcessInstId(task.getProcessInstanceId());
        Result mdmPositionUserOrgRespVo = this.mdmPositionFeign.getPositionUserOrgByPositionCode(UserUtils.getUser().getPoscode());
        AssertUtils.isTrue((boolean)mdmPositionUserOrgRespVo.isSuccess(), (String)"\u5ba1\u6279\u4eba\u7ec4\u7ec7\u4fe1\u606f\u4e0d\u6b63\u786e\uff0c\u8bf7\u6838\u5bf9");
        Map<String, Object> map = this.initOptMap(IndicatorStr.PROCESS_BTN_REJECT_FIRST.getCode(), (MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult());
        TaProcessOptRecordEntity log = this.taProcessOptRecordService.buildOptLogByTaskOpt((MdmPositionUserOrgRespVo)mdmPositionUserOrgRespVo.getResult(), reqVO.getOptBtnCode(), (TaskInfo)task, reqVO.getRemark());
        try {
            this.taActBaseProcessService.cancelProcess(task.getProcessInstanceId(), "\u9a73\u56de\u5e76\u7ed3\u675f", UserUtils.getUser());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u9a73\u56de\u5931\u8d25\u5e76\u7ed3\u675f\u5931\u8d25:" + e.getMessage());
        }
        baseProcess.setStatus(Indicator.ACT_BASE_STATUS_END.getCode());
        this.taActBaseProcessService.updateById((Object)baseProcess);
        this.taProcessOptRecordService.save((Object)log);
        this.saveCompleteFiles(reqVO, log.getProcessInstId());
        return "\u9a73\u56de\u5e76\u7ed3\u675f\u6210\u529f";
    }

    @Override
    public String reStartProcess(TaskOptReqVO reqVO) {
        UserRedis user = UserUtils.getUser();
        TaskInfo taskInfo = this.getTaskInfoByTaskId(reqVO.getTaskId());
        TaActBaseProcessEntity baseProcess = this.taActBaseProcessService.findActBaseByProcessInstId(taskInfo.getProcessInstanceId());
        AssertUtils.isTrue((baseProcess.getStatus().intValue() == Indicator.ACT_BASE_STATUS_REJECT.getCode() ? 1 : 0) != 0, (String)"\u975e\u9a73\u56de\u72b6\u6001\u7684\u6d41\u7a0b\u4e0d\u80fd\u518d\u91cd\u65b0\u63d0\u4ea4!");
        TaActBaseEntity actBase = (TaActBaseEntity)((Object)this.taActBaseService.getById((Serializable)((Object)baseProcess.getBaseId())));
        StartProcessReqVo startReqVo = new StartProcessReqVo();
        startReqVo.setFormNo(actBase.getFormKey());
        startReqVo.setFormUrl(baseProcess.getFormUrl());
        startReqVo.setPosCode(user.getPoscode());
        startReqVo.setUserCode(user.getUsername());
        startReqVo.setTitle(baseProcess.getTitle());
        if (StringUtils.isNotEmpty((CharSequence)reqVO.getRemark())) {
            startReqVo.setRemark(reqVO.getRemark());
        } else {
            startReqVo.setRemark(baseProcess.getRemark());
        }
        startReqVo.setSignTicket("restart:" + new Date().getTime());
        startReqVo.setVariables(this.copyFormParam(taskInfo));
        startReqVo.setOptBtn(reqVO.getOptBtnCode());
        this.taActBaseService.startProcess(startReqVo);
        return "\u91cd\u65b0\u53d1\u8d77\u6210\u529f";
    }

    private Map<String, Object> copyFormParam(TaskInfo task) {
        Map oldMap = task.getProcessVariables();
        HashMap newMap = null;
        for (Map.Entry entry : oldMap.entrySet()) {
            if (!((String)entry.getKey()).contains("form_")) continue;
            if (newMap == null) {
                newMap = new HashMap();
            }
            newMap.put(((String)entry.getKey()).replace("form_", ""), entry.getValue());
        }
        return newMap;
    }

    @Override
    public Map<String, Object> initOptMap(String otpBtn, MdmPositionUserOrgRespVo user) {
        HashMap map = Maps.newHashMap();
        map.put("optBtn", otpBtn);
        map.put("current_user", user.getFullName());
        return map;
    }

    @Override
    public boolean isLastTask(String processInstanceId) {
        log.info("=====>isLastTask start");
        List list = this.historyService.createHistoricActivityInstanceQuery().finished().processInstanceId(processInstanceId).activityId("end").list();
        log.info("=====>isLastTask list size:" + list.size());
        return CollectionUtils.isNotEmpty((Collection)list) && list.size() > 0;
    }

    public Boolean nextTaskIsEnd(String taskId) {
        Task task = (Task)((TaskQuery)ProcessEngines.getDefaultProcessEngine().getTaskService().createTaskQuery().taskId(taskId)).singleResult();
        String processInstanceId = task.getProcessInstanceId();
        String definitionId = ((ProcessInstance)ProcessEngines.getDefaultProcessEngine().getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult()).getProcessDefinitionId();
        ProcessDefinitionEntity processDefinitionEntity = (ProcessDefinitionEntity)((RepositoryServiceImpl)ProcessEngines.getDefaultProcessEngine().getRepositoryService()).getDeployedProcessDefinition(definitionId);
        ActivityImpl activityImpl = processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        List outTransitions = activityImpl.getOutgoingTransitions();
        for (PvmTransition tr : outTransitions) {
            PvmActivity ac = tr.getDestination();
            if ("endEvent".equals(ac.getProperty("type"))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void removeTask(String taskId) {
        this.activitiMyTaskMapper.removeTask(taskId);
    }

    @Override
    public List<ExecutionEntity> findExecutionByInstId(String processInstId) {
        return this.activitiMyTaskMapper.findByProcessInstId(processInstId);
    }

    @Override
    public void deleteExecutionWhenBusinessKeyNull(String processInstId) {
        this.activitiMyTaskMapper.removeExecutionBusinessKeyNull(processInstId);
    }

    @Override
    public void deleteExecutionById(String id) {
        this.activitiMyTaskMapper.removeExecutionById(id);
    }

    @Override
    public void deleteVariableByExecution(String id) {
        this.activitiMyTaskMapper.deleteVariableByExecutionId(id);
    }
}

