/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.act.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.act.mapper.TaTaskCommunicateMapper;
import com.biz.crm.act.model.TaProcessOptRecordEntity;
import com.biz.crm.act.model.TaTaskCommunicateEntity;
import com.biz.crm.act.service.ITaProcessOptRecordService;
import com.biz.crm.act.service.ITaTaskCommunicateService;
import com.biz.crm.act.service.ITaTaskService;
import com.biz.crm.activiti.entity.ActRuTaskEntity;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.design.mapper.ActRuTaskMapper;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.activiti.ActivitiException;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.activiti.act.req.ConfirmCommunicateReqVO;
import com.biz.crm.nebular.activiti.act.req.CopyToUserReqVO;
import com.biz.crm.nebular.activiti.act.req.TaskCommunicateReqVO;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionDetailRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="taTaskCommunicateService")
public class TaTaskCommunicateServiceImpl
extends ServiceImpl<TaTaskCommunicateMapper, TaTaskCommunicateEntity>
implements ITaTaskCommunicateService {
    @Resource
    private TaTaskCommunicateMapper taTaskCommunicateMapper;
    @Resource
    private ActRuTaskMapper actRuTaskMapper;
    @Autowired
    private ITaTaskService taTaskService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private MdmPositionFeign mdmPositionFeign;
    @Autowired
    private ITaProcessOptRecordService taProcessOptRecordService;

    @Override
    @Transactional
    public String communicateTo(TaskCommunicateReqVO reqVO) {
        Task task = this.taTaskService.getTaskById(reqVO.getTaskId());
        AssertUtils.isNotNull((Object)task, (CrmExceptionType)ActivitiException.ACT_TASK_NOT_FOUND, (String[])new String[0]);
        AssertUtils.isTrue((!task.isSuspended() ? 1 : 0) != 0, (CrmExceptionType)ActivitiException.TASK_IS_SUSPENSION, (String[])new String[0]);
        AssertUtils.isNotEmpty((Collection)reqVO.getUsers(), (String)"\u6c9f\u901a\u76ee\u6807\u4e0d\u80fd\u4e3a\u7a7a!");
        int num = reqVO.getUsers().size();
        Timestamp nowTime = new Timestamp(System.currentTimeMillis());
        Result resultSend = this.mdmPositionFeign.getPositionDetail(null, reqVO.getFromUserPosCode());
        MdmPositionDetailRespVo positionUserSend = (MdmPositionDetailRespVo)ApiResultUtil.objResult((Result)resultSend, (boolean)Boolean.TRUE);
        AssertUtils.isTrue((boolean)reqVO.getFromUserCode().equals(positionUserSend.getUser().getUserName()), (String)"\u5f53\u524d\u5c97\u4f4d\u4e0b\u4eba\u5458\u4e0d\u5339\u914d!");
        for (int i = 0; i < num; ++i) {
            CopyToUserReqVO user = (CopyToUserReqVO)reqVO.getUsers().get(i);
            ActRuTaskEntity ruTask = new ActRuTaskEntity();
            ruTask.setId(task.getId() + "_" + (i + 1)).setTaskDefKey("CM:" + task.getTaskDefinitionKey()).setName("\u6c9f\u901a:" + task.getName()).setProcDefId(task.getProcessDefinitionId()).setProcInstId(task.getProcessInstanceId()).setExecutionId(task.getExecutionId()).setAssignee(user.getPosCode()).setRev(Integer.valueOf(1)).setPriority(Integer.valueOf(50)).setDescription(task.getDescription()).setParentTaskId(task.getId()).setSuspensionState(Integer.valueOf(1)).setCreateTime(nowTime);
            TaTaskCommunicateEntity communicate = new TaTaskCommunicateEntity();
            communicate.setContent(reqVO.getContent()).setFromUser(reqVO.getFromUserCode()).setFromUserName(positionUserSend.getUser().getFullName()).setFromPosCode(reqVO.getFromUserPosCode()).setFromPosName(positionUserSend.getPositionName()).setTargetUserCode(user.getUserCode()).setTargetUserName(user.getUserName()).setTargetPosCode(user.getPosCode()).setTargetPosName(user.getPosName()).setProcessInstId(ruTask.getProcInstId()).setTaskId(ruTask.getId()).setTaskDefKey(ruTask.getTaskDefKey()).setSourceTaskId(task.getId()).setTaskName(task.getName()).setCreateTime(nowTime).setStatus(Indicator.COPY_TASK_STATUS_UNREAD.getCode());
            TaProcessOptRecordEntity optRecord = new TaProcessOptRecordEntity();
            optRecord.setProcessInstId(ruTask.getProcInstId()).setTaskId(task.getId()).setTaskDefKey(task.getTaskDefinitionKey()).setTaskName(task.getName()).setUserCode(reqVO.getFromUserCode()).setUserName(positionUserSend.getUser().getFullName()).setPositionCode(positionUserSend.getPositionCode()).setPositionName(positionUserSend.getPositionName()).setProcessVersionKey(task.getProcessDefinitionId()).setOperation(IndicatorStr.PROCESS_BTN_COMMUNICATE.getCode()).setContent(positionUserSend.getUser().getFullName() + "\u53d1\u8d77\u4e86\u6c9f\u901a\u64cd\u4f5c\uff0c\u5bf9\u8c61:" + user.getUserName() + "\u3002\u6c9f\u901a\u5185\u5bb9:" + reqVO.getContent()).setCreateTime(new Date()).setSourceId(task.getId());
            this.actRuTaskMapper.insertSelective(ruTask);
            this.taTaskCommunicateMapper.insert((Object)communicate);
            this.taProcessOptRecordService.save((Object)optRecord);
        }
        this.runtimeService.suspendProcessInstanceById(task.getProcessInstanceId());
        return "\u64cd\u4f5c\u6210\u529f!";
    }

    @Override
    @Transactional
    public String confirmCommunicate(ConfirmCommunicateReqVO reqVO) {
        Task task = this.taTaskService.getTaskById(reqVO.getTaskId());
        AssertUtils.isNotNull((Object)task, (CrmExceptionType)ActivitiException.ACT_TASK_NOT_FOUND, (String[])new String[0]);
        Result resultSend = this.mdmPositionFeign.getPositionDetail(null, reqVO.getUserPosCode());
        MdmPositionDetailRespVo positionUser = (MdmPositionDetailRespVo)ApiResultUtil.objResult((Result)resultSend, (boolean)Boolean.TRUE);
        AssertUtils.isTrue((boolean)reqVO.getUserCode().equals(positionUser.getUser().getUserName()), (String)"\u5f53\u524d\u5c97\u4f4d\u4e0b\u4eba\u5458\u4e0d\u5339\u914d!");
        List<ActRuTaskEntity> taskList = this.actRuTaskMapper.selectAllByParent(task.getParentTaskId());
        int size = taskList.size();
        TaTaskCommunicateEntity taskCommunicate = this.taTaskCommunicateMapper.selectByTaskId(reqVO.getTaskId());
        AssertUtils.isTrue((boolean)taskCommunicate.getTargetUserCode().equals(reqVO.getUserCode()), (String)"\u6c9f\u901a\u4eba\u5458\u548c\u5f53\u524d\u64cd\u4f5c\u4eba\u5458\u4e0d\u5339\u914d!");
        TaProcessOptRecordEntity optRecord = new TaProcessOptRecordEntity();
        optRecord.setProcessInstId(task.getProcessInstanceId()).setTaskId(task.getId()).setTaskDefKey(task.getTaskDefinitionKey()).setTaskName(task.getName()).setUserCode(reqVO.getUserCode()).setUserName(positionUser.getUser().getFullName()).setPositionCode(positionUser.getPositionCode()).setPositionName(positionUser.getPositionName()).setProcessVersionKey(task.getProcessDefinitionId()).setOperation(IndicatorStr.PROCESS_BTN_REPLAY_MSG.getCode()).setContent(positionUser.getUser().getFullName() + "\u786e\u8ba4\u6c9f\u901a\uff0c\u5185\u5bb9:" + reqVO.getContent()).setCreateTime(new Date()).setSourceId(task.getId());
        this.actRuTaskMapper.deleteByPrimaryKey(reqVO.getTaskId());
        this.taProcessOptRecordService.save((Object)optRecord);
        taskCommunicate.setStatus(Indicator.COPY_TASK_STATUS_READ.getCode());
        this.taTaskCommunicateMapper.updateById((Object)taskCommunicate);
        if (size == 1) {
            this.runtimeService.activateProcessInstanceById(task.getProcessInstanceId());
        }
        return "\u64cd\u4f5c\u6210\u529f!";
    }
}

