/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.listener.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.activiti.Column;
import com.biz.crm.eunm.activiti.ColumnStr;
import com.biz.crm.listener.base.FlowListenerFactory;
import com.biz.crm.listener.mapper.TaListenerMapper;
import com.biz.crm.listener.vo.TaListenerQueryVO;
import com.biz.crm.nebular.activiti.listener.req.TaListenerProcReqVo;
import com.biz.crm.nebular.activiti.listener.req.TaListenerReqVo;
import com.biz.crm.nebular.activiti.listener.resp.TaListenerRespVo;
import com.biz.crm.util.AssertUtils;
import java.io.Serializable;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ListenerHelper {
    private static final Logger log = LoggerFactory.getLogger(ListenerHelper.class);
    @Resource
    private FlowListenerFactory flowListenerFactory;
    @Resource
    private TaListenerMapper taListenerMapper;

    public void saveCheck(TaListenerReqVo vo) {
        AssertUtils.isNotEmpty((String)vo.getListenerName(), (String)"\u76d1\u542c\u5668\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.isNotEmpty((String)vo.getListenerEvent(), (String)"\u76d1\u542c\u65b9\u6cd5\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isNotEmpty((String)vo.getListenerValue(), (String)"\u76d1\u542c\u5668\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isNotEmpty((String)vo.getListenerType(), (String)"\u76d1\u542c\u5668\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        try {
            AssertUtils.isNotNull((Object)this.flowListenerFactory.getListener(vo.getListenerValue()), (String)"\u76d1\u542c\u5668\u8def\u5f84\u4e0d\u5408\u6cd5\uff01");
        }
        catch (Exception e) {
            throw new BusinessException("\u76d1\u542c\u5668\u8def\u5f84" + vo.getListenerValue() + "\u4e0d\u5408\u6cd5\uff01");
        }
    }

    public void procSaveCheck(TaListenerProcReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getListenerId(), (String)"\u76d1\u542c\u5668ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isNotEmpty((String)reqVo.getNodeCode(), (String)"\u8282\u70b9ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isNotEmpty((String)reqVo.getProcessVersionKey(), (String)"\u6d41\u7a0b\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.isNotNull((Object)this.taListenerMapper.selectById((Serializable)((Object)reqVo.getListenerId())), (String)(reqVo.getListenerId() + "\u6307\u5411\u7684\u76d1\u542c\u5668\u4e0d\u5b58\u5728\uff01"));
    }

    public TaListenerRespVo convertValue(TaListenerRespVo taListenerRespVo) {
        taListenerRespVo.setListenerStateValue(Column.COMMON_STATE.getLabelByCode(taListenerRespVo.getListenerState()));
        taListenerRespVo.setTypeIdValue(Column.LISTENER_TYPE.getLabelByCode(taListenerRespVo.getTypeId()));
        taListenerRespVo.setListenerTypeValue(ColumnStr.LISTENER_VALUE_TYPE.getLabelByCode(taListenerRespVo.getListenerType()));
        return taListenerRespVo;
    }

    public TaListenerQueryVO convertValue(TaListenerQueryVO taListenerQueryVO) {
        taListenerQueryVO.setListenerStateValue(Column.COMMON_STATE.getLabelByCode(taListenerQueryVO.getListenerState()));
        taListenerQueryVO.setTypeIdValue(Column.LISTENER_TYPE.getLabelByCode(taListenerQueryVO.getTypeId()));
        taListenerQueryVO.setListenerTypeValue(ColumnStr.LISTENER_VALUE_TYPE.getLabelByCode(taListenerQueryVO.getListenerType()));
        return taListenerQueryVO;
    }
}

