/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.listener.process;

import com.biz.crm.act.model.TaActBaseEntity;
import com.biz.crm.act.model.TaActBaseProcessEntity;
import com.biz.crm.act.model.TaProcessOptRecordEntity;
import com.biz.crm.act.model.TaTaskCopyEntity;
import com.biz.crm.act.service.ITaProcessCopyService;
import com.biz.crm.act.service.ITaProcessOptRecordService;
import com.biz.crm.act.service.ITaTaskCopyService;
import com.biz.crm.activiti.constant.WorkFlowGlobals;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.eunm.activiti.Indicator;
import com.biz.crm.eunm.activiti.IndicatorStr;
import com.biz.crm.listener.base.BaseListener;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.nebular.activiti.task.resp.CopyProcessRspVO;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import jodd.util.StringUtil;
import org.activiti.engine.TaskService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessEndListener
extends BaseListener {
    private static final Logger log = LoggerFactory.getLogger(ProcessEndListener.class);
    private ITaProcessCopyService processCopyService;
    private ITaTaskCopyService taTaskCopyService;
    private ITaProcessOptRecordService taProcessOptRecordService;
    private TaskService taskService;

    public DelegateExecution toNotify(DelegateExecution execution) {
        this.initTaActBaseProcessService();
        this.initTaActBaseService();
        TaActBaseProcessEntity baseProcess = this.taActBaseProcessService.findActBaseByProcessInstId(execution.getProcessInstanceId());
        log.info(baseProcess.getProcessInstanceId() + "\u6267\u884c\u76d1\u542c\u5f00\u59cb,\u6d41\u7a0b\u72b6\u6001:" + baseProcess.getStatus());
        TaActBaseEntity actBaseEntity = (TaActBaseEntity)((Object)this.taActBaseService.getById((Serializable)((Object)baseProcess.getBaseId())));
        ActivitiCallBackVo callBackVo = new ActivitiCallBackVo();
        callBackVo.setFormNo(actBaseEntity.getFormKey());
        callBackVo.setProcessNo(baseProcess.getProcessNo());
        String optBtn = (String)execution.getVariable("optBtn");
        if (IndicatorStr.PROCESS_BTN_APPROVAL.getCode().equals(optBtn)) {
            this.taActBaseProcessService.updateProcessStatus(Indicator.ACT_BASE_STATUS_FINISH.getCode(), baseProcess.getProcessInstanceId(), new Date());
        }
        boolean cancelFlag = false;
        if (IndicatorStr.PROCESS_BTN_CANCEL.getCode().equals(optBtn) || baseProcess.getStatus().intValue() == Indicator.ACT_BASE_STATUS_CANCEL.getCode()) {
            callBackVo.setProcessState(Integer.valueOf(5));
            cancelFlag = true;
        } else if (IndicatorStr.PROCESS_BTN_END.getCode().equals(optBtn) || IndicatorStr.PROCESS_BTN_KILL.getCode().equals(optBtn)) {
            callBackVo.setProcessState(Integer.valueOf(4));
        } else {
            callBackVo.setProcessState(Integer.valueOf(2));
        }
        String rushProcessState = String.valueOf(execution.getVariable("rushProcessState"));
        if (StringUtils.isEmpty((String)rushProcessState) || !StringUtil.equals((String)rushProcessState, (String)"Y")) {
            if (WorkFlowGlobals.completeFlag.containsKey(baseProcess.getProcessInstanceId()) && GlobalWhetherEnum.YES.getCode().equals(WorkFlowGlobals.completeFlag.get(baseProcess.getProcessInstanceId()))) {
                log.info("\u6b64\u6d41\u7a0b\u5df2\u7ecf\u8c03\u7528\u8fc7\u56de\u8c03\u65b9\u6cd5\uff0c\u4e0d\u8fdb\u884c\u56de\u8c03");
            } else {
                log.info("\u6b64\u6d41\u7a0b\u5c1a\u672a\u8c03\u7528\u8fc7\u56de\u8c03\u65b9\u6cd5\uff0c\u8fdb\u884c\u56de\u8c03\u5e76\u8bb0\u5f55");
                log.info(baseProcess.getProcessInstanceId() + "\u6267\u884c\u76d1\u542c\u56de\u8c03,\u6d41\u7a0b\u72b6\u6001:" + baseProcess.getStatus() + "\u56de\u8c03\u63a5\u53e3:" + baseProcess.getCallBackFeign());
                this.initCallBackExecutionFeign(execution);
                Result result = this.callbackFeign.callback(callBackVo);
                if (!result.isSuccess()) {
                    log.info(baseProcess.getProcessInstanceId() + "\u6267\u884c\u76d1\u542c\u7ed3\u675f,\u6d41\u7a0b\u72b6\u6001:" + baseProcess.getStatus() + "\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff01\u8fd4\u56de\u6d88\u606f\uff1a" + result.getMessage());
                    throw new RuntimeException(baseProcess.getCallBackFeign() + "\u6267\u884c\u56de\u8c03\u5931\u8d25\uff01\u8fd4\u56de\u6d88\u606f\uff1a" + result.getMessage());
                }
                WorkFlowGlobals.completeFlag.put(baseProcess.getProcessInstanceId(), GlobalWhetherEnum.YES.getCode());
            }
        }
        if (!cancelFlag) {
            this.doCopyTaskByProcess(baseProcess.getProcessKey(), execution.getProcessInstanceId());
        }
        log.info(baseProcess.getProcessInstanceId() + "\u6267\u884c\u7ed3\u675f\u76d1\u542c,\u6d41\u7a0b\u72b6\u6001:" + baseProcess.getStatus());
        return execution;
    }

    private void doCopyTaskByProcess(final String processKey, final String processInstId) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(3000L);
                    ProcessEndListener.this.processCopyService = (ITaProcessCopyService)ProcessEndListener.this.applicationContext.getBean("taProcessCopyService");
                    List<CopyProcessRspVO> processCopyEntities = ProcessEndListener.this.processCopyService.findAllByProcessKey(processKey);
                    if (CollectionUtils.isNotEmpty(processCopyEntities)) {
                        ProcessEndListener.this.taTaskCopyService = (ITaTaskCopyService)ProcessEndListener.this.applicationContext.getBean("taTaskCopyService");
                        ProcessEndListener.this.taskService = (TaskService)ProcessEndListener.this.applicationContext.getBean("taskService");
                        ProcessEndListener.this.taProcessOptRecordService = (ITaProcessOptRecordService)ProcessEndListener.this.applicationContext.getBean("taProcessOptRecordService");
                        processCopyEntities.forEach(vo -> {
                            TaskInfo startTask = (TaskInfo)((TaskQuery)ProcessEndListener.this.taskService.createTaskQuery().taskDefinitionKey("DEFAULT_START")).list().get(0);
                            if (startTask != null) {
                                TaTaskCopyEntity taskCopy = new TaTaskCopyEntity();
                                taskCopy.setTaskId(startTask.getId()).setProcessInstId(processInstId).setTaskDefKey("CP:" + startTask.getTaskDefinitionKey()).setTaskName(startTask.getName()).setUserCode(vo.getUserCode()).setUserName(vo.getUserName()).setPosCode(vo.getPosCode()).setPosName(vo.getPosName()).setFromUser("system_auto").setFromUserName("\u7cfb\u7edf\u81ea\u52a8\u6284\u9001").setFromPosCode("system_auto").setFromPosName("\u7cfb\u7edf\u81ea\u52a8\u6284\u9001").setStatus(Indicator.COPY_TASK_STATUS_UNREAD.getCode());
                                ProcessEndListener.this.taTaskCopyService.save((Object)taskCopy);
                                TaProcessOptRecordEntity optRecord = new TaProcessOptRecordEntity();
                                optRecord.setProcessInstId(taskCopy.getProcessInstId()).setTaskId(taskCopy.getId()).setTaskDefKey(taskCopy.getTaskDefKey()).setTaskName("\u7cfb\u7edf\u81ea\u52a8\u6284\u9001").setUserCode(vo.getUserCode()).setUserName(vo.getUserName()).setPositionCode(vo.getPosCode()).setPositionName(vo.getUserName()).setProcessVersionKey(startTask.getProcessDefinitionId()).setOperation(IndicatorStr.PROCESS_BTN_COPY.getCode()).setContent("\u7cfb\u7edf\u81ea\u52a8\u6284\u9001\u7ed9:" + vo.getUserName()).setCreateTime(new Date()).setSourceId(taskCopy.getId());
                                ProcessEndListener.this.taProcessOptRecordService.save((Object)optRecord);
                            }
                        });
                    }
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        }).start();
    }
}

