/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.controller;

import com.biz.crm.activiti.service.OperateActivitiService;
import com.biz.crm.activiti.vo.ActReModel;
import com.biz.crm.activiti.vo.ListByKeyVo;
import com.biz.crm.activiti.vo.ReProcdef;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.activiti.bpmn.converter.BpmnXMLConverter;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.editor.language.json.converter.BpmnJsonConverter;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Deployment;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u5de5\u4f5c\u6d41\u8bbe\u8ba1", tags={"\u5de5\u4f5c\u6d41\u8bbe\u8ba1"})
@RestController
@RequestMapping(value={"/operateActivitiController"})
public class OperateActivitiController {
    private static final Logger log = LoggerFactory.getLogger(OperateActivitiController.class);
    @Autowired
    private OperateActivitiService operateActivitiService;
    @Autowired
    private RepositoryService repositoryService;

    @CrmLog
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u8bbe\u8ba1\u6d41\u7a0b")
    @PostMapping(value={"list"})
    public Result<PageResult<ActReModel>> list(@RequestBody ActReModel actReModel) {
        return Result.ok(this.operateActivitiService.list(actReModel));
    }

    @ApiOperation(value="\u6d41\u7a0b\u53d1\u5e03")
    @GetMapping(value={"deployment"})
    @CrmLog
    public Result deployment(@RequestParam(value="id") String id) throws Exception {
        Model modelData = this.repositoryService.getModel(id);
        byte[] bytes = this.repositoryService.getModelEditorSource(modelData.getId());
        if (bytes == null) {
            return Result.error((String)"\u6a21\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u8bbe\u8ba1\u6d41\u7a0b\u5e76\u6210\u529f\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u53d1\u5e03\u3002");
        }
        JsonNode modelNode = new ObjectMapper().readTree(bytes);
        BpmnModel model = new BpmnJsonConverter().convertToBpmnModel(modelNode);
        if (model.getProcesses().size() == 0) {
            return Result.error((String)"\u6570\u636e\u6a21\u578b\u4e0d\u7b26\u8981\u6c42\uff0c\u8bf7\u81f3\u5c11\u8bbe\u8ba1\u4e00\u6761\u4e3b\u7ebf\u6d41\u7a0b\u3002");
        }
        byte[] bpmnBytes = new BpmnXMLConverter().convertToXML(model);
        String processName = modelData.getName() + ".bpmn20.xml";
        Deployment deployment = this.repositoryService.createDeployment().name(modelData.getName()).addString(processName, new String(bpmnBytes, "UTF-8")).deploy();
        modelData.setDeploymentId(deployment.getId());
        this.repositoryService.saveModel(modelData);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49KEY\u67e5\u8be2\u6d41\u7a0b\u5386\u53f2\u7248\u672c\u53f7")
    @PostMapping(value={"listByKey"})
    public Result<PageResult<ReProcdef>> listByKey(@RequestBody ListByKeyVo listByKeyVo) {
        Result resultResult = new Result();
        if (StringUtils.isEmpty((String)listByKeyVo.getKey())) {
            resultResult.error500("\u8bf7\u4f20\u5165\u6d41\u7a0b\u5b9a\u4e49key");
            return resultResult;
        }
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(listByKeyVo.getKey()).listPage(listByKeyVo.getPageSize() * (listByKeyVo.getPageNum() - 1), listByKeyVo.getPageSize().intValue());
        long count = this.repositoryService.createProcessDefinitionQuery().count();
        ArrayList<ReProcdef> list = new ArrayList<ReProcdef>();
        for (ProcessDefinition processDefinition : processDefinitions) {
            ReProcdef reProcdef = new ReProcdef(processDefinition);
            list.add(reProcdef);
        }
        resultResult.setResult((Object)PageResult.builder().data(list).count(Long.valueOf(count)).build());
        return resultResult;
    }

    @ApiOperation(value="\u5220\u9664\u6d41\u7a0b\u6a21\u578b")
    @GetMapping(value={"deleteById"})
    @CrmLog
    public Result deleteById(@RequestParam(value="id") String id) {
        this.repositoryService.deleteModel(id);
        return Result.ok();
    }
}

