/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.activiti.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.activiti.entity.ActivitiBusinessEntity;
import com.biz.crm.activiti.mapper.ActivitiCurrentTaskMapper;
import com.biz.crm.activiti.service.ActivitiBusinessService;
import com.biz.crm.activiti.service.ActivitiTaskService;
import com.biz.crm.activiti.service.ActivityTaskUtil;
import com.biz.crm.activiti.service.BizRuntimeService;
import com.biz.crm.activiti.vo.ActivitiBusinessVo;
import com.biz.crm.activiti.vo.ActivitiCurrentTaskVo;
import com.biz.crm.activiti.vo.BpmQueryVo;
import com.biz.crm.activiti.vo.CompleteTaskVo;
import com.biz.crm.activiti.vo.CurrentTaskVo;
import com.biz.crm.activiti.vo.CurrentVo;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.ApiResultUtil;
import com.biz.crm.base.BusinessException;
import com.biz.crm.bpmlog.service.ActivitiBpmlogService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.activiti.ActivitiOperateTypeEnum;
import com.biz.crm.mdm.bpmrole.MdmBpmRoleFeign;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.PositionUtil;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngineConfiguration;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.image.ProcessDiagramGenerator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BizRuntimeServiceImpl
implements BizRuntimeService {
    private static final Logger log = LoggerFactory.getLogger(BizRuntimeServiceImpl.class);
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessEngineConfiguration processEngineConfiguration;
    @Autowired
    private ActivitiBusinessService activitiBusinessService;
    @Autowired
    private ActivitiBpmlogService activitiBpmlogService;
    @Autowired
    private ActivitiTaskService activitiTaskService;
    @Autowired
    private ActivityTaskUtil activityTaskUtil;
    @Resource
    private ActivitiCurrentTaskMapper activitiCurrentTaskMapper;
    @Resource
    private MdmBpmRoleFeign mdmBpmRoleFeign;

    private ProcessInstance startProcessInstanceByKey(String processKey, String businessObjIdOrNum, Map<String, Object> variables) {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(processKey, businessObjIdOrNum, variables);
        return processInstance;
    }

    @Override
    @Klock(keys={"#activitiBusinessVo.businessIdOrNum"}, waitTime=60L, leaseTime=300L)
    public String startProcess(ActivitiBusinessVo activitiBusinessVo) {
        UserRedis userRedis = UserUtils.getUser();
        log.info("\u63d0\u4ea4\u5de5\u4f5c\u6d41", (Object)activitiBusinessVo);
        this.checkStartProcess(activitiBusinessVo, userRedis);
        this.identityService.setAuthenticatedUserId(activitiBusinessVo.getPositionCode());
        Map<String, Object> variables = activitiBusinessVo.getVariables();
        if (activitiBusinessVo.getVariables() != null && !activitiBusinessVo.getVariables().isEmpty()) {
            variables.putAll(activitiBusinessVo.getVariables());
        }
        variables.put("COMMIT_ORG_", userRedis.getOrgcode());
        variables.put("COMMIT_POS_", userRedis.getPoscode());
        ProcessInstance processInstance = this.startProcessInstanceByKey(activitiBusinessVo.getProcessKey(), activitiBusinessVo.getBusinessIdOrNum(), variables);
        if (processInstance == null) {
            throw new BusinessException("\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25");
        }
        if (StringUtils.isEmpty((CharSequence)processInstance.getId())) {
            throw new BusinessException("\u53d1\u8d77\u6d41\u7a0b\u5931\u8d25");
        }
        ActivitiBusinessEntity entity = this.activitiBusinessService.save(processInstance.getId(), ActivitiOperateTypeEnum.COMMIT.getCode(), activitiBusinessVo.getBusinessIdOrNum());
        StringBuffer buffer = new StringBuffer();
        buffer.append(userRedis.getRealname()).append("[").append(activitiBusinessVo.getPositionCode()).append("]").append("\u53d1\u8d77\u6d41\u7a0b");
        ActivitiCurrentTaskVo currentTaskVo = new ActivitiCurrentTaskVo(entity.getCrmProcessInstanceId(), entity.getProcessInstanceId(), "5", activitiBusinessVo.getProcessTitle(), userRedis.getRealname(), activitiBusinessVo.getPositionCode());
        this.activitiTaskService.saveTask(currentTaskVo);
        ProcessInstance processInstanceNow = this.activityTaskUtil.getProcessInstance(entity.getProcessInstanceId(), null);
        if (processInstanceNow != null) {
            CurrentVo currentVo = this.activityTaskUtil.getCurrentVo(entity.getProcessInstanceId(), null);
            this.saveCurrentTask(currentVo, currentTaskVo);
        }
        this.activitiBpmlogService.commomSaveLog(entity.getCrmProcessInstanceId(), entity.getProcessInstanceId(), activitiBusinessVo.getBusinessIdOrNum(), buffer.toString(), ActivitiOperateTypeEnum.START.getCode());
        return entity.getCrmProcessInstanceId();
    }

    private void saveCurrentTask(CurrentVo currentVo, ActivitiCurrentTaskVo vo) {
        Set<String> bpmRoleCode;
        if (currentVo == null) {
            return;
        }
        Set<String> positionCode = currentVo.getPositionCode();
        if (positionCode != null && !positionCode.isEmpty()) {
            positionCode.forEach(item -> {
                ActivitiCurrentTaskVo currentTaskVo = new ActivitiCurrentTaskVo();
                BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)currentTaskVo));
                currentTaskVo.setDateType("1");
                currentTaskVo.setPositionCode((String)item);
                currentTaskVo.setBpmRoeCode(null);
                this.activitiTaskService.saveTask(currentTaskVo);
            });
        }
        if ((bpmRoleCode = currentVo.getBpmRoleCode()) != null && !bpmRoleCode.isEmpty()) {
            bpmRoleCode.forEach(item -> {
                ActivitiCurrentTaskVo currentTaskVo = new ActivitiCurrentTaskVo();
                BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)currentTaskVo));
                currentTaskVo.setDateType("1");
                currentTaskVo.setPositionCode(null);
                currentTaskVo.setBpmRoeCode((String)item);
                this.activitiTaskService.saveTask(currentTaskVo);
            });
        }
    }

    private void checkStartProcess(ActivitiBusinessVo activitiBusinessVo, UserRedis userRedis) {
        if (StringUtils.isEmpty((CharSequence)activitiBusinessVo.getProcessKey())) {
            throw new BusinessException("\u8bf7\u6307\u5b9a\u9700\u8981\u63d0\u4ea4\u7684\u6d41\u7a0b\u3010processKey\u3011");
        }
        if (StringUtils.isEmpty((CharSequence)activitiBusinessVo.getBusinessIdOrNum())) {
            throw new BusinessException("\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\u3010businessIdOrNum\u3011");
        }
        if (StringUtils.isEmpty((CharSequence)activitiBusinessVo.getPositionCode())) {
            throw new BusinessException("\u5f53\u524d\u63d0\u4ea4\u4eba\u4e0d\u80fd\u4e3a\u7a7a\u3010positionCode\u3011");
        }
        this.activityTaskUtil.checkRepeatCommit(activitiBusinessVo.getBusinessIdOrNum());
    }

    @Override
    public PageResult<CurrentTaskVo> listByPositionCode(BpmQueryVo bpmQueryVo) {
        String positionCode = bpmQueryVo.getPositionCode();
        if (StringUtils.isEmpty((CharSequence)positionCode)) {
            UserRedis userRedis = UserUtils.getUser();
            positionCode = userRedis.getPoscode();
        }
        AssertUtils.isNotEmpty((String)positionCode, (String)"\u5f53\u524d\u767b\u5f55\u4eba\u672a\u83b7\u53d6\u5230\u804c\u4f4d\u4fe1\u606f");
        ArrayList<String> positionCodes = new ArrayList<String>();
        positionCodes.add(positionCode);
        Set bpmRoleCodeSet = (Set)ApiResultUtil.objResult((Result)this.mdmBpmRoleFeign.findBpmRoleCodeSetByPositionCodeList(positionCodes), (boolean)true);
        bpmRoleCodeSet = bpmRoleCodeSet == null ? new HashSet() : bpmRoleCodeSet;
        Page page = PageUtil.buildPage((Integer)bpmQueryVo.getPageNum(), (Integer)bpmQueryVo.getPageSize());
        List<CurrentTaskVo> list = this.activitiCurrentTaskMapper.listByPositionCode(page, positionCode, new ArrayList<String>(bpmRoleCodeSet));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<CurrentTaskVo> listMyBpm(BpmQueryVo bpmQueryVo) {
        UserRedis userRedis = UserUtils.getUser();
        List positionRespVos = PositionUtil.getAllPositionByUsername((String)userRedis.getUsername());
        HashSet<String> set = new HashSet<String>();
        for (MdmPositionRespVo item : positionRespVos) {
            set.add(item.getPositionCode());
        }
        Page page = PageUtil.buildPage((Integer)bpmQueryVo.getPageNum(), (Integer)bpmQueryVo.getPageSize());
        List<CurrentTaskVo> list = this.activitiCurrentTaskMapper.listMyBpm(page, new ArrayList<String>(set));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<CurrentTaskVo> listMyRejectBpm(BpmQueryVo bpmQueryVo) {
        UserRedis userRedis = UserUtils.getUser();
        List positionRespVos = PositionUtil.getAllPositionByUsername((String)userRedis.getUsername());
        HashSet<String> set = new HashSet<String>();
        for (MdmPositionRespVo item : positionRespVos) {
            set.add(item.getPositionCode());
        }
        Page page = PageUtil.buildPage((Integer)bpmQueryVo.getPageNum(), (Integer)bpmQueryVo.getPageSize());
        List<CurrentTaskVo> list = this.activitiCurrentTaskMapper.listMyBpm(page, new ArrayList<String>(set));
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public InputStream getProcessInstancePicInfo(String processInstanceId) {
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processInstance.getProcessDefinitionId());
        Context.setProcessEngineConfiguration((ProcessEngineConfigurationImpl)((ProcessEngineConfigurationImpl)this.processEngineConfiguration));
        ProcessDiagramGenerator diagramGenerator = this.processEngineConfiguration.getProcessDiagramGenerator();
        ProcessDefinitionEntity definitionEntity = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(processInstance.getProcessDefinitionId());
        List highLightedActivitList = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
        ArrayList<String> highLightedActivitis = new ArrayList<String>();
        List<String> highLightedFlows = this.activityTaskUtil.getHighLightedFlows(definitionEntity, highLightedActivitList);
        for (HistoricActivityInstance tempActivity : highLightedActivitList) {
            String activityId = tempActivity.getActivityId();
            highLightedActivitis.add(activityId);
        }
        InputStream imageStream = diagramGenerator.generateDiagram(bpmnModel, "png", highLightedActivitis, highLightedFlows, "\u5b8b\u4f53", "\u5b8b\u4f53", "\u5b8b\u4f53", null, 1.0);
        return imageStream;
    }

    @Override
    public void completeTasks(CompleteTaskVo completeTaskVo) {
        if (StringUtils.isEmpty((CharSequence)completeTaskVo.getTaskId())) {
            throw new BusinessException("\u8282\u70b9\u4efb\u52a1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)completeTaskVo.getCrmProcessInstanceId())) {
            throw new BusinessException("\u6d41\u7a0b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (completeTaskVo.getPass() == null) {
            throw new BusinessException("\u8bf7\u660e\u786e\u5f53\u524d\u64cd\u4f5c\u7c7b\u578bpass\u5fc5\u987b\u8f93\u5165");
        }
        log.info("\u5b8c\u6210\u4efb\u52a1\u53c2\u6570\uff1ataskId={} ,params={}", (Object)completeTaskVo);
        HashMap<String, Boolean> variables = completeTaskVo.getVariables();
        variables = variables == null ? new HashMap<String, Boolean>() : variables;
        variables.put("pass", completeTaskVo.getPass());
        this.taskService.setVariablesLocal(completeTaskVo.getTaskId(), variables);
        this.taskService.addComment(completeTaskVo.getTaskId(), completeTaskVo.getCrmProcessInstanceId(), completeTaskVo.getRemarks());
        this.taskService.setOwner(completeTaskVo.getTaskId(), completeTaskVo.getPositionCode());
        this.taskService.complete(completeTaskVo.getTaskId(), variables);
        log.info("\u5b8c\u6210\u4efb\u52a1\uff1a\u4efb\u52a1ID\uff1a" + completeTaskVo.getTaskId());
    }
}

