/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.design.controller;

import com.biz.crm.activiti.service.BizRuntimeService;
import com.biz.crm.design.util.ToWeb;
import com.biz.crm.design.vo.SaveModelVo;
import com.biz.crm.util.HttpServletRequestUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.activiti.editor.constants.ModelDataJsonConstants;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.Model;
import org.activiti.engine.repository.ProcessDefinition;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/designController"})
public class DesignController
implements ModelDataJsonConstants {
    private static final Logger log = LoggerFactory.getLogger(DesignController.class);
    @Resource
    private RepositoryService repositoryService;
    @Autowired
    private BizRuntimeService bizRuntimeService;
    @Autowired
    private ObjectMapper objectMapper;

    @ResponseBody
    @PostMapping(value={"newModel"})
    public Object newModel() throws UnsupportedEncodingException {
        Model model = this.repositoryService.newModel();
        String name = "new-process";
        String description = "";
        int revision = 1;
        String key = "process";
        ObjectNode modelNode = this.objectMapper.createObjectNode();
        modelNode.put("name", name);
        modelNode.put("description", description);
        modelNode.put("revision", revision);
        model.setName(name);
        model.setKey(key);
        model.setMetaInfo(modelNode.toString());
        this.repositoryService.saveModel(model);
        String id = model.getId();
        ObjectNode editorNode = this.objectMapper.createObjectNode();
        editorNode.put("id", "canvas");
        editorNode.put("resourceId", "canvas");
        ObjectNode stencilSetNode = this.objectMapper.createObjectNode();
        stencilSetNode.put("namespace", "http://b3mn.org/stencilset/bpmn2.0#");
        editorNode.put("stencilset", (JsonNode)stencilSetNode);
        this.repositoryService.addModelEditorSource(id, editorNode.toString().getBytes("utf-8"));
        return ToWeb.buildResult().redirectUrl("/activiti/designController/editor?modelId=" + id);
    }

    @GetMapping(value={"editor"})
    public ModelAndView modelOpen() {
        ModelAndView model = new ModelAndView("modeler");
        return model;
    }

    @RequestMapping(value={"/model/{modelId}/json"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ObjectNode getEditorJson(@PathVariable String modelId) {
        ObjectNode modelNode = null;
        Model model = this.repositoryService.getModel(modelId);
        if (model != null) {
            try {
                if (StringUtils.isNotEmpty((CharSequence)model.getMetaInfo())) {
                    modelNode = (ObjectNode)this.objectMapper.readTree(model.getMetaInfo());
                } else {
                    modelNode = this.objectMapper.createObjectNode();
                    modelNode.put("name", model.getName());
                }
                modelNode.put("modelId", model.getId());
                ObjectNode editorJsonNode = (ObjectNode)this.objectMapper.readTree(new String(this.repositoryService.getModelEditorSource(model.getId()), "utf-8"));
                modelNode.put("model", (JsonNode)editorJsonNode);
            }
            catch (Exception e) {
                log.error("Error creating model JSON", (Throwable)e);
                throw new ActivitiException("Error creating model JSON", (Throwable)e);
            }
        }
        return modelNode;
    }

    @RequestMapping(value={"/editor/stencilset"}, method={RequestMethod.GET}, produces={"application/json;charset=utf-8"})
    @ResponseBody
    public String getStencilset() {
        InputStream stencilsetStream = this.getClass().getClassLoader().getResourceAsStream("stencilset.json");
        try {
            return IOUtils.toString((InputStream)stencilsetStream, (String)"utf-8");
        }
        catch (Exception e) {
            throw new ActivitiException("Error while loading stencil set", (Throwable)e);
        }
    }

    @PostMapping(value={"/model/{modelId}/save"})
    @ResponseStatus(value=HttpStatus.OK)
    public void saveModel(@PathVariable String modelId, @RequestBody SaveModelVo saveModelVo) {
        try {
            Model model = this.repositoryService.getModel(modelId);
            ObjectNode modelJson = (ObjectNode)this.objectMapper.readTree(model.getMetaInfo());
            modelJson.put("name", saveModelVo.getName());
            modelJson.put("description", saveModelVo.getDescription());
            model.setMetaInfo(modelJson.toString());
            model.setName(saveModelVo.getName());
            this.repositoryService.saveModel(model);
            this.repositoryService.addModelEditorSource(model.getId(), saveModelVo.getJson_xml().getBytes("utf-8"));
            ByteArrayInputStream svgStream = new ByteArrayInputStream(saveModelVo.getSvg_xml().getBytes("utf-8"));
            TranscoderInput input = new TranscoderInput((InputStream)svgStream);
            PNGTranscoder transcoder = new PNGTranscoder();
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            TranscoderOutput output = new TranscoderOutput((OutputStream)outStream);
            transcoder.transcode(input, output);
            byte[] result = outStream.toByteArray();
            this.repositoryService.addModelEditorSourceExtra(model.getId(), result);
            outStream.close();
        }
        catch (Exception e) {
            log.error("Error saving model", (Throwable)e);
            throw new ActivitiException("Error saving model", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"showPic"})
    @ResponseStatus(value=HttpStatus.OK)
    public void showPic(@RequestParam(value="deploymentId") String deploymentId) throws IOException {
        HttpServletResponse httpServletResponse = HttpServletRequestUtil.getResponse();
        String ext = ".png";
        if (StringUtils.isEmpty((CharSequence)deploymentId) || StringUtils.isEmpty((CharSequence)ext)) {
            return;
        }
        InputStream in = null;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).singleResult();
        if (".png".equalsIgnoreCase(ext)) {
            in = this.repositoryService.getProcessDiagram(processDefinition.getId());
        } else if (".bpmn".equalsIgnoreCase(ext)) {
            in = this.repositoryService.getResourceAsStream(deploymentId, processDefinition.getResourceName());
        }
        ServletOutputStream out = null;
        byte[] buf = new byte[1024];
        int legth = 0;
        try {
            out = httpServletResponse.getOutputStream();
            while ((legth = in.read(buf)) != -1) {
                out.write(buf, 0, legth);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"showBpmn"})
    @ResponseStatus(value=HttpStatus.OK)
    public void showBpmn(@RequestParam(value="deploymentId") String deploymentId) throws IOException {
        HttpServletResponse httpServletResponse = HttpServletRequestUtil.getResponse();
        httpServletResponse.setContentType("UTF-8");
        httpServletResponse.setCharacterEncoding("UTF-8");
        String ext = ".bpmn";
        if (StringUtils.isEmpty((CharSequence)deploymentId) || StringUtils.isEmpty((CharSequence)ext)) {
            return;
        }
        InputStream in = null;
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).singleResult();
        if (".png".equalsIgnoreCase(ext)) {
            in = this.repositoryService.getProcessDiagram(processDefinition.getId());
        } else if (".bpmn".equalsIgnoreCase(ext)) {
            in = this.repositoryService.getResourceAsStream(deploymentId, processDefinition.getResourceName());
        }
        ServletOutputStream out = null;
        byte[] buf = new byte[1024];
        int legth = 0;
        try {
            out = httpServletResponse.getOutputStream();
            while ((legth = in.read(buf)) != -1) {
                out.write(buf, 0, legth);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    @GetMapping(value={"getProcessPicInfo"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u56fe\u7247\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInstanceId", value="\u6d41\u7a0b\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @ResponseStatus(value=HttpStatus.OK)
    public void getProcessPicInfo(@RequestParam(value="processInstanceId", required=true) String processInstanceId) {
        HttpServletResponse response = HttpServletRequestUtil.getResponse();
        response.setContentType("UTF-8");
        response.setCharacterEncoding("UTF-8");
        try {
            InputStream is = this.bizRuntimeService.getProcessInstancePicInfo(processInstanceId);
            int len = 0;
            byte[] b = new byte[1024];
            while ((len = is.read(b, 0, 1024)) != -1) {
                response.getOutputStream().write(b, 0, len);
            }
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
    }
}

